/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.perk.PerkEffectHelper;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktSyncModifierSource
extends ASPacket<PktSyncModifierSource> {
    private ModifierSource source;
    private ModifierSource newSource;
    private ActionType actionType;

    public PktSyncModifierSource() {
    }

    private PktSyncModifierSource(ModifierSource source, ModifierSource newSource, ActionType actionType) {
        this.source = source;
        this.newSource = newSource;
        this.actionType = actionType;
    }

    public static PktSyncModifierSource add(ModifierSource source) {
        return new PktSyncModifierSource(source, null, ActionType.ADD);
    }

    public static PktSyncModifierSource remove(ModifierSource source) {
        return new PktSyncModifierSource(source, null, ActionType.REMOVE);
    }

    public static PktSyncModifierSource update(ModifierSource existing, ModifierSource newSource) {
        return new PktSyncModifierSource(existing, newSource, ActionType.UPDATE);
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktSyncModifierSource> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeOptional(buffer, packet.source, ByteBufUtils::writeModifierSource);
            ByteBufUtils.writeOptional(buffer, packet.newSource, ByteBufUtils::writeModifierSource);
            ByteBufUtils.writeEnumValue(buffer, packet.actionType);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktSyncModifierSource> decoder() {
        return buffer -> {
            PktSyncModifierSource pkt = new PktSyncModifierSource();
            pkt.source = ByteBufUtils.readOptional(buffer, ByteBufUtils::readModifierSource);
            pkt.newSource = ByteBufUtils.readOptional(buffer, ByteBufUtils::readModifierSource);
            pkt.actionType = ByteBufUtils.readEnumValue(buffer, ActionType.class);
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktSyncModifierSource> handler() {
        return new ASPacket.Handler<PktSyncModifierSource>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktSyncModifierSource packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (player == null) {
                        return;
                    }
                    switch (packet.actionType) {
                        case UPDATE: {
                            PerkEffectHelper.updateSource((PlayerEntity)player, LogicalSide.CLIENT, packet.source, packet.newSource);
                            break;
                        }
                        case ADD: {
                            PerkEffectHelper.modifySource((PlayerEntity)player, LogicalSide.CLIENT, packet.source, PerkEffectHelper.Action.ADD);
                            break;
                        }
                        case REMOVE: {
                            PerkEffectHelper.modifySource((PlayerEntity)player, LogicalSide.CLIENT, packet.source, PerkEffectHelper.Action.REMOVE);
                        }
                    }
                });
            }

            @Override
            public void handle(PktSyncModifierSource packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }

    private static enum ActionType {
        ADD,
        REMOVE,
        UPDATE;

    }
}

