/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.server;

import hellfirepvp.astralsorcery.client.util.MiscPlayEffect;
import hellfirepvp.astralsorcery.common.auxiliary.BlockBreakHelper;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.aoe.CEffectAevitas;
import hellfirepvp.astralsorcery.common.item.lens.ItemColoredLensFire;
import hellfirepvp.astralsorcery.common.item.wand.ItemWand;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.starlight.network.handler.BlockTransmutationHandler;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.tile.TileChalice;
import hellfirepvp.astralsorcery.common.tile.TileFountain;
import hellfirepvp.astralsorcery.common.tile.TileInfuser;
import hellfirepvp.astralsorcery.common.tile.TileTreeBeacon;
import hellfirepvp.astralsorcery.common.tile.altar.TileAltar;
import hellfirepvp.astralsorcery.common.util.CelestialStrike;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.time.TimeStopEffectHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PktPlayEffect
extends ASPacket<PktPlayEffect> {
    private Type type;
    private Consumer<PacketBuffer> encoder;
    private PacketBuffer data;

    public PktPlayEffect() {
        this.encoder = buf -> {};
        this.data = null;
    }

    public PktPlayEffect(Type type) {
        this.encoder = buf -> {};
        this.data = null;
        this.type = type;
    }

    public PktPlayEffect addData(Consumer<PacketBuffer> encoder) {
        this.encoder = this.encoder.andThen(encoder);
        return this;
    }

    public PacketBuffer getExtraData() {
        return this.data;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktPlayEffect> encoder() {
        return (packet, buffer) -> {
            ByteBufUtils.writeEnumValue(buffer, packet.type);
            packet.encoder.accept((PacketBuffer)buffer);
        };
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktPlayEffect> decoder() {
        return buffer -> {
            Type type = ByteBufUtils.readEnumValue(buffer, Type.class);
            PktPlayEffect pkt = new PktPlayEffect(type);
            ByteBuf buf = Unpooled.buffer((int)buffer.readableBytes());
            buffer.readBytes(buf);
            pkt.data = new PacketBuffer(buf);
            return pkt;
        };
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktPlayEffect> handler() {
        return new ASPacket.Handler<PktPlayEffect>(){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void handleClient(PktPlayEffect packet, NetworkEvent.Context context) {
                context.enqueueWork(() -> packet.type.runEffect().accept(packet));
            }

            @Override
            public void handle(PktPlayEffect packet, NetworkEvent.Context context, LogicalSide side) {
            }
        };
    }

    public static enum Type {
        LIGHTNING,
        BEAM_BREAK,
        BLOCK_EFFECT,
        BLOCK_EFFECT_TUMBLE,
        ROCK_CRYSTAL_COLUMN,
        ROCK_CRYSTAL_SPARKS,
        SMALL_CRYSTAL_BREAK,
        GEM_CRYSTAL_BREAK,
        CROP_GROWTH,
        MELT_BLOCK,
        CELESTIAL_STRIKE,
        ALTAR_RECIPE_FINISH,
        INFUSER_RECIPE_FINISH,
        BLOCK_TRANSMUTATION_TICK,
        TIME_FREEZE_EFFECT,
        LIQUID_FOUNTAIN,
        CONSTELLATION_EFFECT_PING,
        BLOCK_HARVEST_DRAW,
        GATEWAY_REVOKE_EFFECT,
        LIQUID_INTERACTION_LINE,
        FOUNTAIN_TRANSITION_SEGMENT,
        FOUNTAIN_REPLACE_EFFECT;


        @OnlyIn(value=Dist.CLIENT)
        private Consumer<PktPlayEffect> runEffect() {
            switch (this) {
                case LIGHTNING: {
                    return MiscPlayEffect::fireLightning;
                }
                case ROCK_CRYSTAL_COLUMN: {
                    return ItemWand::playEffect;
                }
                case ROCK_CRYSTAL_SPARKS: {
                    return ItemWand::playUndergroundEffect;
                }
                case SMALL_CRYSTAL_BREAK: {
                    return MiscPlayEffect::catalystBurst;
                }
                case GEM_CRYSTAL_BREAK: {
                    return MiscPlayEffect::gemCrystalBurst;
                }
                case CROP_GROWTH: {
                    return CEffectAevitas::playParticles;
                }
                case TIME_FREEZE_EFFECT: {
                    return TimeStopEffectHelper::playEntityParticles;
                }
                case BEAM_BREAK: {
                    return BlockBreakHelper::blockBreakAnimation;
                }
                case BLOCK_EFFECT: {
                    return MiscPlayEffect::playBlockEffects;
                }
                case BLOCK_EFFECT_TUMBLE: {
                    return MiscPlayEffect::playTumbleBlockEffects;
                }
                case MELT_BLOCK: {
                    return ItemColoredLensFire::playParticles;
                }
                case CELESTIAL_STRIKE: {
                    return CelestialStrike::playEffect;
                }
                case ALTAR_RECIPE_FINISH: {
                    return TileAltar::finishCraftingEffects;
                }
                case INFUSER_RECIPE_FINISH: {
                    return TileInfuser::finishCraftingEffects;
                }
                case BLOCK_TRANSMUTATION_TICK: {
                    return BlockTransmutationHandler::playTransmutation;
                }
                case LIQUID_FOUNTAIN: {
                    return MiscPlayEffect::liquidFountain;
                }
                case CONSTELLATION_EFFECT_PING: {
                    return ConstellationEffect::playConstellationPing;
                }
                case BLOCK_HARVEST_DRAW: {
                    return TileTreeBeacon::playDrawParticles;
                }
                case GATEWAY_REVOKE_EFFECT: {
                    return TileCelestialGateway::playAccessRevokeEffect;
                }
                case LIQUID_INTERACTION_LINE: {
                    return TileChalice::drawLiquidLine;
                }
                case FOUNTAIN_TRANSITION_SEGMENT: {
                    return TileFountain::playTransitionEffect;
                }
                case FOUNTAIN_REPLACE_EFFECT: {
                    return TileFountain::replaceEffect;
                }
            }
            return pkt -> {};
        }
    }
}

