/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet;

import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantmentHelper;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantmentHelper;
import hellfirepvp.astralsorcery.common.event.DynamicEnchantmentEvent;
import hellfirepvp.astralsorcery.common.item.ItemEnchantmentAmulet;
import hellfirepvp.observerlib.common.util.tick.ITickHandler;
import java.util.EnumSet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.event.TickEvent;

public class PlayerAmuletHandler
implements ITickHandler {
    public static final PlayerAmuletHandler INSTANCE = new PlayerAmuletHandler();

    private PlayerAmuletHandler() {
    }

    public static void onEnchantmentAdd(DynamicEnchantmentEvent.Add event) {
        if (!DynamicEnchantmentHelper.canHaveDynamicEnchantment(event.getEnchantedItemStack())) {
            return;
        }
        Tuple<ItemStack, PlayerEntity> linkedAmulet = AmuletEnchantmentHelper.getWornAmulet(event.getEnchantedItemStack());
        if (linkedAmulet == null || ((ItemStack)linkedAmulet.func_76341_a()).func_190926_b() || linkedAmulet.func_76340_b() == null) {
            return;
        }
        event.getEnchantmentsToApply().addAll(ItemEnchantmentAmulet.getAmuletEnchantments((ItemStack)linkedAmulet.func_76341_a()));
    }

    public void tick(TickEvent.Type type, Object ... context) {
        PlayerEntity player = (PlayerEntity)context[0];
        this.applyAmuletTags(player);
        this.clearAmuletTags(player);
    }

    private void applyAmuletTags(PlayerEntity player) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            AmuletEnchantmentHelper.applyAmuletOwner(player.func_184582_a(slot), player);
        }
    }

    private void clearAmuletTags(PlayerEntity player) {
        AmuletEnchantmentHelper.removeAmuletTagsAndCleanup(player, true);
    }

    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public String getName() {
        return "PlayerAmuletHandler";
    }
}

