/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.nojson.fountain;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.RefreshFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.effect.vfx.FXSpritePlane;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.common.block.tile.fountain.BlockFountainPrime;
import hellfirepvp.astralsorcery.common.crafting.nojson.fountain.FountainEffect;
import hellfirepvp.astralsorcery.common.crafting.nojson.fountain.LiquidContext;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.CapabilitiesAS;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.tile.TileFountain;
import hellfirepvp.astralsorcery.common.util.BlockDropCaptureAssist;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;

public class FountainEffectLiquid
extends FountainEffect<LiquidContext> {
    public FountainEffectLiquid() {
        super(AstralSorcery.key("effect_liquid"));
    }

    @Override
    @Nonnull
    public BlockFountainPrime getAssociatedPrime() {
        return BlocksAS.FOUNTAIN_PRIME_LIQUID;
    }

    @Override
    @Nonnull
    public LiquidContext createContext(TileFountain fountain) {
        return new LiquidContext(fountain.func_174877_v());
    }

    @Override
    public void tick(TileFountain fountain, LiquidContext ctx, int operationTick, LogicalSide side, FountainEffect.OperationSegment currentSegment) {
        if (side.isClient()) {
            this.tickEffects(fountain, ctx, operationTick, currentSegment);
            return;
        }
        if (currentSegment.isLaterOrEqualTo(FountainEffect.OperationSegment.RUNNING)) {
            World w = fountain.func_145831_w();
            if (fountain.getTicksExisted() % 32 == 0) {
                this.digCone(w, ctx);
            }
            if (ctx.tickLiquidProduction()) {
                ctx.resetLiquidProductionTick(rand);
                this.produceLiquid(fountain);
            }
        }
    }

    private void produceLiquid(TileFountain fountain) {
        Chunk ch = fountain.func_145831_w().func_175726_f(fountain.func_174877_v());
        ch.getCapability(CapabilitiesAS.CHUNK_FLUID).ifPresent(entry -> {
            int drain = 200 + rand.nextInt(400);
            FluidStack drained = !entry.isEmpty() && entry.isInitialized() ? entry.drain(drain, IFluidHandler.FluidAction.SIMULATE) : new FluidStack((Fluid)Fluids.field_204546_a, drain);
            int fillable = fountain.getTank().fill(drained, IFluidHandler.FluidAction.SIMULATE);
            if (fillable > 0) {
                FluidStack actual = entry.drain(fillable, IFluidHandler.FluidAction.EXECUTE);
                fountain.getTank().fill(actual, IFluidHandler.FluidAction.EXECUTE);
            }
        });
    }

    private void digCone(World world, LiquidContext ctx) {
        if (world instanceof ServerWorld) {
            this.dig((ServerWorld)world, ctx.getDigPositions());
        }
    }

    private void dig(ServerWorld world, List<BlockPos> positions) {
        BlockDropCaptureAssist.startCapturing();
        try {
            positions.forEach(pos -> MiscUtils.executeWithChunk((IWorldReader)world, pos, () -> {
                BlockState state = world.func_180495_p(pos);
                if (!state.isAir((IBlockReader)world, pos) && world.func_175625_s(pos) == null && state.func_185887_b((IBlockReader)world, pos) >= 0.0f && !BlockUtils.isFluidBlock(state)) {
                    BlockUtils.breakBlockWithoutPlayer(world, pos, state, ItemStack.field_190927_a, true, true, false);
                }
            }));
        }
        finally {
            BlockDropCaptureAssist.getCapturedStacksAndStop();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickEffects(TileFountain fountain, LiquidContext ctx, int operationTick, FountainEffect.OperationSegment currentSegment) {
        if (currentSegment.isLaterOrEqualTo(FountainEffect.OperationSegment.STARTUP)) {
            FXSpritePlane sprite = (FXSpritePlane)ctx.fountainSprite;
            if (sprite == null) {
                sprite = (FXSpritePlane)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXSpritePlane)EffectHelper.of(EffectTemplatesAS.TEXTURE_SPRITE).spawn(new Vector3(fountain).add(0.5, 0.5, 0.5))).setAxis(Vector3.RotAxis.Y_AXIS).setNoRotation(45.0f).setSprite(SpritesAS.SPR_FOUNTAIN_LIQUID).setAlphaMultiplier(1.0f)).alpha((fx, alphaIn, pTicks) -> this.getSegmentPercent(FountainEffect.OperationSegment.STARTUP, fountain.getTickActiveFountainEffect()))).setScaleMultiplier(5.5f)).refresh(RefreshFunction.tileExistsAnd(fountain, (tile, fx) -> tile.getCurrentEffect() == this));
            } else if (sprite.isRemoved() || sprite.canRemove()) {
                EffectHelper.refresh(sprite, EffectTemplatesAS.TEXTURE_SPRITE);
            }
            ctx.fountainSprite = sprite;
        }
        BlockPos fountainPos = fountain.func_174877_v();
        float segmentPercent = this.getSegmentPercent(currentSegment, operationTick);
        switch (currentSegment) {
            case STARTUP: {
                this.playFountainVortexParticles((Vector3i)fountainPos, segmentPercent);
                this.playFountainArcs((Vector3i)fountainPos, segmentPercent);
                break;
            }
            case PREPARATION: {
                this.playFountainArcs((Vector3i)fountainPos, 1.0f - segmentPercent);
                this.playFountainVortexParticles((Vector3i)fountainPos, 1.0f - segmentPercent);
                this.playDigPreparation((Vector3i)fountainPos, segmentPercent);
                break;
            }
            case RUNNING: {
                this.playFountainVortexParticles((Vector3i)fountainPos, 0.2f);
                this.playFountainArcs((Vector3i)fountainPos, 0.6f);
                this.playDigParticles((Vector3i)fountainPos);
                if (fountain.getTicksExisted() % 40 != 0) break;
                this.playDigLightbeam((Vector3i)fountainPos);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playDigPreparation(Vector3i pos, float chance) {
        Vector3 at = new Vector3(pos).add(0.5, 0.5, 0.5);
        for (int i = 0; i < 12; ++i) {
            if (rand.nextFloat() >= chance) continue;
            Vector3 particlePos = new Vector3((double)pos.func_177958_n() - 0.4 + (double)rand.nextFloat() * 1.8, (double)((float)pos.func_177956_o() - rand.nextFloat() * 3.0f), (double)pos.func_177952_p() - 0.4 + (double)rand.nextFloat() * 1.8);
            Vector3 motion = particlePos.clone().vectorFromHereTo(at).normalize().divide(30.0);
            EntityVisualFX fx = (EntityVisualFX)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(particlePos)).setMotion(motion)).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setMaxAge(20 + rand.nextInt(40));
            if (rand.nextBoolean()) {
                fx.color(VFXColorFunction.WHITE);
                continue;
            }
            fx.color(VFXColorFunction.constant(ColorsAS.DEFAULT_GENERIC_PARTICLE));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playDigParticles(Vector3i pos) {
        for (int i = 0; i < 2; ++i) {
            Vector3 at = new Vector3(pos).add(0.3 + (double)rand.nextFloat() * 0.4, (double)(-rand.nextFloat()) * 1.7, 0.3 + (double)rand.nextFloat() * 0.4);
            ((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).setScaleMultiplier(0.25f)).setAlphaMultiplier(1.0f)).setMotion(new Vector3(0.0f, -rand.nextFloat() * 0.008f, 0.0f))).color(VFXColorFunction.random());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playDigLightbeam(Vector3i pos) {
        Vector3 from = new Vector3(pos).add(0.5, 1.5, 0.5);
        MiscUtils.applyRandomOffset(from, rand, 0.1f);
        Vector3 to = from.clone().setY(0);
        float size = 6.0f + rand.nextFloat() * 2.0f;
        ((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(from)).setup(to, size, size);
    }

    @Override
    public void transition(TileFountain fountain, LiquidContext ctx, LogicalSide side, FountainEffect.OperationSegment prevSegment, FountainEffect.OperationSegment nextSegment) {
        if (side.isServer()) {
            if (nextSegment == FountainEffect.OperationSegment.RUNNING) {
                this.digCone(fountain.func_145831_w(), ctx);
            }
        } else if (nextSegment == FountainEffect.OperationSegment.RUNNING) {
            this.markDigProcess(fountain.func_174877_v());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void markDigProcess(BlockPos pos) {
        for (int yy = 0; yy <= pos.func_177956_o(); ++yy) {
            for (int i = 0; i < 4; ++i) {
                Vector3 at = new Vector3((Vector3i)pos).setY(yy).add(rand.nextFloat(), rand.nextFloat(), rand.nextFloat());
                ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(at)).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.FADE_OUT)).setScaleMultiplier(0.2f + rand.nextFloat() * 0.1f)).setMaxAge(20 + rand.nextInt(40));
            }
        }
        Vector3 from = new Vector3((Vector3i)pos).add(0.5, 0.5, 0.5);
        Vector3 to = from.clone().setY(0);
        ((EntityVisualFX)((EntityVisualFX)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(from)).setup(to, 1.5, 1.5).setAlphaMultiplier(1.0f)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(ColorsAS.EFFECT_BLUE_LIGHT));
    }

    @Override
    public void onReplace(TileFountain fountain, LiquidContext ctx, @Nullable FountainEffect<?> newEffect, LogicalSide side) {
        if (side.isClient()) {
            this.removeSprite(ctx);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void removeSprite(LiquidContext ctx) {
        FXSpritePlane sprite = (FXSpritePlane)ctx.fountainSprite;
        if (sprite != null) {
            sprite.requestRemoval();
        }
    }
}

