/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.screen.base;

import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Tuple;

public interface SkyScreen {
    public static final float THRESHOLD_TO_START = 0.8f;
    public static final float THRESHOLD_TO_SHIFT_BLUEGRAD = 0.5f;
    public static final float THRESHOLD_TO_MAX_BLUEGRAD = 0.2f;
    public static final float THRESHOLD_FROM_START = 1.0f;
    public static final float THRESHOLD_FROM_SHIFT_BLUEGRAD = 0.6f;
    public static final float THRESHOLD_FROM_MAX_BLUEGRAD = 0.3f;

    public static Tuple<Color, Color> getSkyGradient(boolean canSeeSky, float angleTransparency, float partialTicks) {
        int rgbTo;
        int rgbFrom;
        ClientWorld renderWorld = Minecraft.func_71410_x().field_71441_e;
        if (canSeeSky && (double)angleTransparency > 1.0E-4) {
            float starBr = renderWorld.func_228330_j_(partialTicks) * 2.0f;
            float rain = renderWorld.func_72867_j(partialTicks);
            rgbFrom = RenderingUtils.clampToColorWithMultiplier(SkyScreen.calcRGBFromWithRain(starBr, rain), angleTransparency).getRGB();
            rgbTo = RenderingUtils.clampToColorWithMultiplier(SkyScreen.calcRGBToWithRain(starBr, rain), angleTransparency).getRGB();
        } else {
            rgbFrom = 0;
            rgbTo = 0;
        }
        int alphaMask = -16777216;
        return new Tuple((Object)new Color(alphaMask | rgbFrom, true), (Object)new Color(alphaMask | rgbTo, true));
    }

    public static int calcRGBToWithRain(float starBr, float rain) {
        int to = SkyScreen.calcRGBTo(starBr);
        if (starBr <= 0.8f) {
            float starMul = 1.0f;
            if (starBr > 0.5f) {
                starMul = 1.0f - (starBr - 0.5f) / 0.3f;
            }
            float interpDeg = starMul * rain;
            Color safeTo = RenderingUtils.clampToColor(to);
            Vector3 vTo = new Vector3(safeTo.getRed(), safeTo.getGreen(), safeTo.getBlue()).divide(255.0);
            Vector3 rainC = new Vector3(102, 114, 137).divide(255.0);
            Vector3 interpVec = vTo.copyInterpolateWith(rainC, interpDeg);
            Color newColor = RenderingUtils.clampToColor((int)(interpVec.getX() * 255.0), (int)(interpVec.getY() * 255.0), (int)(interpVec.getZ() * 255.0));
            to = newColor.getRGB();
        }
        return RenderingUtils.clampToColor(to).getRGB();
    }

    public static int calcRGBTo(float starBr) {
        if (starBr >= 0.8f) {
            return 0;
        }
        if (starBr >= 0.5f) {
            float partSize = 0.3f;
            float perc = 1.0f - (starBr - 0.5f) / partSize;
            return (int)(perc * 170.0f);
        }
        if (starBr >= 0.2f) {
            float partSize = 0.3f;
            float perc = 1.0f - (starBr - 0.2f) / partSize;
            int green = (int)(perc * 85.0f);
            int blue = green + 170;
            return green << 8 | blue;
        }
        float partSize = 0.2f;
        float perc = 1.0f - (starBr - 0.0f) / partSize;
        int green = 85 + (int)(perc * 90.0f);
        int red = (int)(perc * 140.0f);
        return red << 16 | green << 8 | 0xFF;
    }

    public static int calcRGBFromWithRain(float starBr, float rain) {
        int to = SkyScreen.calcRGBFrom(starBr);
        if (starBr <= 1.0f) {
            float starMul = 1.0f;
            if (starBr > 0.6f) {
                starMul = 1.0f - (starBr - 0.6f) / 0.39999998f;
            }
            float interpDeg = starMul * rain;
            Color safeTo = RenderingUtils.clampToColor(to);
            Vector3 vTo = new Vector3(safeTo.getRed(), safeTo.getGreen(), safeTo.getBlue()).divide(255.0);
            Vector3 rainC = new Vector3(102, 114, 137).divide(255.0);
            Vector3 interpVec = vTo.copyInterpolateWith(rainC, interpDeg);
            Color newColor = RenderingUtils.clampToColor((int)(interpVec.getX() * 255.0), (int)(interpVec.getY() * 255.0), (int)(interpVec.getZ() * 255.0));
            to = newColor.getRGB();
        }
        return RenderingUtils.clampToColor(to).getRGB();
    }

    public static int calcRGBFrom(float starBr) {
        if (starBr >= 1.0f) {
            return 0;
        }
        if (starBr >= 0.6f) {
            float partSize = 0.39999998f;
            float perc = 1.0f - (starBr - 0.6f) / partSize;
            return (int)(perc * 170.0f);
        }
        if (starBr >= 0.3f) {
            float partSize = 0.3f;
            float perc = 1.0f - (starBr - 0.3f) / partSize;
            int green = (int)(perc * 85.0f);
            int blue = green + 170;
            return green << 8 | blue;
        }
        float partSize = 0.3f;
        float perc = 1.0f - (starBr - 0.0f) / partSize;
        int green = 85 + (int)(perc * 90.0f);
        int red = (int)(perc * 140.0f);
        return red << 16 | green << 8 | 0xFF;
    }
}

