/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.structure.largefeature;

import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.core.world.BYGStructures;
import corgiaoc.byg.util.noise.fastnoise.lite.FastNoiseLite;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public class VolcanoPiece
extends StructurePiece {
    FastNoiseLite fnlPerlin;
    int baseRadius;
    double lavaLeakage;
    double threshold;
    int volcanoConeSize;
    int volcanoStartHeight;
    int volcanoSizeXMin;
    int volcanoSizeXMax;
    int volcanoSizeZMin;
    int volcanoSizeZMax;

    protected VolcanoPiece(BlockPos pos, int baseRadius, double lavaLeakage, int volcanoConeSize, int volcanoStartHeight, double threshold, FastNoiseLite fastNoiseLite, int volcanoConeSizeXMin, int volcanoConeSizeXMax, int volcanoConeSizeZMin, int volcanoConeSizeZMax) {
        super(BYGStructures.VOLCANO_PIECE, 0);
        this.field_74887_e = new MutableBoundingBox((Vector3i)pos, (Vector3i)pos);
        this.fnlPerlin = fastNoiseLite;
        this.baseRadius = baseRadius;
        this.volcanoConeSize = volcanoConeSize;
        this.lavaLeakage = lavaLeakage;
        this.volcanoStartHeight = volcanoStartHeight;
        this.threshold = threshold;
        this.volcanoSizeXMin = volcanoConeSizeXMin;
        this.volcanoSizeXMax = volcanoConeSizeXMax;
        this.volcanoSizeZMin = volcanoConeSizeZMin;
        this.volcanoSizeZMax = volcanoConeSizeZMax;
    }

    public VolcanoPiece(CompoundNBT nbt) {
        super(BYGStructures.VOLCANO_PIECE, nbt);
    }

    protected void func_143011_b(CompoundNBT tagCompound) {
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox structureBoundingBox, ChunkPos chunkPos, BlockPos aPos) {
        int yHeight = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c);
        BlockPos pos = new BlockPos(this.field_74887_e.field_78897_a, yHeight, this.field_74887_e.field_78896_c);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        double baseRadius = 25.0;
        double lavaLeakage = 0.7;
        int volcanoConeSize = 150;
        int volcanoStartHeight = volcanoConeSize - 5;
        double threshold = 0.5;
        MutableBoundingBox boundingBoxExpander = new MutableBoundingBox();
        for (double x = (double)(-this.volcanoSizeXMin); x <= (double)this.volcanoSizeXMax; x += 1.0) {
            for (double y = (double)(-volcanoConeSize); y <= -15.0; y += 1.0) {
                for (double z = (double)(-this.volcanoSizeXMin); z <= (double)this.volcanoSizeZMax; z += 1.0) {
                    mutable.func_189533_g((Vector3i)pos).func_196234_d((int)x, (int)y + volcanoStartHeight, (int)z);
                    float noise3 = FastNoiseLite.getSpongePerlinValue(this.fnlPerlin.GetNoise(mutable.func_177958_n(), mutable.func_177952_p()));
                    double scaledNoise = (double)(noise3 / 11.0f) * (-(y * baseRadius) / (x * x + z * z));
                    if (scaledNoise - lavaLeakage >= threshold) {
                        if (mutable.func_177956_o() > pos.func_177956_o() + (volcanoStartHeight - 19)) continue;
                        world.func_180501_a((BlockPos)mutable, Blocks.field_150353_l.func_176223_P(), 2);
                        world.func_205219_F_().func_205360_a((BlockPos)mutable, (Object)Fluids.field_204547_b, 0);
                        boundingBoxExpander.func_236989_a_((Vector3i)mutable);
                        continue;
                    }
                    if (!(scaledNoise >= threshold)) continue;
                    world.func_180501_a((BlockPos)mutable, BYGBlocks.WARPED_CORAL_BLOCK.func_176223_P(), 2);
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.fnlPerlin == null) {
            this.fnlPerlin = FastNoiseLite.createSpongePerlin((int)seed);
            this.fnlPerlin.SetFrequency(0.2f);
        }
    }
}

