/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.PointyRockConfig;
import corgiaoc.byg.common.world.feature.overworld.ChunkCoordinatesFeature;
import corgiaoc.byg.util.noise.fastnoise.FNVector3f;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class TallPointedRocks
extends ChunkCoordinatesFeature<PointyRockConfig> {
    public TallPointedRocks(Codec<PointyRockConfig> codec) {
        super(codec);
    }

    @Override
    public boolean generate(ISeedReader world, Random random, IChunk chunkIn, int x, int z, PointyRockConfig config) {
        config.setUpNoise(world.func_72905_C());
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        BlockPos.Mutable mutable = new BlockPos.Mutable(xPos, 0, zPos);
        FNVector3f fnVector3f = new FNVector3f(x, 0.0f, z);
        config.getNoiseGen().GradientPerturb(fnVector3f);
        float sampleNoise = config.getNoiseGen().GetNoise(fnVector3f.x, fnVector3f.z);
        int groundLevel = chunkIn.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z);
        if (!chunkIn.func_180495_p(mutable.func_177981_b(groundLevel)).func_196958_f() && (double)sampleNoise < 0.43) {
            int valueToReverse = (int)Math.abs((double)((int)((double)sampleNoise * 645.0)) * 1.8);
            int topHeight = (int)((double)valueToReverse - Math.abs((double)(-sampleNoise) * 645.0 * 1.8 - (double)valueToReverse) + 598.5);
            if ((topHeight = (int)((double)TallPointedRocks.redistribute(topHeight, groundLevel) * config.getHeightMultiplier())) > groundLevel) {
                mutable.func_189534_c(Direction.UP, topHeight);
                for (int yPos = topHeight; yPos >= groundLevel; --yPos) {
                    if (chunkIn.func_180495_p((BlockPos)mutable).func_196958_f() && mutable.func_177956_o() <= chunkIn.func_217301_I()) {
                        chunkIn.func_177436_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(random, (BlockPos)mutable), false);
                    }
                    mutable.func_189536_c(Direction.DOWN);
                }
            }
        }
        return true;
    }

    private static int redistribute(float height, float groundLevel) {
        float halfG = groundLevel * 0.5f;
        height = (height - 125.0f - halfG) / 80.0f;
        float sigmoid = height / (1.0f + Math.abs(height));
        return (int)((170.0f - groundLevel) * sigmoid + halfG + 125.0f);
    }
}

