/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util.blockupdate;

import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.skds.core.api.IWWS;
import net.skds.core.api.IWWSG;
import net.skds.core.events.OnWWSAttachEvent;

public class WWSGlobal
implements IWWSG {
    private static List<WWSGlobal> INSTANCES = new ArrayList<WWSGlobal>();
    public final World world;
    private Set<BlockPos> players = new HashSet<BlockPos>();
    private Map<Class<? extends IWWS>, IWWS> WWS = new HashMap<Class<? extends IWWS>, IWWS>();
    private ConcurrentSet<Long> banPos = new ConcurrentSet();
    private ConcurrentSet<Long> banPosOld = new ConcurrentSet();

    public WWSGlobal(World w) {
        this.world = w;
        MinecraftForge.EVENT_BUS.post((Event)new OnWWSAttachEvent(w, this));
        INSTANCES.add(this);
    }

    private void bpClean() {
        this.banPos.removeAll(this.banPosOld);
        this.banPosOld.clear();
        this.banPosOld.addAll(this.banPos);
    }

    @Override
    public void addWWS(IWWS wws) {
        this.WWS.put(wws.getClass(), wws);
    }

    public void stop() {
        this.WWS.forEach((s, wws) -> wws.close());
    }

    public void tickIn() {
        this.updatePlayers();
        this.bpClean();
        this.WWS.forEach((s, wws) -> wws.tickIn());
    }

    public void tickOut() {
        this.WWS.forEach((s, wws) -> wws.tickOut());
    }

    private void updatePlayers() {
        List playersss = this.world.func_217369_A();
        HashSet<BlockPos> np = new HashSet<BlockPos>();
        for (PlayerEntity p : playersss) {
            BlockPos pos = p.func_233580_cy_();
            np.add(pos);
        }
        this.players = np;
    }

    @Override
    public double getSqDistToNBP(BlockPos pos) {
        double dist = Double.MAX_VALUE;
        for (BlockPos pos2 : this.players) {
            double dx = pos.func_177958_n() - pos2.func_177958_n();
            double dz = pos.func_177952_p() - pos2.func_177952_p();
            dist = Math.min(dist, dx * dx + dz * dz);
        }
        return dist;
    }

    @Override
    public IWWS getTyped(Class<? extends IWWS> type) {
        return this.WWS.get(type);
    }

    public void unloadWorld(World w) {
        INSTANCES.remove(this);
        this.stop();
    }

    @Override
    public boolean unbanPos(long pos) {
        return this.banPos.remove((Object)pos);
    }

    @Override
    public boolean banPos(long pos) {
        boolean ss = this.banPos.add((Object)pos);
        return ss;
    }

    @Override
    public boolean isPosReady(long pos) {
        return !this.banPos.contains((Object)pos);
    }
}

