/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util.blockupdate;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.skds.core.Events;
import net.skds.core.SKDSCoreConfig;
import net.skds.core.util.blockupdate.UpdateTask;

public class BlockUpdataer {
    private static final ConcurrentLinkedQueue<Entity> entitiesToAdd = new ConcurrentLinkedQueue();
    private static float upus = 0.1f;
    private static int avgTime = 0;
    private static int avgTickTime = 0;
    private static int[] timeTickList = new int[14];
    private static int indexT2 = 0;
    private static float RemMRUC = 0.0f;
    private static int MRUC = 0;
    private static int updateCounter = 0;
    private static int indexUp = 0;
    private static int indexT = 0;
    private static int indexForFill = 0;
    private static float[] upusList = new float[32];
    private static int[] timeList = new int[32];
    private static Map<ServerWorld, ConcurrentLinkedQueue<UpdateTask>> BLOCK_UPDATES_WORLDS = new HashMap<ServerWorld, ConcurrentLinkedQueue<UpdateTask>>();
    private static int inint = 0;

    public static float getUPus() {
        return upus;
    }

    public static int getAvgTime() {
        return avgTime;
    }

    public static boolean applyTask(float weight) {
        boolean bl;
        boolean bl2 = bl = RemMRUC > 0.0f;
        if (bl) {
            RemMRUC -= weight;
        }
        return bl;
    }

    public static int getMaxRecomendedUpdateCount() {
        return MRUC;
    }

    private static void calcUPus(int time) {
        int lenT;
        int lenUp = upusList.length;
        if (indexUp >= lenUp) {
            indexUp = 0;
            indexForFill = lenUp;
        }
        indexForFill = Math.max(indexUp, indexForFill);
        if (time > 0) {
            BlockUpdataer.upusList[BlockUpdataer.indexUp] = 1.0f * (float)updateCounter / (float)time;
            ++indexUp;
        }
        if (indexForFill > 0) {
            float sum = 0.0f;
            for (int i = 0; i < indexForFill; ++i) {
                sum += upusList[i];
            }
            upus = sum / (float)indexForFill;
        }
        if (++indexT >= (lenT = timeList.length)) {
            indexT = 0;
        }
        BlockUpdataer.timeList[BlockUpdataer.indexT] = time;
        int sum = 0;
        int c = 0;
        for (int i : timeList) {
            sum += i;
            ++c;
        }
        avgTime = sum / c;
    }

    private static void calcMidTickTime() {
        int t;
        int lenT = timeTickList.length;
        if (++indexT2 >= lenT) {
            indexT2 = 0;
        }
        BlockUpdataer.timeTickList[BlockUpdataer.indexT2] = t = Events.getLastTickTime() / 1000;
        int sum = 0;
        int c = 0;
        for (int i : timeTickList) {
            sum += i;
            ++c;
        }
        avgTickTime = sum / c;
    }

    private static void calcMRUC() {
        int RT;
        int RTavgF = RT = 50000 - avgTickTime;
        int PreMRUC = (int)((float)RTavgF * upus);
        MRUC = Math.max((Integer)SKDSCoreConfig.COMMON.minBlockUpdates.get(), PreMRUC);
        RemMRUC = MRUC;
    }

    public static void onWorldLoad(ServerWorld w) {
        ConcurrentLinkedQueue map = new ConcurrentLinkedQueue();
        BLOCK_UPDATES_WORLDS.put(w, map);
    }

    public static void onWorldUnload(ServerWorld w) {
        BLOCK_UPDATES_WORLDS.remove(w);
        entitiesToAdd.forEach(e -> {
            if (e.field_70170_p == w) {
                e.field_70170_p.func_217376_c(e);
                entitiesToAdd.remove(e);
            }
        });
    }

    public static void addUpdate(ServerWorld w, BlockPos pos, BlockState newState, BlockState oldState, int flags, BiConsumer<UpdateTask, ServerWorld> action) {
        if (newState == oldState) {
            return;
        }
        ConcurrentLinkedQueue<UpdateTask> bul = BLOCK_UPDATES_WORLDS.get(w);
        if (bul == null) {
            return;
        }
        bul.add(new UpdateTask(pos, newState, oldState, flags, action));
    }

    public static void tick(boolean in) {
        long initT = System.nanoTime();
        if (in) {
            Entity e;
            while ((e = entitiesToAdd.poll()) != null) {
                e.field_70170_p.func_217376_c(e);
            }
            BLOCK_UPDATES_WORLDS.forEach((w, set) -> {
                while (!set.isEmpty()) {
                    UpdateTask task = (UpdateTask)set.poll();
                    task.update((ServerWorld)w);
                    ++updateCounter;
                }
            });
        }
        int time = (int)(System.nanoTime() - initT) / 1000;
        if (in) {
            inint = time;
        } else {
            BlockUpdataer.calcMidTickTime();
            BlockUpdataer.calcUPus(time + inint);
            BlockUpdataer.calcMRUC();
            updateCounter = 0;
        }
    }

    public static void addEntity(Entity e) {
        entitiesToAdd.add(e);
    }
}

