/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.util.blockupdate;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import net.skds.core.api.IServerChunkProvider;
import net.skds.core.api.IWWS;
import net.skds.core.network.DebugPacket;
import net.skds.core.network.PacketHandler;
import net.skds.core.util.blockupdate.BlockUpdataer;
import net.skds.core.util.blockupdate.UpdateTask;

public abstract class BasicExecutor
implements Runnable {
    protected final BlockState nullreturnstate = Blocks.field_180401_cv.func_176223_P();
    protected final ServerWorld w;
    protected final IWWS owner;
    protected final BiConsumer<UpdateTask, ServerWorld> action;
    protected Set<BlockPos> banPoses = new HashSet<BlockPos>();
    protected boolean cancel = false;
    private IChunk chunkCash = null;
    private long chunkPosCash = 0L;
    private boolean newChunkCash = true;

    protected BasicExecutor(ServerWorld w, BiConsumer<UpdateTask, ServerWorld> action, IWWS owner) {
        this.owner = owner;
        this.w = w;
        this.action = action;
    }

    protected abstract void applyAction(BlockPos var1, BlockState var2, BlockState var3, ServerWorld var4);

    protected BlockState setState(BlockPos pos, BlockState newState) {
        BlockState oldState = this.setFinBlockState(pos, newState);
        if (oldState != null) {
            this.applyAction(pos, newState, oldState, this.w);
        }
        return oldState;
    }

    protected IChunk getChunk(int blockX, int blockZ) {
        long lpos = ChunkPos.func_77272_a((int)(blockX >> 4), (int)(blockZ >> 4));
        if (this.newChunkCash || lpos != this.chunkPosCash) {
            this.newChunkCash = false;
            ServerChunkProvider prov = this.w.func_72863_F();
            this.chunkCash = ((IServerChunkProvider)prov).getCustomChunk(lpos);
            this.chunkPosCash = lpos;
        }
        return this.chunkCash;
    }

    protected IChunk getChunk(BlockPos cPos) {
        return this.getChunk(cPos.func_177958_n(), cPos.func_177952_p());
    }

    protected BlockState getBlockState(BlockPos pos) {
        IChunk chunk = this.getChunk(pos);
        if (chunk == null) {
            this.cancel = true;
            return this.nullreturnstate;
        }
        BlockState ssss = chunk.func_180495_p(pos);
        if (ssss == null) {
            return this.nullreturnstate;
        }
        return ssss;
    }

    protected BlockState setFinBlockState(BlockPos pos, BlockState state) {
        IChunk chunk = this.getChunk(pos);
        if (!(chunk instanceof Chunk)) {
            return null;
        }
        ChunkSection[] chunksections = chunk.func_76587_i();
        ChunkSection sec = chunksections[pos.func_177956_o() >> 4];
        if (sec == null) {
            chunksections[pos.func_177956_o() >> 4] = sec = new ChunkSection(pos.func_177956_o() >> 4 << 4);
        }
        BlockState setted = chunksections[pos.func_177956_o() >> 4].func_222629_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
        return setted;
    }

    protected boolean isAir(BlockState statex) {
        return statex.func_185904_a() == Material.field_151579_a;
    }

    protected TileEntity getTileEntity(BlockPos pos) {
        IChunk ich = this.getChunk(pos);
        TileEntity tileentity = null;
        if (ich instanceof Chunk) {
            tileentity = ((Chunk)this.getChunk(pos)).func_177424_a(pos, Chunk.CreateEntityType.IMMEDIATE);
        }
        return tileentity;
    }

    protected void addEntity(Entity e) {
        BlockUpdataer.addEntity(e);
    }

    public static Direction dirFromVec(BlockPos pos1, BlockPos pos2) {
        return Direction.func_176737_a((float)(pos2.func_177958_n() - pos1.func_177958_n()), (float)(pos2.func_177956_o() - pos1.func_177956_o()), (float)(pos2.func_177952_p() - pos1.func_177952_p()));
    }

    protected void debug(BlockPos pos) {
        this.w.func_217369_A().forEach(p -> PacketHandler.send(PacketDistributor.PLAYER.with(() -> p), new DebugPacket(pos)));
    }
}

