/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core.multithreading;

import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import net.skds.core.SKDSCore;
import net.skds.core.api.multithreading.ISKDSThread;
import net.skds.core.api.multithreading.ITaskRunnable;
import net.skds.core.util.Cycler;

public class UniversalWorkerThread
extends Thread
implements ISKDSThread {
    private Cycler<Function<Integer, ITaskRunnable>> cycler = new Cycler();
    public boolean isDone = true;
    public boolean cont = true;
    public boolean yeld = true;
    public final int num;

    public UniversalWorkerThread(int num) {
        this.num = num;
        this.setDaemon(true);
        this.setName("SKDS-Worker-" + num);
        this.start();
    }

    public static UniversalWorkerThread[] create(int count) {
        UniversalWorkerThread[] arr = new UniversalWorkerThread[count];
        for (int n = 0; n < count; ++n) {
            arr[n] = new UniversalWorkerThread(n);
        }
        return arr;
    }

    public void close() {
        this.cont = false;
        LockSupport.unpark(this);
    }

    @Override
    public void run() {
        while (this.cont) {
            this.isDone = true;
            LockSupport.park(this);
            this.isDone = false;
            if (!this.cont || this.yeld) continue;
            try {
                this.takeTasksStack();
            }
            catch (Exception e) {
                SKDSCore.LOGGER.error("Exeption while taking task stack ", (Throwable)e);
            }
        }
    }

    private boolean shouldContain() {
        return !this.yeld;
    }

    private ITaskRunnable pollTask() {
        Function<Integer, ITaskRunnable> func = this.cycler.next();
        if (func == null) {
            return null;
        }
        ITaskRunnable task = func.apply(this.num);
        if (task == null) {
            this.cycler.removeEntry(func);
        }
        return task;
    }

    private void takeTasksStack() {
        ITaskRunnable task;
        while (this.shouldContain() && (task = this.pollTask()) != null) {
            try {
                task.run();
            }
            catch (Exception e) {
                SKDSCore.LOGGER.error("Exeption while executing task ", (Throwable)e);
            }
            task = null;
        }
    }

    public void forkSync(Function<Integer, ITaskRunnable> sup) {
        this.cycler.addEntry(sup);
        this.yeld = false;
        this.isDone = false;
        LockSupport.unpark(this);
    }

    public void waitForJoin() {
        while (!this.isDone()) {
            Thread.yield();
            LockSupport.parkNanos("waiting for workers to finish", 100000L);
        }
        this.yeld = true;
    }

    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public int getIndex() {
        return this.num;
    }
}

