/*
 * Decompiled with CFR 0.152.
 */
package net.skds.core;

import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.skds.core.api.IWorldExtended;
import net.skds.core.util.blockupdate.BlockUpdataer;
import net.skds.core.util.blockupdate.WWSGlobal;

public class Events {
    private static long inTickTime = System.nanoTime();
    private static int lastTickTime = 0;

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        World w = (World)e.getWorld();
        WWSGlobal wwsg = ((IWorldExtended)w).getWWS();
        wwsg.unloadWorld(w);
        if (!w.field_72995_K) {
            BlockUpdataer.onWorldUnload((ServerWorld)e.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        World w = (World)e.getWorld();
        ((IWorldExtended)w).addWWS();
        if (!w.field_72995_K) {
            BlockUpdataer.onWorldLoad((ServerWorld)w);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        WWSGlobal wwsg;
        boolean in = event.phase == TickEvent.Phase.START;
        World w = event.world;
        if (in) {
            wwsg = ((IWorldExtended)w).getWWS();
            wwsg.tickIn();
        }
        if (!in) {
            wwsg = ((IWorldExtended)w).getWWS();
            wwsg.tickOut();
            lastTickTime = (int)(System.nanoTime() - inTickTime);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        boolean in;
        boolean bl = in = event.phase == TickEvent.Phase.START;
        if (in) {
            inTickTime = System.nanoTime();
        }
        BlockUpdataer.tick(in);
        if (!in) {
            lastTickTime = (int)(System.nanoTime() - inTickTime);
        }
    }

    public static int getLastTickTime() {
        return lastTickTime;
    }

    public static int getRemainingTickTimeNanos() {
        return 50000000 - (int)(System.nanoTime() - inTickTime);
    }

    public static int getRemainingTickTimeMicros() {
        return Events.getRemainingTickTimeNanos() / 1000;
    }

    public static int getRemainingTickTimeMilis() {
        return Events.getRemainingTickTimeNanos() / 1000000;
    }
}

