/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.settings.codec;

import ht.treechop.common.settings.codec.AbstractSimpleCodec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;

public class EnumCodec<T extends Enum<T>>
extends AbstractSimpleCodec<T> {
    private final Class<T> enumType;
    public final Set<T> values;

    public EnumCodec(Class<T> enumType) {
        this.enumType = enumType;
        this.values = Collections.unmodifiableSet(Arrays.stream(enumType.getEnumConstants()).collect(Collectors.toSet()));
    }

    @Override
    public Set<T> getValues() {
        return this.values;
    }

    @Override
    public T decode(PacketBuffer buffer) {
        try {
            return Enum.valueOf(this.enumType, buffer.func_150789_c(64));
        }
        catch (IllegalArgumentException e) {
            return (T)((Enum[])this.enumType.getEnumConstants())[0];
        }
    }

    @Override
    public void encode(PacketBuffer buffer, Object object) {
        buffer.func_180714_a(this.getValueOf(object).map(Enum::name).orElse(""));
    }

    @Override
    public Class<T> getTypeClass() {
        return this.enumType;
    }
}

