/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.api.IChoppingItem;
import ht.treechop.common.config.ChopCountingAlgorithm;
import ht.treechop.common.config.ListType;
import ht.treechop.common.config.OverrideInfo;
import ht.treechop.common.config.OverrideType;
import ht.treechop.common.config.Rounder;
import ht.treechop.common.config.item.ItemIdentifier;
import ht.treechop.common.settings.ChopSettings;
import ht.treechop.common.settings.Permissions;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import ht.treechop.server.Server;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static ITag<Block> blockTagForDetectingLogs;
    public static ITag<Block> blockTagForDetectingLeaves;
    public static final ChopSettings fakePlayerChopSettings;
    private static Set<Item> itemsBlacklist;
    public static Map<Item, OverrideInfo> itemOverrides;
    public static int maxBreakLeavesDistance;
    public static boolean ignorePersistentLeaves;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static void onReload() {
        maxBreakLeavesDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
        ignorePersistentLeaves = (Boolean)ConfigHandler.COMMON.ignorePersistentLeaves.get();
        fakePlayerChopSettings.setChoppingEnabled((Boolean)ConfigHandler.COMMON.fakePlayerChoppingEnabled.get());
        fakePlayerChopSettings.setFellingEnabled((Boolean)ConfigHandler.COMMON.fakePlayerFellingEnabled.get());
        fakePlayerChopSettings.setTreesMustHaveLeaves((Boolean)ConfigHandler.COMMON.fakePlayerTreesMustHaveLeaves.get());
        itemsBlacklist = null;
        itemOverrides = null;
        ConfigHandler.updatePermissions();
    }

    public static void updateTags(ITagCollectionSupplier tagManager) {
        blockTagForDetectingLogs = tagManager.func_241835_a().func_199910_a(new ResourceLocation((String)ConfigHandler.COMMON.blockTagForDetectingLogs.get()));
        blockTagForDetectingLeaves = tagManager.func_241835_a().func_199910_a(new ResourceLocation((String)ConfigHandler.COMMON.blockTagForDetectingLeaves.get()));
        itemsBlacklist = null;
        itemOverrides = null;
    }

    private static void updatePermissions() {
        Set<Setting> permittedSettings = ConfigHandler.COMMON.rawPermissions.stream().filter(settingAndConfig -> (Boolean)((ForgeConfigSpec.BooleanValue)settingAndConfig.getRight()).get()).map(Pair::getLeft).collect(Collectors.toSet());
        Permissions permissions = new Permissions(permittedSettings);
        Server.updatePermissions(permissions);
    }

    private static Set<Item> getItemsFromConfigList(ITagCollection<Item> tags, List<? extends String> identifiers, Predicate<Item> filter) {
        Map<Item, Integer> qualifiedItems = ConfigHandler.getQualifiedItemsFromConfigList(tags, identifiers, filter, $ -> 0);
        return qualifiedItems.keySet();
    }

    private static <T> Map<Item, T> getQualifiedItemsFromConfigList(ITagCollection<Item> tags, List<? extends String> identifiers, Predicate<Item> filter, Function<ItemIdentifier, T> qualifierParser) {
        return ConfigHandler.transformConfigList(identifiers, string -> {
            ItemIdentifier id = ItemIdentifier.from(string);
            List<Item> items = id.resolve(tags, (IForgeRegistry<Item>)ForgeRegistries.ITEMS);
            Object qualifier = qualifierParser.apply(id);
            return items.stream().map(item -> Pair.of((Object)item, (Object)qualifier)).collect(Collectors.toList());
        }).stream().flatMap(Collection::stream).filter(itemQualifierPair -> itemQualifierPair.getLeft() != Items.field_190931_a && itemQualifierPair.getRight() != null && filter.test((Item)itemQualifierPair.getLeft())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private static <T> List<T> transformConfigList(List<? extends String> identifiers, Function<String, T> transformer) {
        return identifiers.stream().map(transformer).collect(Collectors.toList());
    }

    public static boolean shouldOverrideItemBehavior(Item item, boolean chopping) {
        OverrideInfo info = ConfigHandler.getItemOverrides().get(item);
        return info != null && info.shouldOverride(chopping);
    }

    private static Map<Item, OverrideInfo> getItemOverrides() {
        if (itemOverrides == null) {
            itemOverrides = ConfigHandler.getQualifiedItemsFromConfigList((ITagCollection<Item>)TagCollectionManager.func_242178_a().func_241836_b(), (List)ConfigHandler.COMMON.itemsToOverride.get(), item -> !(item instanceof IChoppingItem), id -> new OverrideInfo(ConfigHandler.getQualifierChops(id), ConfigHandler.getQualifierOverride(id)));
        }
        return itemOverrides;
    }

    private static OverrideType getQualifierOverride(ItemIdentifier id) {
        Optional<String> override = id.getQualifier("override");
        if (override.isPresent()) {
            switch (override.get().toLowerCase()) {
                case "always": {
                    return OverrideType.ALWAYS;
                }
                case "chopping": {
                    return OverrideType.WHEN_CHOPPING;
                }
                case "never": {
                    return OverrideType.NEVER;
                }
            }
            id.parsingError(String.format("override qualifier value \"%s\" is not valid", override.get()));
            return OverrideType.WHEN_CHOPPING;
        }
        return OverrideType.WHEN_CHOPPING;
    }

    private static int getQualifierChops(ItemIdentifier id) {
        Optional<String> chops = id.getQualifier("chops");
        if (chops.isPresent()) {
            try {
                return Integer.parseInt(chops.get());
            }
            catch (NumberFormatException e) {
                id.parsingError(String.format("chops value \"%s\" is not an integer", chops.get()));
                return 1;
            }
        }
        return 1;
    }

    public static Integer getNumChopsOverride(Item item) {
        OverrideInfo overrideInfo = ConfigHandler.getItemOverrides().get(item);
        return overrideInfo == null ? null : Integer.valueOf(overrideInfo.getNumChops());
    }

    public static boolean canChopWithItem(Item item) {
        if (itemsBlacklist == null) {
            itemsBlacklist = ConfigHandler.getItemsFromConfigList((ITagCollection<Item>)TagCollectionManager.func_242178_a().func_241836_b(), (List)ConfigHandler.COMMON.itemsToBlacklist.get(), item1 -> !(item1 instanceof IChoppingItem));
        }
        if (ConfigHandler.COMMON.blacklistOrWhitelist.get() == ListType.BLACKLIST) {
            return !itemsBlacklist.contains(item);
        }
        return itemsBlacklist.contains(item);
    }

    static {
        fakePlayerChopSettings = new ChopSettings();
        itemsBlacklist = null;
        itemOverrides = null;
        maxBreakLeavesDistance = 7;
        ignorePersistentLeaves = true;
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue choppingEnabled;
        public final ForgeConfigSpec.BooleanValue fellingEnabled;
        public final ForgeConfigSpec.EnumValue<SneakBehavior> sneakBehavior;
        public final ForgeConfigSpec.BooleanValue treesMustHaveLeaves;
        public final ForgeConfigSpec.BooleanValue chopInCreativeMode;
        public final ForgeConfigSpec.BooleanValue useProceduralChoppedModels;
        public final ForgeConfigSpec.BooleanValue showChoppingIndicators;
        public final ForgeConfigSpec.BooleanValue removeBarkOnInteriorLogs;
        public final ForgeConfigSpec.IntValue indicatorXOffset;
        public final ForgeConfigSpec.IntValue indicatorYOffset;
        public final ForgeConfigSpec.BooleanValue showFellingOptions;
        public final ForgeConfigSpec.BooleanValue showFeedbackMessages;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("chopping");
            this.choppingEnabled = builder.comment("Default setting for whether or not the user wishes to chop (can be toggled in-game)").define("choppingEnabled", true);
            this.fellingEnabled = builder.comment("Default setting for whether or not the user wishes to fell tree when chopping (can be toggled in-game)").define("fellingEnabled", true);
            this.sneakBehavior = builder.comment("Default setting for the effect that sneaking has on chopping (can be cycled in-game)").defineEnum("sneakBehavior", (Enum)SneakBehavior.INVERT_CHOPPING);
            this.treesMustHaveLeaves = builder.comment("Whether to ignore trees without connected leaves").define("treesMustHaveLeaves", true);
            this.chopInCreativeMode = builder.comment("Whether to enable chopping when in creative mode (even when false, sneaking can still enable chopping)").define("chopInCreativeMode", false);
            builder.pop();
            builder.push("visuals");
            this.useProceduralChoppedModels = builder.comment("Whether to use procedural chopped log models; disable to use models added by a resource pack").define("useProceduralChoppedModels", true);
            this.removeBarkOnInteriorLogs = builder.comment("Whether to replace the interior sides of logs with a chopped texture instead of bark").define("removeBarkOnInteriorLogs", true);
            builder.push("choppingIndicator");
            this.showChoppingIndicators = builder.comment("Whether to show an on-screen icon indicating whether targeted blocks can be chopped").define("enabled", true);
            this.indicatorXOffset = builder.comment("Horizontal location of the indicator relative to the player's crosshairs; positive values move the indicator to the right").defineInRange("xOffset", 16, -256, 256);
            this.indicatorYOffset = builder.comment("Vertical location of the indicator relative to the player's crosshairs; positive values move the indicator down").defineInRange("yOffset", 0, -256, 256);
            builder.pop();
            builder.pop();
            builder.push("settingsScreen");
            this.showFellingOptions = builder.comment("Whether to show in-game options for enabling and disable felling").define("showFellingOptions", false);
            this.showFeedbackMessages = builder.comment("Whether to show chat confirmations when using hotkeys to change chop settings").define("showFeedbackMessages", true);
            builder.pop();
        }

        public ChopSettings getChopSettings() {
            ChopSettings chopSettings = new ChopSettings();
            chopSettings.setChoppingEnabled((Boolean)ConfigHandler.CLIENT.choppingEnabled.get());
            chopSettings.setFellingEnabled((Boolean)ConfigHandler.CLIENT.fellingEnabled.get());
            chopSettings.setSneakBehavior((SneakBehavior)((Object)ConfigHandler.CLIENT.sneakBehavior.get()));
            chopSettings.setTreesMustHaveLeaves((Boolean)ConfigHandler.CLIENT.treesMustHaveLeaves.get());
            chopSettings.setChopInCreativeMode((Boolean)ConfigHandler.CLIENT.chopInCreativeMode.get());
            return chopSettings;
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enabled;
        protected final List<Pair<Setting, ForgeConfigSpec.BooleanValue>> rawPermissions = new LinkedList<Pair<Setting, ForgeConfigSpec.BooleanValue>>();
        public final ForgeConfigSpec.IntValue maxNumTreeBlocks;
        public final ForgeConfigSpec.IntValue maxNumLeavesBlocks;
        public final ForgeConfigSpec.BooleanValue breakLeaves;
        public final ForgeConfigSpec.BooleanValue ignorePersistentLeaves;
        protected final ForgeConfigSpec.IntValue maxBreakLeavesDistance;
        protected final ForgeConfigSpec.ConfigValue<String> blockTagForDetectingLogs;
        protected final ForgeConfigSpec.ConfigValue<String> blockTagForDetectingLeaves;
        public final ForgeConfigSpec.EnumValue<ChopCountingAlgorithm> chopCountingAlgorithm;
        public final ForgeConfigSpec.EnumValue<Rounder> chopCountRounding;
        public final ForgeConfigSpec.BooleanValue canRequireMoreChopsThanBlocks;
        public final ForgeConfigSpec.DoubleValue logarithmicA;
        public final ForgeConfigSpec.DoubleValue linearM;
        public final ForgeConfigSpec.DoubleValue linearB;
        public final ForgeConfigSpec.EnumValue<ListType> blacklistOrWhitelist;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> itemsToBlacklist;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> itemsToOverride;
        public final ForgeConfigSpec.BooleanValue preventChoppingOnRightClick;
        public final ForgeConfigSpec.BooleanValue preventChopRecursion;
        public final ForgeConfigSpec.BooleanValue compatForProjectMMO;
        public final ForgeConfigSpec.BooleanValue compatForCarryOn;
        public final ForgeConfigSpec.BooleanValue compatForDynamicTrees;
        public final ForgeConfigSpec.BooleanValue fakePlayerChoppingEnabled;
        public final ForgeConfigSpec.BooleanValue fakePlayerFellingEnabled;
        public final ForgeConfigSpec.BooleanValue fakePlayerTreesMustHaveLeaves;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("permissions");
            this.enabled = builder.comment("Whether this mod is enabled or not").define("enabled", true);
            for (SettingsField field : SettingsField.values()) {
                String fieldName = field.getConfigKey();
                for (Object value : field.getValues()) {
                    String valueName = this.getPrettyValueName(value);
                    ForgeConfigSpec.BooleanValue configHandle = builder.define(fieldName + ".canBe" + valueName, true);
                    this.rawPermissions.add((Pair<Setting, ForgeConfigSpec.BooleanValue>)Pair.of((Object)new Setting(field, value), (Object)configHandle));
                }
            }
            builder.pop();
            builder.push("treeDetection");
            this.maxNumTreeBlocks = builder.comment("Maximum number of log blocks that can be detected to belong to one tree").defineInRange("maxTreeBlocks", 320, 1, 8096);
            this.maxNumLeavesBlocks = builder.comment("Maximum number of leaves blocks that can destroyed when a tree is felled").defineInRange("maxLeavesBlocks", 1024, 1, 8096);
            this.breakLeaves = builder.comment("Whether to destroy leaves when a tree is felled").define("breakLeaves", true);
            this.ignorePersistentLeaves = builder.comment("Whether non-decayable leaves are ignored when detecting leaves").define("ignorePersistentLeaves", true);
            this.maxBreakLeavesDistance = builder.comment("Maximum distance from log blocks to destroy non-standard leaves blocks (e.g. mushroom caps) when felling").defineInRange("maxBreakLeavesDistance", 7, 0, 16);
            this.blockTagForDetectingLogs = builder.comment("The tag that blocks must have to be considered choppable (default: treechop:choppables)").define("blockTagForDetectingLogs", (Object)"treechop:choppables");
            this.blockTagForDetectingLeaves = builder.comment("The tag that blocks must have to be considered leaves (default: treechop:leaves_like)").define("blockTagForDetectingLeaves", (Object)"treechop:leaves_like");
            builder.pop();
            builder.push("chopCounting");
            this.chopCountingAlgorithm = builder.comment("Method to use for computing the number of chops needed to fell a tree").defineEnum("algorithm", (Enum)ChopCountingAlgorithm.LOGARITHMIC);
            this.chopCountRounding = builder.comment("How to round the number of chops needed to fell a tree; this is more meaningful for smaller trees").defineEnum("rounding", (Enum)Rounder.NEAREST);
            this.canRequireMoreChopsThanBlocks = builder.comment("Whether felling a tree can require more chops than the number of blocks in the tree").define("canRequireMoreChopsThanBlocks", false);
            builder.comment("See https://github.com/hammertater/treechop/#logarithmic").push("logarithmic");
            this.logarithmicA = builder.comment("Determines the number of chops required to fell a tree; higher values require more chops for bigger trees").defineInRange("a", 10.0, 0.0, 10000.0);
            builder.pop();
            builder.comment("See https://github.com/hammertater/treechop/#linear").push("linear");
            this.linearM = builder.comment("The number of chops per block required to fell a tree; if chopsPerBlock = 0.5, it will take 50 chops to fell a 100 block tree").defineInRange("chopsPerBlock", 1.0, 0.0, 7.0);
            this.linearB = builder.comment("The base number of chops required to fell a tree regardless of its size").defineInRange("baseNumChops", 0.0, -10000.0, 10000.0);
            builder.pop();
            builder.pop();
            builder.push("compatibility");
            builder.push("general");
            this.preventChoppingOnRightClick = builder.comment("Whether to prevent chopping during right-click actions; automatically enabled if compatibility.carryOn = true with Carry On versions prior to carryon-1.16.5-1.15.2.9").define("preventChoppingOnRightClick", false);
            this.preventChopRecursion = builder.comment("Whether to prevent infinite loops when chopping; fixes crashes when using modded items that break multiple blocks").define("preventChopRecursion", true);
            builder.push("blacklist");
            this.blacklistOrWhitelist = builder.comment("Whether the listed items should be blacklisted or whitelisted").defineEnum("blacklistOrWhitelist", (Enum)ListType.BLACKLIST);
            this.itemsToBlacklist = builder.comment(String.join((CharSequence)"\n", "List of item registry names (mod:item), tags (#mod:tag), and namespaces (@mod) for items that should not chop when used to break a log", "- Items in this list that have special support for TreeChop will not be blacklisted; see https://github.com/hammertater/treechop/blob/main/docs/compatibility.md#blacklist")).defineList("items", Arrays.asList("botania:terra_axe", "mekanism:atomic_disassembler", "@lumberjack", "practicaltools:iron_greataxe", "practicaltools:golden_greataxe", "practicaltools:diamond_greataxe", "practicaltools:netherite_greataxe"), always -> true);
            builder.pop();
            builder.push("overrides");
            this.itemsToOverride = builder.comment(String.join((CharSequence)"\n", "List of item registry names (mod:item), tags (#mod:tag), and namespaces (@mod) for items that should not perform their default behavior when chopping", "- Add \"?chops=N\" to specify the number of chops to be performed when breaking a log with the item (defaults to 1)", "- Add \"?override=always\" to disable default behavior even when chopping is disabled", "- Add \"?override=never\" to never disable default behavior", "- Items in this list that have special support for TreeChop will not be overridden; see https://github.com/hammertater/treechop/blob/main/docs/compatibility.md#overrides", "- This might not work as expected for some items; see https://github.com/hammertater/treechop/blob/main/docs/compatibility.md#caveats")).defineList("items", Arrays.asList("#tconstruct:modifiable/harvest", "silentgear:saw?chops=3,override=always"), always -> true);
            builder.pop();
            builder.comment("The chop settings used by non-player entities, such as robots");
            builder.push("fakePlayerChopSettings");
            this.fakePlayerChoppingEnabled = builder.comment("Use with caution! May cause conflicts with some mods, e.g. https://github.com/hammertater/treechop/issues/71").define("choppingEnabled", false);
            this.fakePlayerFellingEnabled = builder.comment("Felling only matters if chopping is enabled; probably best to leave this on").define("fellingEnabled", true);
            this.fakePlayerTreesMustHaveLeaves = builder.define("treesMustHaveLeaves", true);
            builder.pop();
            builder.pop();
            builder.push("specific");
            this.compatForProjectMMO = builder.comment(String.join((CharSequence)"\n", "Whether to enable compatibility with ProjectMMO; for example, award XP for chopping", "See https://www.curseforge.com/minecraft/mc-mods/project-mmo")).define("projectMMO", true);
            this.compatForCarryOn = builder.comment(String.join((CharSequence)"\n", "Whether to prevent conflicts with Carry On when it is configured to allow picking up logs", "See https://www.curseforge.com/minecraft/mc-mods/carry-on")).define("carryOn", true);
            this.compatForDynamicTrees = builder.comment(String.join((CharSequence)"\n", "Whether to prevent conflicts with DynamicTrees", "See https://www.curseforge.com/minecraft/mc-mods/dynamictrees")).define("dynamicTrees", true);
            builder.pop();
            builder.pop();
        }

        private String getPrettyValueName(Object value) {
            return Arrays.stream(value.toString().toLowerCase().split("_")).map(WordUtils::capitalize).collect(Collectors.joining());
        }
    }
}

