/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.block;

import ht.treechop.api.IChoppableBlock;
import ht.treechop.common.properties.BlockStateProperties;
import ht.treechop.common.properties.ChoppedLogShape;
import ht.treechop.common.util.ChopUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class ChoppedLogBlock
extends Block
implements IChoppableBlock {
    protected static final IntegerProperty CHOPS = BlockStateProperties.CHOP_COUNT;
    protected static final EnumProperty<ChoppedLogShape> SHAPE = BlockStateProperties.CHOPPED_LOG_SHAPE;

    public ChoppedLogBlock(AbstractBlock.Properties properties) {
        super(properties.func_208770_d());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)CHOPS, (Comparable)Integer.valueOf(1))).func_206870_a(SHAPE, (Comparable)((Object)ChoppedLogShape.PILLAR_Y)));
    }

    public static ChoppedLogShape getPlacementShape(IWorld world, BlockPos blockPos) {
        boolean DOWN = true;
        int UP = 2;
        int NORTH = 4;
        int SOUTH = 8;
        int WEST = 16;
        int EAST = 32;
        byte openSides = (byte)((ChoppedLogBlock.isBlockOpen(world, blockPos.func_177977_b()) ? 1 : 0) | (!ChopUtil.isBlockALog(world, blockPos.func_177984_a()) ? 2 : 0) | (!ChopUtil.isBlockALog(world, blockPos.func_177978_c()) ? 4 : 0) | (!ChopUtil.isBlockALog(world, blockPos.func_177968_d()) ? 8 : 0) | (!ChopUtil.isBlockALog(world, blockPos.func_177976_e()) ? 16 : 0) | (!ChopUtil.isBlockALog(world, blockPos.func_177974_f()) ? 32 : 0));
        return ChoppedLogShape.forOpenSides(openSides);
    }

    private static boolean isBlockOpen(IWorld world, BlockPos pos) {
        return world.func_175623_d(pos.func_177977_b()) || ChopUtil.isBlockLeaves(world, pos.func_177977_b());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int chops = (Integer)state.func_177229_b((Property)CHOPS);
        AxisAlignedBB box = ((ChoppedLogShape)((Object)state.func_177229_b(SHAPE))).getBoundingBox(chops);
        VoxelShape voxelShape = Block.func_208617_a((double)box.func_197745_a(Direction.Axis.X), (double)box.func_197745_a(Direction.Axis.Y), (double)box.func_197745_a(Direction.Axis.Z), (double)box.func_197742_b(Direction.Axis.X), (double)box.func_197742_b(Direction.Axis.Y), (double)box.func_197742_b(Direction.Axis.Z));
        return voxelShape;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        return ((ChoppedLogShape)((Object)state.func_177229_b(SHAPE))).getOcclusionShape();
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CHOPS, SHAPE});
    }

    @Override
    public BlockState withChops(BlockState blockState, int numChops) {
        if (numChops > this.getMaxNumChops()) {
            throw new IllegalArgumentException("Too many chops");
        }
        return (BlockState)blockState.func_206870_a((Property)CHOPS, (Comparable)Integer.valueOf(numChops));
    }

    @Override
    public int getNumChops(BlockState blockState) {
        return (Integer)blockState.func_177229_b((Property)CHOPS);
    }

    @Override
    public int getMaxNumChops() {
        return 7;
    }
}

