/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import ht.treechop.client.Client;
import ht.treechop.client.gui.element.ButtonGui;
import ht.treechop.client.gui.element.EmptyGui;
import ht.treechop.client.gui.element.ExclusiveButtonsGui;
import ht.treechop.client.gui.element.LabeledGui;
import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.element.RowsGui;
import ht.treechop.client.gui.element.ToggleGui;
import ht.treechop.client.gui.util.Sprite;
import ht.treechop.client.gui.widget.StickyWidget;
import ht.treechop.client.gui.widget.ToggleWidget;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ClientSettingsScreen
extends Screen {
    private static final int ROW_SEPARATION = 1;
    private static final int INSET_SIZE = 20;
    private static final boolean IS_PAUSE_SCREEN = true;
    private static final int SPACE_ABOVE_AND_BELOW_LIST = 20;
    private static final int MIN_HEIGHT = 83;
    protected RowsGui optionsList;
    private Button doneButton;
    private int optionsPage = 0;
    private boolean needToRebuild = false;

    public ClientSettingsScreen() {
        super((ITextComponent)new TranslationTextComponent("treechop.gui.settings.title", new Object[]{"HT's TreeChop"}));
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.rebuild();
    }

    private void rebuild() {
        List<NestedGui> optionRows = this.optionsPage == 0 ? this.makePageOne() : this.makePageTwo();
        this.addBufferRows(optionRows);
        optionRows.add(new ButtonGui(this.optionsPage == 0 ? Sprite.PAGE_ONE : Sprite.PAGE_TWO, this.optionsPage == 0 ? Sprite.HIGHLIGHTED_PAGE_ONE : Sprite.HIGHLIGHTED_PAGE_TWO, () -> {
            this.needToRebuild = true;
            this.optionsPage = this.optionsPage == 0 ? 1 : 0;
        }));
        this.optionsList = (RowsGui)this.func_230481_d_((IGuiEventListener)new RowsGui(1, optionRows));
        int doneButtonWidth = 200;
        this.doneButton = (Button)this.func_230480_a_((Widget)new Button((this.field_230708_k_ - 200) / 2, this.getDoneButtonTop(), 200, 20, ITextComponent.func_244388_a((String)I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])), button -> this.func_231175_as__()));
    }

    private void addBufferRows(List<NestedGui> rows) {
        int missingHeight = 83 - RowsGui.getHeightForRows(rows, 1) - 2;
        if (missingHeight > 0) {
            rows.add(0, new EmptyGui(0, Math.floorDiv(missingHeight, 2)));
            rows.add(new EmptyGui(0, (int)Math.ceil((float)missingHeight / 2.0f)));
        }
    }

    private List<NestedGui> makePageOne() {
        LinkedList<NestedGui> optionRows = new LinkedList<NestedGui>();
        optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.chopping"), this.makeToggleSettingRow(SettingsField.CHOPPING)));
        if (((Boolean)ConfigHandler.CLIENT.showFellingOptions.get()).booleanValue()) {
            optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.felling"), this.makeToggleSettingRow(SettingsField.FELLING)));
            optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.sneaking_inverts"), new ExclusiveButtonsGui.Builder().add((ITextComponent)new TranslationTextComponent("treechop.gui.settings.button.chopping"), () -> Client.getChopSettings().setSneakBehavior(SneakBehavior.INVERT_CHOPPING), () -> StickyWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_CHOPPING, this.isSettingPermitted(SettingsField.CHOPPING, !Client.getChopSettings().getChoppingEnabled()) && this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)SneakBehavior.INVERT_CHOPPING))).add((ITextComponent)new TranslationTextComponent("treechop.gui.settings.button.felling"), () -> Client.getChopSettings().setSneakBehavior(SneakBehavior.INVERT_FELLING), () -> StickyWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_FELLING, this.isSettingPermitted(SettingsField.FELLING, !Client.getChopSettings().getFellingEnabled()) && this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)SneakBehavior.INVERT_FELLING))).add((ITextComponent)new TranslationTextComponent("treechop.gui.settings.button.nothing"), () -> Client.getChopSettings().setSneakBehavior(SneakBehavior.NONE), () -> this.makeStickyWidgetState(SettingsField.SNEAK_BEHAVIOR, (Object)SneakBehavior.NONE)).build()));
        } else {
            optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.sneaking_inverts_chopping"), new ToggleGui(() -> Client.getChopSettings().setSneakBehavior(this.getNextSneakBehavior()), () -> ToggleWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_CHOPPING, this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)this.getNextSneakBehavior())))));
        }
        optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.only_chop_trees_with_leaves"), this.makeToggleSettingRow(SettingsField.TREES_MUST_HAVE_LEAVES)));
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.chop_in_creative_mode"), this.makeToggleSettingRow(SettingsField.CHOP_IN_CREATIVE_MODE)));
        }
        return optionRows;
    }

    private LinkedList<NestedGui> makePageTwo() {
        LinkedList<NestedGui> optionRows = new LinkedList<NestedGui>();
        optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.chop_in_creative_mode"), this.makeToggleSettingRow(SettingsField.CHOP_IN_CREATIVE_MODE)));
        optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.chopping_indicator"), new ToggleGui(() -> Client.setChoppingIndicatorVisibility(!Client.isChoppingIndicatorEnabled()), () -> ToggleWidget.State.of(Client.isChoppingIndicatorEnabled(), true))));
        optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.feedback_messages"), new ToggleGui(() -> ConfigHandler.CLIENT.showFeedbackMessages.set((Object)((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get() == false ? 1 : 0)), () -> ToggleWidget.State.of((Boolean)ConfigHandler.CLIENT.showFeedbackMessages.get(), true))));
        optionRows.add(new LabeledGui(this.field_230712_o_, (ITextComponent)new TranslationTextComponent("treechop.gui.settings.label.felling_options"), new ToggleGui(() -> ConfigHandler.CLIENT.showFellingOptions.set((Object)((Boolean)ConfigHandler.CLIENT.showFellingOptions.get() == false ? 1 : 0)), () -> ToggleWidget.State.of((Boolean)ConfigHandler.CLIENT.showFellingOptions.get(), Client.getServerPermissions().isPermitted(new Setting(SettingsField.FELLING, false))))));
        return optionRows;
    }

    private SneakBehavior getNextSneakBehavior() {
        return Client.getChopSettings().getSneakBehavior() == SneakBehavior.NONE ? SneakBehavior.INVERT_CHOPPING : SneakBehavior.NONE;
    }

    private ToggleGui makeToggleSettingRow(SettingsField field) {
        return new ToggleGui(() -> Client.getChopSettings().set(field, Client.getChopSettings().get(field, Boolean.class) == false), () -> ToggleWidget.State.of(Client.getChopSettings().get(field, Boolean.class), Client.getServerPermissions().isPermitted(new Setting(field, Client.getChopSettings().get(field, Boolean.class) == false))));
    }

    private boolean isSettingPermitted(SettingsField field, Object value) {
        return Client.getServerPermissions().isPermitted(new Setting(field, value));
    }

    private StickyWidget.State makeStickyWidgetState(SettingsField field, Object value) {
        return StickyWidget.State.of(Client.getChopSettings().get(field) == value, Client.getServerPermissions().isPermitted(new Setting(field, value)));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.needToRebuild) {
            this.field_230705_e_.clear();
            this.field_230710_m_.clear();
            this.rebuild();
            this.needToRebuild = false;
        }
        this.func_230446_a_(matrixStack);
        this.doneButton.field_230691_m_ = this.getDoneButtonTop();
        int listTop = this.getListTop();
        int listBottom = this.getListBottom();
        this.optionsList.setBox(0, listTop, this.field_230708_k_, listBottom - listTop);
        this.optionsList.render(matrixStack, mouseX, mouseY, partialTicks);
        ClientSettingsScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)this.getTitleTop(), (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_230446_a_(MatrixStack matrixStack) {
        super.func_230446_a_(matrixStack);
        ClientSettingsScreen.func_238467_a_((MatrixStack)matrixStack, (int)20, (int)20, (int)(this.field_230708_k_ - 20), (int)(this.field_230709_l_ - 20), (int)128);
    }

    public boolean func_231177_au__() {
        return true;
    }

    protected int getTop() {
        return 32;
    }

    protected int getBottom() {
        return this.field_230709_l_ - 32;
    }

    protected int getMiddleY() {
        return (this.getTop() + this.getBottom()) / 2;
    }

    protected int getTitleTop() {
        return this.getListTop() - 20 - 8;
    }

    protected int getListTop() {
        return this.getMiddleY() - this.getListHeight() / 2;
    }

    protected int getListHeight() {
        return this.optionsList.getHeight();
    }

    protected int getListBottom() {
        return this.getMiddleY() + this.getListHeight() / 2;
    }

    protected int getDoneButtonTop() {
        return this.getListBottom() + 20;
    }
}

