/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.element;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.widget.StickyWidget;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;

public class ExclusiveButtonsGui
extends NestedGui {
    private final List<Widget> widgets;

    protected ExclusiveButtonsGui(Collection<Widget> widgets) {
        this.widgets = Lists.newArrayList(widgets);
    }

    public void resize(int width) {
        if (this.getMinimumWidth() < width) {
            int targetWidth = width / this.widgets.size();
            List smallerWidgets = this.widgets.stream().filter(widget -> widget.func_230998_h_() <= targetWidth).collect(Collectors.toList());
            List biggerWidgets = this.widgets.stream().filter(widget -> widget.func_230998_h_() > targetWidth).collect(Collectors.toList());
            int totalWidthForSmallers = width - biggerWidgets.stream().map(Widget::func_230998_h_).reduce(Integer::sum).orElse(0);
            int i = 0;
            for (Widget widget2 : smallerWidgets) {
                double lower = (double)i / (double)smallerWidgets.size();
                double upper = (double)(i + 1) / (double)smallerWidgets.size();
                int widgetWidth = (int)((double)totalWidthForSmallers * (upper - lower));
                widget2.func_230991_b_(widgetWidth);
                ++i;
            }
        }
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.widgets;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int x = this.getBox().getLeft();
        int y = this.getBox().getTop();
        for (Widget widget : this.widgets) {
            widget.field_230690_l_ = x;
            widget.field_230691_m_ = y;
            widget.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            x += widget.func_230998_h_();
        }
    }

    @Override
    public int getMinimumWidth() {
        return this.widgets.stream().map(Widget::func_230998_h_).reduce(Integer::sum).orElse(0);
    }

    @Override
    public int getMinimumHeight() {
        return this.widgets.stream().map(Widget::func_238483_d_).reduce(Integer::max).orElse(0);
    }

    public static class Builder {
        private final List<Option> options = new LinkedList<Option>();

        public Builder add(ITextComponent name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
            this.options.add(new Option(name, onPress, stateSupplier));
            return this;
        }

        public ExclusiveButtonsGui build() {
            List<Widget> widgets = this.options.stream().map(option -> new StickyWidget(0, 0, 0, 0, ((Option)option).name, ((Option)option).onPress, ((Option)option).stateSupplier)).collect(Collectors.toList());
            return new ExclusiveButtonsGui(widgets);
        }

        private static class Option {
            private ITextComponent name;
            private Runnable onPress;
            private Supplier<StickyWidget.State> stateSupplier;

            public Option(ITextComponent name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
                this.name = name;
                this.onPress = onPress;
                this.stateSupplier = stateSupplier;
            }
        }
    }
}

