/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import ht.treechop.TreeChopMod;
import ht.treechop.client.KeyBindings;
import ht.treechop.client.gui.screen.ChopIndicator;
import ht.treechop.client.gui.screen.ClientSettingsScreen;
import ht.treechop.client.model.ChoppedLogBakedModel;
import ht.treechop.client.settings.ClientChopSettings;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.init.ModBlocks;
import ht.treechop.common.network.ClientRequestSettingsPacket;
import ht.treechop.common.network.PacketHandler;
import ht.treechop.common.settings.Permissions;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod.EventBusSubscriber(modid="treechop", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Client {
    private static final ClientChopSettings chopSettings = new ClientChopSettings();
    private static final ChopIndicator chopIndicator = new ChopIndicator();
    private static final Permissions serverPermissions = new Permissions();

    public static void init() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (((Boolean)ConfigHandler.CLIENT.useProceduralChoppedModels.get()).booleanValue()) {
            modBus.addListener(ChoppedLogBakedModel::overrideBlockStateModels);
        }
        if (((Boolean)ConfigHandler.CLIENT.showChoppingIndicators.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.addListener(Client::renderOverlay);
        }
        KeyBindings.init();
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CHOPPED_LOG.get()), (RenderType)RenderType.func_228639_c_());
    }

    @SubscribeEvent
    public static void onConnect(ClientPlayerNetworkEvent.LoggedInEvent event) {
        TreeChopMod.LOGGER.info("Sending chop settings sync request");
        chopSettings.copyFrom(ConfigHandler.CLIENT.getChopSettings());
        PacketHandler.sendToServer(new ClientRequestSettingsPacket(chopSettings));
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        if (!event.isCanceled() && event.getKey() != -1) {
            KeyBindings.buttonPressed(event.getKey(), event.getAction());
        }
    }

    public static void requestSetting(SettingsField field, Object value) {
        PacketHandler.sendToServer(new ClientRequestSettingsPacket(field, value));
    }

    public static void toggleChopping() {
        boolean newValue = chopSettings.get(SettingsField.CHOPPING, Boolean.class) == false;
        chopSettings.set(SettingsField.CHOPPING, newValue);
    }

    public static void toggleFelling() {
        boolean newValue = chopSettings.get(SettingsField.FELLING, Boolean.class) == false;
        chopSettings.set(SettingsField.FELLING, newValue);
    }

    public static void cycleSneakBehavior() {
        SneakBehavior newValue = (Boolean)ConfigHandler.CLIENT.showFellingOptions.get() != false ? chopSettings.getSneakBehavior().cycle() : (chopSettings.getSneakBehavior() == SneakBehavior.NONE ? SneakBehavior.INVERT_CHOPPING : SneakBehavior.NONE);
        chopSettings.set(SettingsField.SNEAK_BEHAVIOR, (Object)newValue);
    }

    public static ClientChopSettings getChopSettings() {
        return chopSettings;
    }

    public static void setChoppingIndicatorVisibility(boolean showChoppingIndicator) {
        ConfigHandler.CLIENT.showChoppingIndicators.set((Object)showChoppingIndicator);
    }

    public static boolean isChoppingIndicatorEnabled() {
        return (Boolean)ConfigHandler.CLIENT.showChoppingIndicators.get();
    }

    public static void toggleSettingsOverlay() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof ClientSettingsScreen) {
            minecraft.field_71462_r.func_231175_as__();
        } else {
            minecraft.func_147108_a((Screen)new ClientSettingsScreen());
        }
    }

    public static void renderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            chopIndicator.render(event.getWindow(), event.getMatrixStack(), event.getPartialTicks());
        }
    }

    public static void updatePermissions(Permissions permissions) {
        serverPermissions.copy(permissions);
    }

    public static Permissions getServerPermissions() {
        return serverPermissions;
    }
}

