/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.common.BackpackModelProperty;
import com.mrcrayfish.backpacked.network.message.IMessage;
import com.mrcrayfish.backpacked.network.play.ClientPlayHandler;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageUpdateBackpack
implements IMessage<MessageUpdateBackpack> {
    private int entityId;
    private ItemStack backpack;

    public MessageUpdateBackpack() {
    }

    public MessageUpdateBackpack(int entityId, ItemStack backpack) {
        this.entityId = entityId;
        this.backpack = backpack;
    }

    @Override
    public void encode(MessageUpdateBackpack message, PacketBuffer buffer) {
        buffer.writeInt(message.entityId);
        this.writeBackpackStack(buffer, message.backpack);
    }

    @Override
    public MessageUpdateBackpack decode(PacketBuffer buffer) {
        return new MessageUpdateBackpack(buffer.readInt(), buffer.func_150791_c());
    }

    @Override
    public void handle(MessageUpdateBackpack message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientPlayHandler.handleUpdateBackpack(message));
        supplier.get().setPacketHandled(true);
    }

    private void writeBackpackStack(PacketBuffer buffer, ItemStack stack) {
        boolean empty = stack.func_190926_b();
        buffer.writeBoolean(!empty);
        if (!empty) {
            Item item = stack.func_77973_b();
            buffer.func_150787_b(Item.func_150891_b((Item)item));
            buffer.writeByte(stack.func_190916_E());
            CompoundNBT realTag = stack.func_196082_o();
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("BackpackModel", realTag.func_74779_i("BackpackModel"));
            for (BackpackModelProperty property : BackpackModelProperty.values()) {
                String tagName = property.getTagName();
                boolean value = realTag.func_150297_b(tagName, 1) ? realTag.func_74767_n(tagName) : property.getDefaultValue();
                tag.func_74757_a(tagName, value);
            }
            buffer.func_150786_a(tag);
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }
}

