/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.network.message.IMessage;
import com.mrcrayfish.backpacked.network.play.ClientPlayHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSyncUnlockTracker
implements IMessage<MessageSyncUnlockTracker> {
    private Set<ResourceLocation> unlockedBackpacks;

    public MessageSyncUnlockTracker() {
    }

    public MessageSyncUnlockTracker(Set<ResourceLocation> unlockedBackpacks) {
        this.unlockedBackpacks = unlockedBackpacks;
    }

    @Override
    public void encode(MessageSyncUnlockTracker message, PacketBuffer buffer) {
        buffer.writeInt(message.unlockedBackpacks.size());
        message.unlockedBackpacks.forEach(arg_0 -> ((PacketBuffer)buffer).func_192572_a(arg_0));
    }

    @Override
    public MessageSyncUnlockTracker decode(PacketBuffer buffer) {
        int size = buffer.readInt();
        HashSet<ResourceLocation> unlockedBackpacks = new HashSet<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            unlockedBackpacks.add(buffer.func_192575_l());
        }
        return new MessageSyncUnlockTracker(unlockedBackpacks);
    }

    @Override
    public void handle(MessageSyncUnlockTracker message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ClientPlayHandler.handleSyncUnlockTracker(message));
        supplier.get().setPacketHandled(true);
    }

    public Set<ResourceLocation> getUnlockedBackpacks() {
        return this.unlockedBackpacks;
    }
}

