/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.network.message.IMessage;
import com.mrcrayfish.backpacked.network.play.ServerPlayHandler;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageBackpackCosmetics
implements IMessage<MessageBackpackCosmetics> {
    private ResourceLocation id;
    private boolean showWithElytra;
    private boolean showEffects;

    public MessageBackpackCosmetics() {
    }

    public MessageBackpackCosmetics(ResourceLocation id, boolean showWithElytra, boolean showEffects) {
        this.id = id;
        this.showWithElytra = showWithElytra;
        this.showEffects = showEffects;
    }

    @Override
    public void encode(MessageBackpackCosmetics message, PacketBuffer buffer) {
        buffer.func_192572_a(message.id);
        buffer.writeBoolean(message.showWithElytra);
        buffer.writeBoolean(message.showEffects);
    }

    @Override
    public MessageBackpackCosmetics decode(PacketBuffer buffer) {
        return new MessageBackpackCosmetics(buffer.func_192575_l(), buffer.readBoolean(), buffer.readBoolean());
    }

    @Override
    public void handle(MessageBackpackCosmetics message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> ServerPlayHandler.handleCustomiseBackpack(message, ((NetworkEvent.Context)supplier.get()).getSender()));
        supplier.get().setPacketHandled(true);
    }

    public ResourceLocation getBackpackId() {
        return this.id;
    }

    public boolean isShowWithElytra() {
        return this.showWithElytra;
    }

    public boolean isShowEffects() {
        return this.showEffects;
    }
}

