/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.item;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.client.ModelInstances;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.inventory.container.BackpackContainer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;

public class BackpackItem
extends Item {
    public static final TranslationTextComponent BACKPACK_TRANSLATION = new TranslationTextComponent("container.backpack");
    public static final IFormattableTextComponent REMOVE_ITEMS_TOOLTIP = new TranslationTextComponent("backpacked.tooltip.remove_items").func_240699_a_(TextFormatting.RED);

    public BackpackItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ExtendedPlayerInventory inventory;
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        if (playerIn.field_71071_by instanceof ExtendedPlayerInventory && ((ItemStack)(inventory = (ExtendedPlayerInventory)playerIn.field_71071_by).getBackpackItems().get(0)).func_190926_b()) {
            playerIn.field_71071_by.func_70299_a(41, heldItem.func_77946_l());
            heldItem.func_190920_e(0);
            playerIn.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)heldItem);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (!Backpacked.isCuriosLoaded()) {
            return null;
        }
        return Curios.createBackpackProvider(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        ClientHandler.createBackpackTooltip(stack, list);
    }

    public static boolean openBackpack(ServerPlayerEntity ownerPlayer, ServerPlayerEntity openingPlayer) {
        ItemStack backpack = Backpacked.getBackpackStack((PlayerEntity)ownerPlayer);
        if (!backpack.func_190926_b()) {
            BackpackInventory backpackInventory = ((BackpackedInventoryAccess)ownerPlayer).getBackpackedInventory();
            if (backpackInventory == null) {
                return false;
            }
            BackpackItem backpackItem = (BackpackItem)backpack.func_77973_b();
            TranslationTextComponent title = backpack.func_82837_s() ? backpack.func_200301_q() : BACKPACK_TRANSLATION;
            int cols = backpackItem.getColumnCount();
            int rows = backpackItem.getRowCount();
            boolean owner = ownerPlayer.equals((Object)openingPlayer);
            NetworkHooks.openGui((ServerPlayerEntity)ownerPlayer, (INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInventory, entity) -> new BackpackContainer(id, ownerPlayer.field_71071_by, (IInventory)backpackInventory, cols, rows, owner), (ITextComponent)title), buffer -> {
                buffer.func_150787_b(cols);
                buffer.func_150787_b(rows);
                buffer.writeBoolean(owner);
            });
            return true;
        }
        return false;
    }

    public int getColumnCount() {
        return (Integer)Config.COMMON.backpackInventorySizeColumns.get();
    }

    public int getRowCount() {
        return (Integer)Config.COMMON.backpackInventorySizeRows.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BackpackModel getDefaultModel() {
        return ModelInstances.STANDARD;
    }
}

