/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.common.IProgressTracker;
import com.mrcrayfish.backpacked.common.UnlockTracker;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Backpack {
    private final ResourceLocation id;

    public Backpack(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isUnlocked(PlayerEntity player) {
        return UnlockTracker.get(player).map(impl -> impl.getUnlockedBackpacks().contains(this.id)).orElse(false) != false || (Boolean)Config.SERVER.unlockAllBackpacks.get() != false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(PlayerEntity player, Vector3d pos) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract BackpackModel getModel();

    @Nullable
    protected IProgressTracker createProgressTracker() {
        return null;
    }
}

