/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.model.BackpackModel;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.common.BackpackModelProperty;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessagePlayerBackpack;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEvents {
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof BackpackScreen) {
            if (event.getAction() == 1 && event.getKey() == ClientHandler.KEY_BACKPACK.getKey().func_197937_c()) {
                minecraft.field_71439_g.func_71053_j();
            }
        } else if (minecraft.field_71439_g != null && minecraft.field_71462_r == null) {
            ClientPlayerEntity player = minecraft.field_71439_g;
            if (ClientHandler.KEY_BACKPACK.func_151470_d() && ClientHandler.KEY_BACKPACK.func_151468_f() && !Backpacked.getBackpackStack((PlayerEntity)player).func_190926_b()) {
                Network.getPlayChannel().sendToServer((Object)new MessageOpenBackpack());
            }
        }
    }

    @SubscribeEvent
    public void onClientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        List players = mc.field_71441_e.func_217394_a(EntityType.field_200729_aH, mc.field_71439_g.func_174813_aQ().func_186662_g(16.0), player -> true);
        for (PlayerEntity player2 : players) {
            ItemStack stack;
            if (Backpacked.isCuriosLoaded() && !Curios.isBackpackVisible(player2) || (stack = Backpacked.getBackpackStack(player2)).func_190926_b() || !ClientEvents.canShowBackpackEffects(stack)) continue;
            String modelName = stack.func_196082_o().func_74779_i("BackpackModel");
            BackpackModel model = BackpackLayer.getModel(modelName);
            model.tickForPlayer(PickpocketUtil.getBackpackBox(player2, 1.0f).func_189972_c(), player2);
        }
    }

    public static boolean canShowBackpackEffects(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_150297_b(BackpackModelProperty.SHOW_EFFECTS.getTagName(), 1)) {
            return tag.func_74767_n(BackpackModelProperty.SHOW_EFFECTS.getTagName());
        }
        return true;
    }

    @SubscribeEvent
    public void onRightClick(InputEvent.ClickInputEvent event) {
        if (event.isUseItem() && ((Boolean)Config.SERVER.pickpocketBackpacks.get()).booleanValue() && this.performBackpackRaytrace()) {
            event.setCanceled(true);
        }
    }

    private boolean performBackpackRaytrace() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || mc.field_71442_b == null) {
            return false;
        }
        double range = (Double)Config.SERVER.pickpocketMaxReachDistance.get();
        List players = mc.field_71441_e.func_217394_a(EntityType.field_200729_aH, mc.field_71439_g.func_174813_aQ().func_186662_g(range), player -> !Backpacked.getBackpackStack(player).func_190926_b() && !player.equals((Object)mc.field_71439_g) && PickpocketUtil.canPickpocketPlayer(player, (PlayerEntity)mc.field_71439_g));
        if (players.isEmpty()) {
            return false;
        }
        Vector3d start = mc.field_71439_g.func_174824_e(1.0f);
        Vector3d end = mc.field_71439_g.func_70676_i(1.0f).func_186678_a((double)mc.field_71442_b.func_78757_d()).func_178787_e(start);
        double closestDistance = Double.MAX_VALUE;
        PlayerEntity hitPlayer = null;
        for (PlayerEntity player2 : players) {
            double distance;
            AxisAlignedBB box = PickpocketUtil.getBackpackBox(player2, 1.0f);
            Optional optionalHitVec = box.func_216365_b(start, end);
            if (!optionalHitVec.isPresent() || !((distance = start.func_72438_d((Vector3d)optionalHitVec.get())) < closestDistance)) continue;
            closestDistance = distance;
            hitPlayer = player2;
        }
        if (hitPlayer != null && PickpocketUtil.canSeeBackpack(hitPlayer, (PlayerEntity)mc.field_71439_g)) {
            Network.getPlayChannel().sendToServer((Object)new MessagePlayerBackpack(hitPlayer.func_145782_y()));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_175598_ae().func_178634_b()) {
            return;
        }
        if (!((Boolean)Config.SERVER.pickpocketBackpacks.get()).booleanValue()) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        stack.func_227860_a_();
        Vector3d view = mc.field_71460_t.func_215316_n().func_216785_c();
        stack.func_227861_a_(-view.func_82615_a(), -view.field_72448_b, -view.func_82616_c());
        IRenderTypeBuffer.Impl source = mc.func_228019_au_().func_228487_b_();
        for (PlayerEntity player : mc.field_71441_e.func_217369_A()) {
            if (Backpacked.getBackpackStack(player).func_190926_b() || player.func_175144_cb()) continue;
            boolean inReach = PickpocketUtil.inReachOfBackpack(player, (PlayerEntity)mc.field_71439_g) && PickpocketUtil.canSeeBackpack(player, (PlayerEntity)mc.field_71439_g);
            float boxRed = inReach ? 0.0f : 1.0f;
            float boxGreen = inReach ? 1.0f : 1.0f;
            float boxBlue = inReach ? 0.0f : 1.0f;
            IVertexBuilder builder = source.getBuffer(RenderType.func_228659_m_());
            WorldRenderer.func_228430_a_((MatrixStack)stack, (IVertexBuilder)builder, (AxisAlignedBB)PickpocketUtil.getBackpackBox(player, event.getPartialTicks()), (float)boxRed, (float)boxGreen, (float)boxBlue, (float)1.0f);
            float bodyRotation = MathHelper.func_219799_g((float)event.getPartialTicks(), (float)player.field_70760_ar, (float)player.field_70761_aq);
            boolean inRange = PickpocketUtil.inRangeOfBackpack(player, (PlayerEntity)mc.field_71439_g);
            float lineRed = inRange ? 0.0f : 1.0f;
            float lineGreen = inRange ? 1.0f : 1.0f;
            float lineBlue = inRange ? 0.0f : 1.0f;
            Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
            Vector3d pos = player.func_242282_l(event.getPartialTicks());
            Vector3d start = Vector3d.func_189986_a((float)0.0f, (float)(bodyRotation + 180.0f - ((Double)Config.SERVER.pickpocketMaxRangeAngle.get()).floatValue())).func_186678_a(((Double)Config.SERVER.pickpocketMaxReachDistance.get()).doubleValue());
            Vector3d end = Vector3d.func_189986_a((float)0.0f, (float)(bodyRotation - 180.0f + ((Double)Config.SERVER.pickpocketMaxRangeAngle.get()).floatValue())).func_186678_a(((Double)Config.SERVER.pickpocketMaxReachDistance.get()).doubleValue());
            builder.func_227888_a_(matrix4f, (float)(pos.field_72450_a + start.field_72450_a), (float)(pos.field_72448_b + start.field_72448_b), (float)(pos.field_72449_c + start.field_72449_c)).func_227885_a_(lineRed, lineGreen, lineBlue, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c).func_227885_a_(lineRed, lineGreen, lineBlue, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, (float)(pos.field_72450_a + end.field_72450_a), (float)(pos.field_72448_b + end.field_72448_b), (float)(pos.field_72449_c + end.field_72449_c)).func_227885_a_(lineRed, lineGreen, lineBlue, 1.0f).func_181675_d();
            builder.func_227888_a_(matrix4f, (float)pos.field_72450_a, (float)pos.field_72448_b, (float)pos.field_72449_c).func_227885_a_(lineRed, lineGreen, lineBlue, 1.0f).func_181675_d();
        }
        source.func_228462_a_(RenderType.func_228659_m_());
        stack.func_227865_b_();
    }
}

