/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityMoose;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.world.World;

public class MooseAIJostle
extends Goal {
    private static final EntityPredicate JOSTLE_PREDICATE = new EntityPredicate().func_221013_a(16.0).func_221008_a().func_221011_b();
    protected EntityMoose targetMoose;
    private EntityMoose moose;
    private World world;
    private float angle;

    public MooseAIJostle(EntityMoose moose) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        this.moose = moose;
        this.world = moose.field_70170_p;
    }

    public boolean func_75250_a() {
        if (this.moose.isJostling() || !this.moose.isAntlered() || this.moose.func_70631_g_() || this.moose.func_70638_az() != null || this.moose.jostleCooldown > 0) {
            return false;
        }
        if (this.moose.instantlyTriggerJostleAI || this.moose.func_70681_au().nextInt(30) == 0) {
            this.moose.instantlyTriggerJostleAI = false;
            if (this.moose.getJostlingPartner() instanceof EntityMoose) {
                this.targetMoose = (EntityMoose)this.moose.getJostlingPartner();
                return this.targetMoose.jostleCooldown == 0;
            }
            EntityMoose possiblePartner = this.getNearbyMoose();
            if (possiblePartner != null) {
                this.moose.setJostlingPartner((Entity)possiblePartner);
                possiblePartner.setJostlingPartner((Entity)this.moose);
                this.targetMoose = possiblePartner;
                this.targetMoose.instantlyTriggerJostleAI = true;
                return true;
            }
        }
        return false;
    }

    public void func_75249_e() {
        this.moose.jostleTimer = 0;
        this.angle = 0.0f;
        this.setJostleDirection(this.moose.func_70681_au().nextBoolean());
    }

    public void setJostleDirection(boolean dir) {
        this.moose.jostleDirection = dir;
        this.targetMoose.jostleDirection = dir;
    }

    public void func_75251_c() {
        this.moose.setJostling(false);
        this.moose.setJostlingPartner(null);
        this.moose.jostleTimer = 0;
        this.angle = 0.0f;
        this.moose.func_70661_as().func_75499_g();
        if (this.targetMoose != null) {
            this.targetMoose.setJostling(false);
            this.targetMoose.setJostlingPartner(null);
            this.targetMoose.jostleTimer = 0;
            this.targetMoose = null;
        }
    }

    public void func_75246_d() {
        if (this.targetMoose != null) {
            this.moose.func_70625_a((Entity)this.targetMoose, 360.0f, 180.0f);
            this.moose.setJostling(true);
            double dist = this.moose.func_70032_d((Entity)this.targetMoose);
            if (dist < 3.5) {
                this.moose.func_70661_as().func_75499_g();
                this.moose.func_70605_aq().func_188488_a(-0.5f, 0.0f);
            } else if (dist > 4.0) {
                this.moose.setJostling(false);
                this.moose.func_70661_as().func_75497_a((Entity)this.targetMoose, 1.0);
            } else {
                this.moose.func_70625_a((Entity)this.targetMoose, 360.0f, 180.0f);
                if (this.moose.jostleDirection) {
                    if (this.angle < 30.0f) {
                        this.angle += 1.0f;
                    }
                    this.moose.func_70605_aq().func_188488_a(0.0f, -0.2f);
                }
                if (!this.moose.jostleDirection) {
                    if (this.angle > -30.0f) {
                        this.angle -= 1.0f;
                    }
                    this.moose.func_70605_aq().func_188488_a(0.0f, 0.2f);
                }
                if (this.moose.func_70681_au().nextInt(55) == 0 && this.moose.func_233570_aj_()) {
                    this.moose.pushBackJostling(this.targetMoose, 0.2f);
                }
                if (this.moose.func_70681_au().nextInt(25) == 0 && this.moose.func_233570_aj_()) {
                    this.moose.playJostleSound();
                }
                this.moose.setJostleAngle(this.angle);
                if (this.moose.jostleTimer % 60 == 0 || this.moose.func_70681_au().nextInt(80) == 0) {
                    this.setJostleDirection(!this.moose.jostleDirection);
                }
                ++this.moose.jostleTimer;
                ++this.targetMoose.jostleTimer;
                if (this.moose.jostleTimer > 1000) {
                    this.moose.field_70160_al = true;
                    if (this.moose.func_233570_aj_()) {
                        this.moose.pushBackJostling(this.targetMoose, 0.9f);
                    }
                    if (this.targetMoose.func_233570_aj_()) {
                        this.targetMoose.pushBackJostling(this.moose, 0.9f);
                    }
                    this.moose.jostleTimer = 0;
                    this.targetMoose.jostleTimer = 0;
                    this.moose.jostleCooldown = 500 + this.moose.func_70681_au().nextInt(2000);
                    this.targetMoose.jostleTimer = 0;
                    this.targetMoose.jostleCooldown = 500 + this.targetMoose.func_70681_au().nextInt(2000);
                    this.func_75251_c();
                }
            }
        }
    }

    public boolean func_75253_b() {
        return !this.moose.func_70631_g_() && this.moose.isAntlered() && this.moose.func_70638_az() == null && this.targetMoose != null && this.targetMoose.isAntlered() && this.targetMoose.func_70089_S() && this.moose.jostleCooldown == 0 && this.targetMoose.jostleCooldown == 0;
    }

    @Nullable
    private EntityMoose getNearbyMoose() {
        List listOfMeese = this.world.func_217374_a(EntityMoose.class, JOSTLE_PREDICATE, (LivingEntity)this.moose, this.moose.func_174813_aQ().func_186662_g(16.0));
        double lvt_2_1_ = Double.MAX_VALUE;
        EntityMoose lvt_4_1_ = null;
        for (EntityMoose lvt_6_1_ : listOfMeese) {
            if (!this.moose.canJostleWith(lvt_6_1_) || !(this.moose.func_70068_e((Entity)lvt_6_1_) < lvt_2_1_)) continue;
            lvt_4_1_ = lvt_6_1_;
            lvt_2_1_ = this.moose.func_70068_e((Entity)lvt_6_1_);
        }
        return lvt_4_1_;
    }
}

