/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelMimicOctopus;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.client.render.OctopusColorRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RenderMimicOctopus
extends MobRenderer<EntityMimicOctopus, ModelMimicOctopus> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexsmobs:textures/entity/mimic_octopus.png");
    private static final ResourceLocation TEXTURE_OVERLAY = new ResourceLocation("alexsmobs:textures/entity/mimic_octopus_overlay.png");
    private static final ResourceLocation TEXTURE_CREEPER = new ResourceLocation("alexsmobs:textures/entity/mimic_octopus_creeper.png");
    private static final ResourceLocation TEXTURE_GUARDIAN = new ResourceLocation("alexsmobs:textures/entity/mimic_octopus_guardian.png");
    private static final ResourceLocation TEXTURE_PUFFERFISH = new ResourceLocation("alexsmobs:textures/entity/mimic_octopus_pufferfish.png");
    private static final ResourceLocation TEXTURE_MIMICUBE = new ResourceLocation("alexsmobs:textures/entity/mimic_octopus_mimicube.png");
    private static final ResourceLocation GUARDIAN_BEAM_TEXTURE = new ResourceLocation("textures/entity/guardian_beam.png");
    private static final RenderType field_229107_h_ = RenderType.func_228640_c_((ResourceLocation)GUARDIAN_BEAM_TEXTURE);

    public RenderMimicOctopus(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelMimicOctopus(), 0.4f);
        this.func_177094_a(new OverlayLayer(this));
    }

    private static void func_229108_a_(IVertexBuilder p_229108_0_, Matrix4f p_229108_1_, Matrix3f p_229108_2_, float p_229108_3_, float p_229108_4_, float p_229108_5_, int p_229108_6_, int p_229108_7_, int p_229108_8_, float p_229108_9_, float p_229108_10_) {
        p_229108_0_.func_227888_a_(p_229108_1_, p_229108_3_, p_229108_4_, p_229108_5_).func_225586_a_(p_229108_6_, p_229108_7_, p_229108_8_, 255).func_225583_a_(p_229108_9_, p_229108_10_).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(p_229108_2_, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public void render(EntityMimicOctopus entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        LivingEntity livingentity = entityIn.getGuardianLaser();
        if (livingentity != null) {
            float f = entityIn.getLaserAttackAnimationScale(partialTicks);
            float f1 = (float)entityIn.field_70170_p.func_82737_E() + partialTicks;
            float f2 = f1 * 0.5f % 1.0f;
            float f3 = entityIn.func_70047_e();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.0, (double)f3, 0.0);
            Vector3d vector3d = this.getPosition(livingentity, (double)livingentity.func_213302_cg() * 0.5, partialTicks);
            Vector3d vector3d1 = this.getPosition((LivingEntity)entityIn, f3, partialTicks);
            Vector3d vector3d2 = vector3d.func_178788_d(vector3d1);
            float f4 = (float)(vector3d2.func_72433_c() + 1.0);
            vector3d2 = vector3d2.func_72432_b();
            float f5 = (float)Math.acos(vector3d2.field_72448_b);
            float f6 = (float)Math.atan2(vector3d2.field_72449_c, vector3d2.field_72450_a);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((1.5707964f - f6) * 57.295776f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f5 * 57.295776f));
            boolean i = true;
            float f7 = f1 * 0.05f * -1.5f;
            float f8 = f * f;
            int j = 64 + (int)(f8 * 191.0f);
            int k = 32 + (int)(f8 * 191.0f);
            int l = 128 - (int)(f8 * 64.0f);
            float f9 = 0.2f;
            float f10 = 0.282f;
            float f11 = MathHelper.func_76134_b((float)(f7 + 2.3561945f)) * 0.282f;
            float f12 = MathHelper.func_76126_a((float)(f7 + 2.3561945f)) * 0.282f;
            float f13 = MathHelper.func_76134_b((float)(f7 + 0.7853982f)) * 0.282f;
            float f14 = MathHelper.func_76126_a((float)(f7 + 0.7853982f)) * 0.282f;
            float f15 = MathHelper.func_76134_b((float)(f7 + 3.926991f)) * 0.282f;
            float f16 = MathHelper.func_76126_a((float)(f7 + 3.926991f)) * 0.282f;
            float f17 = MathHelper.func_76134_b((float)(f7 + 5.4977875f)) * 0.282f;
            float f18 = MathHelper.func_76126_a((float)(f7 + 5.4977875f)) * 0.282f;
            float f19 = MathHelper.func_76134_b((float)(f7 + (float)Math.PI)) * 0.2f;
            float f20 = MathHelper.func_76126_a((float)(f7 + (float)Math.PI)) * 0.2f;
            float f21 = MathHelper.func_76134_b((float)(f7 + 0.0f)) * 0.2f;
            float f22 = MathHelper.func_76126_a((float)(f7 + 0.0f)) * 0.2f;
            float f23 = MathHelper.func_76134_b((float)(f7 + 1.5707964f)) * 0.2f;
            float f24 = MathHelper.func_76126_a((float)(f7 + 1.5707964f)) * 0.2f;
            float f25 = MathHelper.func_76134_b((float)(f7 + 4.712389f)) * 0.2f;
            float f26 = MathHelper.func_76126_a((float)(f7 + 4.712389f)) * 0.2f;
            float f27 = 0.0f;
            float f28 = 0.4999f;
            float f29 = -1.0f + f2;
            float f30 = f4 * 2.5f + f29;
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(field_229107_h_);
            MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
            Matrix4f matrix4f = matrixstack$entry.func_227870_a_();
            Matrix3f matrix3f = matrixstack$entry.func_227872_b_();
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, f4, f20, j, k, l, 0.4999f, f30);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f19, 0.0f, f20, j, k, l, 0.4999f, f29);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, 0.0f, f22, j, k, l, 0.0f, f29);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f21, f4, f22, j, k, l, 0.0f, f30);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, f4, f24, j, k, l, 0.4999f, f30);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f23, 0.0f, f24, j, k, l, 0.4999f, f29);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, 0.0f, f26, j, k, l, 0.0f, f29);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f25, f4, f26, j, k, l, 0.0f, f30);
            float f31 = 0.0f;
            if (entityIn.field_70173_aa % 2 == 0) {
                f31 = 0.5f;
            }
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f11, f4, f12, j, k, l, 0.5f, f31 + 0.5f);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f13, f4, f14, j, k, l, 1.0f, f31 + 0.5f);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f17, f4, f18, j, k, l, 1.0f, f31);
            RenderMimicOctopus.func_229108_a_(ivertexbuilder, matrix4f, matrix3f, f15, f4, f16, j, k, l, 0.5f, f31);
            matrixStackIn.func_227865_b_();
        }
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void preRenderCallback(EntityMimicOctopus octo, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227861_a_(0.0, (double)-0.02f, 0.0);
        matrixStackIn.func_227862_a_(0.9f * octo.func_213355_cm(), 0.9f * octo.func_213355_cm(), 0.9f * octo.func_213355_cm());
    }

    public boolean shouldRender(EntityMimicOctopus livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        LivingEntity livingentity;
        if (super.func_225626_a_((MobEntity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.hasGuardianLaser() && (livingentity = livingEntityIn.getGuardianLaser()) != null) {
            Vector3d vector3d = this.getPosition(livingentity, (double)livingentity.func_213302_cg() * 0.5, 1.0f);
            Vector3d vector3d1 = this.getPosition((LivingEntity)livingEntityIn, livingEntityIn.func_70047_e(), 1.0f);
            return camera.func_228957_a_(new AxisAlignedBB(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c));
        }
        return false;
    }

    private Vector3d getPosition(LivingEntity entityLivingBaseIn, double p_177110_2_, float p_177110_4_) {
        double d0 = MathHelper.func_219803_d((double)p_177110_4_, (double)entityLivingBaseIn.field_70142_S, (double)entityLivingBaseIn.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)p_177110_4_, (double)entityLivingBaseIn.field_70137_T, (double)entityLivingBaseIn.func_226278_cu_()) + p_177110_2_;
        double d2 = MathHelper.func_219803_d((double)p_177110_4_, (double)entityLivingBaseIn.field_70136_U, (double)entityLivingBaseIn.func_226281_cx_());
        return new Vector3d(d0, d1, d2);
    }

    public ResourceLocation getEntityTexture(EntityMimicOctopus entity) {
        return TEXTURE;
    }

    class OverlayLayer
    extends LayerRenderer<EntityMimicOctopus, ModelMimicOctopus> {
        public OverlayLayer(RenderMimicOctopus render) {
            super((IEntityRenderer)render);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer buffer, int packedLightIn, EntityMimicOctopus entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float transProgress = entitylivingbaseIn.prevTransProgress + (entitylivingbaseIn.transProgress - entitylivingbaseIn.prevTransProgress) * partialTicks;
            float colorProgress = (entitylivingbaseIn.prevColorShiftProgress + (entitylivingbaseIn.colorShiftProgress - entitylivingbaseIn.prevColorShiftProgress) * partialTicks) * 0.2f;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            float a = 1.0f;
            float startR = 1.0f;
            float startG = 1.0f;
            float startB = 1.0f;
            float startA = 1.0f;
            float finR = 1.0f;
            float finG = 1.0f;
            float finB = 1.0f;
            float finA = 1.0f;
            if (entitylivingbaseIn.getPrevMimicState() == EntityMimicOctopus.MimicState.OVERLAY) {
                if (entitylivingbaseIn.getPrevMimickedBlock() != null) {
                    int j = OctopusColorRegistry.getBlockColor(entitylivingbaseIn.getPrevMimickedBlock());
                    startR = (float)(j >> 16 & 0xFF) / 255.0f;
                    startG = (float)(j >> 8 & 0xFF) / 255.0f;
                    startB = (float)(j & 0xFF) / 255.0f;
                } else {
                    startA = 0.0f;
                }
            }
            if (entitylivingbaseIn.getMimicState() == EntityMimicOctopus.MimicState.OVERLAY) {
                if (entitylivingbaseIn.getMimickedBlock() != null) {
                    int i = OctopusColorRegistry.getBlockColor(entitylivingbaseIn.getMimickedBlock());
                    finR = (float)(i >> 16 & 0xFF) / 255.0f;
                    finG = (float)(i >> 8 & 0xFF) / 255.0f;
                    finB = (float)(i & 0xFF) / 255.0f;
                } else {
                    finA = 0.0f;
                }
                r = startR + (finR - startR) * colorProgress;
                g = startG + (finG - startG) * colorProgress;
                b = startB + (finB - startB) * colorProgress;
                a = startA + (finA - startA) * colorProgress;
            }
            if (a == 1.0f) {
                a *= 0.9f + 0.1f * (float)Math.sin((float)entitylivingbaseIn.field_70173_aa * 0.1f);
            }
            if (entitylivingbaseIn.getPrevMimicState() != null) {
                float alphaPrev = 1.0f - transProgress * 0.2f;
                IVertexBuilder prev = buffer.getBuffer(AMRenderTypes.func_228644_e_((ResourceLocation)this.getFor(entitylivingbaseIn.getPrevMimicState())));
                if (entitylivingbaseIn.getPrevMimicState() == entitylivingbaseIn.getMimicState()) {
                    alphaPrev *= a;
                }
                ((ModelMimicOctopus)this.func_215332_c()).func_225598_a_(matrixStackIn, prev, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f), r, g, b, alphaPrev);
            }
            float alphaCurrent = transProgress * 0.2f;
            IVertexBuilder current = buffer.getBuffer(AMRenderTypes.func_228644_e_((ResourceLocation)this.getFor(entitylivingbaseIn.getMimicState())));
            ((ModelMimicOctopus)this.func_215332_c()).func_225598_a_(matrixStackIn, current, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f), r, g, b, a * alphaCurrent);
        }

        public ResourceLocation getFor(EntityMimicOctopus.MimicState state) {
            if (state == EntityMimicOctopus.MimicState.CREEPER) {
                return TEXTURE_CREEPER;
            }
            if (state == EntityMimicOctopus.MimicState.GUARDIAN) {
                return TEXTURE_GUARDIAN;
            }
            if (state == EntityMimicOctopus.MimicState.PUFFERFISH) {
                return TEXTURE_PUFFERFISH;
            }
            if (state == EntityMimicOctopus.MimicState.MIMICUBE) {
                return TEXTURE_MIMICUBE;
            }
            return TEXTURE_OVERLAY;
        }
    }
}

