/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import vazkii.quark.base.block.QuarkGlassBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.block.IMyaliteColorProvider;

public class MyaliteCrystalBlock
extends QuarkGlassBlock
implements IMyaliteColorProvider {
    public MyaliteCrystalBlock(QuarkModule module) {
        super("myalite_crystal", module, ItemGroup.field_78031_c, AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151678_z).func_200948_a(0.5f, 1200.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(b -> 14).harvestTool(ToolType.PICKAXE).func_235861_h_().harvestLevel(3).func_200944_c().func_226896_b_());
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.TRANSLUCENT);
    }

    private static float[] decompColor(int color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return MyaliteCrystalBlock.decompColor(IMyaliteColorProvider.getColor(pos, this.myaliteS(), this.myaliteB()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d getFogColor(BlockState state, IWorldReader world, BlockPos pos, Entity entity, Vector3d originalColor, float partialTicks) {
        float[] color = MyaliteCrystalBlock.decompColor(IMyaliteColorProvider.getColor(pos, this.myaliteS(), this.myaliteB()));
        return new Vector3d((double)color[0], (double)color[1], (double)color[2]);
    }
}

