/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.client.model;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.container.Transform;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelAnimator {
    private int tempTick = 0;
    private int prevTempTick;
    private boolean correctAnimation = false;
    private IAnimatedEntity entity;
    private HashMap<AdvancedModelBox, Transform> transformMap = new HashMap();
    private HashMap<AdvancedModelBox, Transform> prevTransformMap = new HashMap();

    public static ModelAnimator create() {
        return new ModelAnimator();
    }

    public IAnimatedEntity getEntity() {
        return this.entity;
    }

    public void update(IAnimatedEntity entity) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnimation = false;
        this.entity = entity;
        this.transformMap.clear();
        this.prevTransformMap.clear();
    }

    public boolean setAnimation(Animation animation) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnimation = this.entity.getAnimation() == animation;
        return this.correctAnimation;
    }

    public void startKeyframe(int duration) {
        if (!this.correctAnimation) {
            return;
        }
        this.prevTempTick = this.tempTick;
        this.tempTick += duration;
    }

    public void setStaticKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe(true);
    }

    public void resetKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe();
    }

    public void rotate(AdvancedModelBox box, float x, float y, float z) {
        if (!this.correctAnimation) {
            return;
        }
        this.getTransform(box).addRotation(x, y, z);
    }

    public void move(AdvancedModelBox box, float x, float y, float z) {
        if (!this.correctAnimation) {
            return;
        }
        this.getTransform(box).addOffset(x, y, z);
    }

    private Transform getTransform(AdvancedModelBox box) {
        return this.transformMap.computeIfAbsent(box, b -> new Transform());
    }

    public void endKeyframe() {
        this.endKeyframe(false);
    }

    private void endKeyframe(boolean stationary) {
        if (!this.correctAnimation) {
            return;
        }
        int animationTick = this.entity.getAnimationTick();
        if (animationTick >= this.prevTempTick && animationTick < this.tempTick) {
            if (stationary) {
                for (AdvancedModelBox box : this.prevTransformMap.keySet()) {
                    Transform transform = this.prevTransformMap.get((Object)box);
                    box.field_78795_f += transform.getRotationX();
                    box.field_78796_g += transform.getRotationY();
                    box.field_78808_h += transform.getRotationZ();
                    box.field_78800_c += transform.getOffsetX();
                    box.field_78797_d += transform.getOffsetY();
                    box.field_78798_e += transform.getOffsetZ();
                }
            } else {
                Transform transform;
                float tick = ((float)(animationTick - this.prevTempTick) + Minecraft.func_71410_x().func_184121_ak()) / (float)(this.tempTick - this.prevTempTick);
                float inc = MathHelper.func_76126_a((float)((float)((double)tick * Math.PI / 2.0)));
                float dec = 1.0f - inc;
                for (AdvancedModelBox box : this.prevTransformMap.keySet()) {
                    transform = this.prevTransformMap.get((Object)box);
                    box.field_78795_f += dec * transform.getRotationX();
                    box.field_78796_g += dec * transform.getRotationY();
                    box.field_78808_h += dec * transform.getRotationZ();
                    box.field_78800_c += dec * transform.getOffsetX();
                    box.field_78797_d += dec * transform.getOffsetY();
                    box.field_78798_e += dec * transform.getOffsetZ();
                }
                for (AdvancedModelBox box : this.transformMap.keySet()) {
                    transform = this.transformMap.get((Object)box);
                    box.field_78795_f += inc * transform.getRotationX();
                    box.field_78796_g += inc * transform.getRotationY();
                    box.field_78808_h += inc * transform.getRotationZ();
                    box.field_78800_c += inc * transform.getOffsetX();
                    box.field_78797_d += inc * transform.getOffsetY();
                    box.field_78798_e += inc * transform.getOffsetZ();
                }
            }
        }
        if (!stationary) {
            this.prevTransformMap.clear();
            this.prevTransformMap.putAll(this.transformMap);
            this.transformMap.clear();
        }
    }
}

