/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.util.pars;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.skds.core.api.IBlockExtended;
import net.skds.core.util.CustomBlockPars;
import net.skds.wpo.WPO;
import net.skds.wpo.util.pars.FluidPars;
import net.skds.wpo.util.pars.JsonConfigReader;

public class ParsApplier {
    public static void applyFluidPars(ParsGroup<FluidPars> FG) {
        for (Block b : FG.blocks) {
            CustomBlockPars pars = ((IBlockExtended)b).getCustomBlockPars();
            pars.put(FluidPars.class, FG.param);
        }
    }

    public static void refresh() {
        JsonConfigReader reader = new JsonConfigReader();
        reader.run();
        long t0 = System.currentTimeMillis();
        WPO.LOGGER.info("Cleaning blocks...");
        ForgeRegistries.BLOCKS.getValues().forEach(block -> ((IBlockExtended)block).setCustomBlockPars(new CustomBlockPars()));
        WPO.LOGGER.info("Reading fluid configs...");
        reader.FP.forEach((name, pars) -> ParsApplier.applyFluidPars(pars));
        WPO.LOGGER.info("Configs reloaded in " + (System.currentTimeMillis() - t0) + "ms");
    }

    public static class ParsGroup<A> {
        public final Set<Block> blocks;
        public final A param;

        ParsGroup(A p, Set<Block> blockList) {
            this.param = p;
            this.blocks = blockList;
        }
    }
}

