/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.util.pars;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.skds.wpo.WPO;
import net.skds.wpo.util.pars.FluidPars;
import net.skds.wpo.util.pars.ParsApplier;

public class JsonConfigReader {
    File fileF;
    File dir = new File(System.getProperty("user.dir") + "\\config\\" + "wpo");
    Set<Map.Entry<String, JsonElement>> blockListSet = new HashSet<Map.Entry<String, JsonElement>>();
    Set<Map.Entry<String, JsonElement>> propertyListSet = new HashSet<Map.Entry<String, JsonElement>>();
    Map<String, JsonElement> propertyListMap = new HashMap<String, JsonElement>();
    public Map<String, ParsApplier.ParsGroup<FluidPars>> FP = new HashMap<String, ParsApplier.ParsGroup<FluidPars>>();
    Gson GSON = new Gson();
    boolean created = false;

    public void run() {
        this.dir.mkdir();
        try {
            this.fileF = new File(this.dir, "fluid-config.json");
            boolean exsists = this.fileF.exists();
            if (!exsists) {
                this.create(false);
            }
            if (!this.readFluid(this.fileF) && !this.created) {
                this.create(true);
                this.readFluid(this.fileF);
            }
        }
        catch (IOException e) {
            WPO.LOGGER.error("Error while reading config: ", (Throwable)e);
        }
    }

    private void create(boolean existError) throws IOException {
        this.created = true;
        boolean copydeleted = true;
        File copyFile = new File(this.dir, "fluid-config-backup.json");
        if (existError && this.fileF.exists()) {
            WPO.LOGGER.warn("Fluid config resers to default");
            if (copyFile.exists()) {
                copydeleted = copyFile.delete();
            }
            if (copydeleted) {
                Files.copy(this.fileF.toPath(), copyFile.toPath(), new CopyOption[0]);
                WPO.LOGGER.warn("Fluid config backup created");
            }
        }
        BufferedInputStream is = new BufferedInputStream(WPO.class.getClassLoader().getResourceAsStream("wpo\\special\\fluids.json"));
        boolean ex = this.fileF.exists();
        if (ex) {
            this.fileF.delete();
        }
        Files.copy(is, this.fileF.toPath(), new CopyOption[0]);
        is.close();
    }

    private boolean readFluid(File fileF) throws IOException {
        JsonObject jsonobject = new JsonObject();
        FileInputStream inputStream = new FileInputStream(fileF);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        JsonReader jsonReader = new JsonReader((Reader)r);
        try {
            jsonobject = (JsonObject)this.GSON.getAdapter(JsonObject.class).read(jsonReader);
        }
        catch (IOException e) {
            WPO.LOGGER.error("Empty or invalid fluid config file!");
            ((InputStream)inputStream).close();
            this.create(true);
            inputStream = new FileInputStream(fileF);
            r = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            jsonReader = new JsonReader((Reader)r);
            jsonobject = (JsonObject)this.GSON.getAdapter(JsonObject.class).read(jsonReader);
        }
        ((Reader)r).close();
        jsonReader.close();
        JsonElement bls = jsonobject.get("BlockLists");
        JsonElement pls = jsonobject.get("PropertyLists");
        if (bls == null || pls == null) {
            WPO.LOGGER.error("Invalid fluid config file!");
            return false;
        }
        this.blockListSet = bls.getAsJsonObject().entrySet();
        this.propertyListSet = pls.getAsJsonObject().entrySet();
        if (this.blockListSet.size() == 0) {
            WPO.LOGGER.error("Empty block list file!");
            return false;
        }
        this.propertyListSet.forEach(entry -> this.propertyListMap.put((String)entry.getKey(), (JsonElement)entry.getValue()));
        for (Map.Entry<String, JsonElement> entry2 : this.blockListSet) {
            JsonElement properties;
            ArrayList blockIDs = new ArrayList();
            String key = entry2.getKey();
            JsonElement listElement = entry2.getValue();
            if (!listElement.isJsonArray()) {
                WPO.LOGGER.error("Block list \"" + key + "\" is not a list!");
                return false;
            }
            JsonArray blocklist = listElement.getAsJsonArray();
            if (blocklist.size() == 0) {
                WPO.LOGGER.warn("Block list \"" + key + "\" is empty!");
            }
            if ((properties = this.propertyListMap.get(key)) == null) {
                WPO.LOGGER.error("Block list \"" + key + "\" have no properties!");
                return false;
            }
            blocklist.forEach(element -> blockIDs.add(element.getAsString()));
            this.addFluidParsGroup(key, blocklist, FluidPars.readFromJson(properties, key));
        }
        return true;
    }

    private void addFluidParsGroup(String key, JsonArray blockNames, FluidPars pars) {
        if (pars == null) {
            return;
        }
        Set<Block> blocks = JsonConfigReader.getBlocksFromJA(blockNames);
        ParsApplier.ParsGroup<FluidPars> group = new ParsApplier.ParsGroup<FluidPars>(pars, blocks);
        this.FP.put(key, group);
    }

    public static Set<Block> getBlocksFromString(Set<String> list) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (String id : list) {
            if (id.charAt(0) == '#') {
                id = id.substring(1);
                ITag tag = BlockTags.func_199896_a().func_199910_a(new ResourceLocation(id));
                if (tag == null) {
                    WPO.LOGGER.error("Block tag \"" + id + "\" does not exist!");
                    continue;
                }
                blocks.addAll(tag.func_230236_b_());
                continue;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
            if (block != null && block != Blocks.field_150350_a) {
                blocks.add(block);
                continue;
            }
            WPO.LOGGER.error("Block \"" + id + "\" does not exist!");
        }
        return blocks;
    }

    public static Set<Block> getBlocksFromJA(JsonArray arr) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (JsonElement je : arr) {
            String id = je.getAsString();
            if (id.charAt(0) == '#') {
                id = id.substring(1);
                ITag tag = BlockTags.func_199896_a().func_199910_a(new ResourceLocation(id));
                if (tag == null) {
                    WPO.LOGGER.error("Block tag \"" + id + "\" does not exist!");
                    continue;
                }
                blocks.addAll(tag.func_230236_b_());
                continue;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
            if (block != null && block != Blocks.field_150350_a) {
                blocks.add(block);
                continue;
            }
            WPO.LOGGER.error("Block \"" + id + "\" does not exist!");
        }
        return blocks;
    }
}

