/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.skds.wpo.fluidphysics.FFluidStatic;
import net.skds.wpo.registry.Entities;
import net.skds.wpo.registry.FBlocks;
import net.skds.wpo.tileentity.BasicTankEntity;
import net.skds.wpo.tileentity.PipeTileEntity;
import net.skds.wpo.util.api.IConnectionSides;

public class PumpTileEntity
extends BasicTankEntity
implements IConnectionSides {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public Direction facing = Direction.UP;
    public boolean powered = false;
    public int anim = 0;
    public int animSpeed = 10;
    private static final float WJUH = 0.1f;
    private static final float MAX_PRESSURE = 3.0f;
    private static final float ATM_PRESSURE = 1.0f;
    public float pressure = 1.0f;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    public int timer = 0;

    public PumpTileEntity() {
        super((TileEntityType)Entities.PUMP.get());
    }

    public PumpTileEntity(BlockState state) {
        super((TileEntityType)Entities.PUMP.get());
        this.facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
    }

    public void func_73660_a() {
        ++this.timer;
        if (this.pressure < 0.0f) {
            this.pressure = 0.0f;
        }
        this.func_145836_u();
        BlockState bs = this.func_195044_w();
        boolean bl = this.powered = bs.func_177230_c() == FBlocks.PUMP.get() && (Boolean)bs.func_177229_b((Property)POWERED) != false;
        if (this.powered) {
            if (this.pressure < 3.0f) {
                this.pressure += (3.0f - this.pressure) * 0.1f;
            }
            if (this.field_145850_b.field_72995_K) {
                if (this.anim < 0) {
                    this.anim = 0;
                }
                ++this.anim;
                if (this.anim > this.animSpeed) {
                    this.anim = 0;
                }
                return;
            }
            if (this.timer % 4 == 0) {
                this.tickPump(bs);
            }
        } else if (this.field_145850_b.field_72995_K) {
            if (this.anim > this.animSpeed / 2) {
                this.anim = this.animSpeed - this.anim;
            }
            if (this.anim > -1) {
                --this.anim;
            }
        }
    }

    private void tickPump(BlockState state) {
        if (this.pressure > 3.0f) {
            return;
        }
        FluidStack fst = this.tank.getFluid();
        int am = fst.getAmount();
        if (am > 375) {
            return;
        }
        Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos suckPos = this.field_174879_c.func_177972_a(dir);
        FluidState suckFs = this.field_145850_b.func_204610_c(suckPos);
        BlockState suckState = this.field_145850_b.func_180495_p(suckPos);
        Fluid sucF = suckFs.func_206886_c();
        if (sucF instanceof FlowingFluid) {
            sucF = ((FlowingFluid)sucF).func_210198_f();
        }
        Fluid tF = fst.getFluid();
        if (suckFs.func_206888_e() || !this.tank.isEmpty() && !tF.func_207187_a(sucF) || FFluidStatic.canOnlyFullCube(suckState)) {
            return;
        }
        if (FFluidStatic.canReach(suckPos, this.field_174879_c, suckState, Blocks.field_150350_a.func_176223_P(), sucF, (IBlockReader)this.field_145850_b)) {
            int dl = (500 - am) / 125;
            int lvl = suckFs.func_206882_g();
            dl = lvl >= dl ? dl : lvl;
            BlockState bs2 = FFluidStatic.getUpdatedState(suckState, lvl -= dl, sucF);
            FluidStack nfst = new FluidStack(sucF, am + dl * 125);
            this.tank.setFluid(nfst);
            this.field_145850_b.func_175656_a(suckPos, bs2);
        }
    }

    @Override
    public boolean canBeConnected(Direction dir) {
        return dir == this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
    }

    @Override
    public boolean canBeConnected(int dir) {
        Direction d = Direction.func_82600_a((int)dir);
        return d == this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tank.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public float getZeroPressure(Direction side) {
        return this.pressure;
    }

    @Override
    public float getPressure(Direction side) {
        return this.pressure + PipeTileEntity.getPressurePerStack(this.tank.getFluid()) * 2.0f;
    }

    @Override
    public void setPressure(float pressure, Direction side) {
        this.pressure = pressure;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.tank.readFromNBT(tag);
        this.pressure = tag.func_74764_b("Pressure") ? tag.func_74760_g("Pressure") : 1.0f;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        tag.func_74776_a("Pressure", this.pressure);
        return tag;
    }
}

