/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.tileentity;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.skds.wpo.fluidphysics.FFluidStatic;
import net.skds.wpo.network.PacketHandler;
import net.skds.wpo.network.PipeUpdatePacket;
import net.skds.wpo.registry.Entities;
import net.skds.wpo.tileentity.BasicTankEntity;
import net.skds.wpo.util.api.IConnectionSides;
import net.skds.wpo.util.api.IPressuredTank;

public class PipeTileEntity
extends BasicTankEntity {
    private static final float G = 9.81f;
    private static final float ATM_PRESSURE = 1.0f;
    private static final double PIX = 0.0625;
    public static final AxisAlignedBB MID_AABB = new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125);
    public static final VoxelShape MID_SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)MID_AABB);
    public float[] flow = new float[6];
    public TileEntity[] connections = new TileEntity[6];
    public boolean[] boolConnections = new boolean[6];
    public float pressure = 1.0f;
    private boolean firstTick = true;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public PipeTileEntity() {
        super((TileEntityType)Entities.PIPE.get());
    }

    public void onLoad() {
        super.onLoad();
    }

    public void func_73660_a() {
        if (this.pressure < 0.0f) {
            this.pressure = 0.0f;
        }
        if (this.firstTick) {
            this.updateConntections();
            this.firstTick = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.tickFluid();
        }
    }

    private void tickConnection(TileEntity connected, Direction direction) {
        IFluidHandler fh2 = PipeTileEntity.getFluidHandler(connected, direction);
        if (fh2 != null) {
            FluidTank toDrainH;
            IFluidHandler toFillH;
            float pp;
            int i = direction.func_176745_a();
            FluidStack fst1 = this.tank.getFluid();
            FluidStack fst2 = fh2.getFluidInTank(0);
            if (fst1.isEmpty() && fst2.isEmpty()) {
                float pz2;
                float pz1 = this.getZeroPressure(null);
                float dp2 = (pz1 - (pz2 = PipeTileEntity.getZeroPressureInHandler(connected, direction.func_176734_d()))) * 0.6f;
                if (Math.abs(dp2) > 1.0E-5f) {
                    this.setPressure(pz1 -= dp2, null);
                    PipeTileEntity.setPressure(connected, pz2 += dp2, direction.func_176734_d());
                }
                return;
            }
            if (!(fst1.isEmpty() || fst2.isEmpty() || fst1.isFluidEqual(fst2))) {
                return;
            }
            if (!fh2.isFluidValid(0, fst1) || !this.tank.isFluidValid(0, fst2)) {
                return;
            }
            Fluid f = fst1.isEmpty() ? fst2.getFluid() : fst1.getFluid();
            FluidAttributes fa = f.getAttributes();
            float p1 = this.getPressure(null);
            float p2 = PipeTileEntity.getPressureInHandler(connected, direction.func_176734_d());
            boolean b = true;
            boolean b2 = false;
            float dp0 = 0.0f;
            float dp = PipeTileEntity.getPressurePerH(f, 1000);
            float z = PipeTileEntity.getZeroPressureInHandler(connected, direction.func_176734_d());
            float z0 = this.getZeroPressure(null);
            if (direction == Direction.UP) {
                pp = PipeTileEntity.getPressurePerStack(fst2) * 2.0f;
                dp0 = -pp;
                b2 = true;
                if (z0 > p2) {
                    p1 -= dp;
                } else {
                    p2 += dp;
                }
            } else if (direction == Direction.DOWN) {
                dp0 = pp = PipeTileEntity.getPressurePerStack(fst1) * 2.0f;
                b2 = true;
                p1 = z > p1 ? (p1 += dp) : (p1 += dp);
            }
            if (b) {
                float pz1 = this.getZeroPressure(null);
                float pz2 = PipeTileEntity.getZeroPressureInHandler(connected, direction.func_176734_d());
                float dp2 = (pz1 + dp0 - pz2) / 2.0f;
                if (b2) {
                    // empty if block
                }
                if (Math.abs(dp2) > 1.0E-5f) {
                    this.setPressure(pz1 -= dp2, null);
                    PipeTileEntity.setPressure(connected, pz2 += dp2, direction.func_176734_d());
                }
            }
            float c = 400000.0f;
            float df = (p1 - p2) * c / (float)fa.getDensity();
            int n = i;
            this.flow[n] = this.flow[n] + df;
            int maxFlow = Math.round(this.flow[i]);
            int am1 = fst1.getAmount();
            int am2 = fst2.getAmount();
            if (maxFlow == 0) {
                if (am1 > 0 && am1 < 3 && am1 != am2) {
                    maxFlow = this.flow[i] > 0.0f ? 1 : -1;
                } else {
                    return;
                }
            }
            if (maxFlow > 0) {
                toFillH = fh2;
                toDrainH = this.tank;
            } else {
                toFillH = this.tank;
                toDrainH = fh2;
            }
            FluidStack toFill = toFillH.getFluidInTank(0);
            FluidStack toDrain = toDrainH.getFluidInTank(0);
            maxFlow = Math.abs(maxFlow);
            int amd = toDrain.getAmount();
            int amf = toFill.getAmount();
            maxFlow = Math.min(maxFlow, amd);
            maxFlow = Math.min(maxFlow, toFillH.getTankCapacity(0) - amf);
            FluidStack cfs = toDrainH.drain(maxFlow, IFluidHandler.FluidAction.EXECUTE);
            toFillH.fill(cfs, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void tickFluid() {
        for (Direction dir : FFluidStatic.getAllRandomizedDirections(this.field_145850_b.field_73012_v)) {
            int i = dir.func_176745_a();
            if (this.connections[i] != null) {
                this.tickConnection(this.connections[i], dir);
            }
            int n = i;
            this.flow[n] = this.flow[n] * 0.8f;
            if (!(this.flow[i] < 0.01f)) continue;
            this.flow[i] = 0.0f;
        }
    }

    private static void setPressure(TileEntity te, float pressure, Direction side) {
        if (te instanceof IPressuredTank) {
            ((IPressuredTank)te).setPressure(pressure, side);
        }
    }

    private static IFluidHandler getFluidHandler(TileEntity tile, Direction dir) {
        Optional op;
        if (tile != null && (op = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d()).resolve()).isPresent()) {
            return (IFluidHandler)op.get();
        }
        return null;
    }

    private static float getZeroPressureInHandler(TileEntity tile, Direction side) {
        if (tile != null && tile instanceof IPressuredTank) {
            return ((IPressuredTank)tile).getZeroPressure(side);
        }
        return 1.0f;
    }

    private static float getPressureInHandler(TileEntity tile, Direction side) {
        if (tile != null && tile instanceof IPressuredTank) {
            return ((IPressuredTank)tile).getPressure(side);
        }
        return 1.0f;
    }

    public void updateBoolConnections() {
        boolean[] bl = new boolean[6];
        int i = 0;
        for (TileEntity fth : this.connections) {
            bl[i] = fth != null;
            ++i;
        }
        this.boolConnections = bl;
    }

    public void updateConntections() {
        for (Direction dir : Direction.values()) {
            BlockPos pos2 = this.field_174879_c.func_177972_a(dir);
            BlockState state2 = this.field_145850_b.func_180495_p(pos2);
            if (state2.hasTileEntity()) {
                TileEntity te = this.field_145850_b.func_175625_s(pos2);
                if (te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).resolve().isPresent()) {
                    if (te instanceof IConnectionSides && !((IConnectionSides)te).canBeConnected(dir)) {
                        this.removeConnection(dir);
                        return;
                    }
                    this.addConnection(te, dir);
                    if (!(te instanceof PipeTileEntity)) continue;
                    ((PipeTileEntity)te).addConnection(this, dir.func_176734_d());
                    continue;
                }
                this.removeConnection(dir);
                continue;
            }
            this.removeConnection(dir);
        }
    }

    public void addConnection(TileEntity handler, Direction direction) {
        this.connections[direction.func_176745_a()] = handler;
        this.updateBoolConnections();
    }

    public void removeConnection(Direction direction) {
        this.connections[direction.func_176745_a()] = null;
        this.updateBoolConnections();
    }

    public VoxelShape getShape() {
        VoxelShape shape = MID_SHAPE;
        for (int i = 0; i < 6; ++i) {
            if (this.connections[i] == null) continue;
            Vector3i dirvec = Direction.func_82600_a((int)i).func_176730_m();
            Vector3d vec = new Vector3d((double)dirvec.func_177958_n(), (double)dirvec.func_177956_o(), (double)dirvec.func_177952_p()).func_186678_a(0.1875);
            VoxelShape shape2 = VoxelShapes.func_197881_a((AxisAlignedBB)MID_AABB.func_191194_a(vec));
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)shape2, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return shape.func_197753_c();
    }

    public static float getPressurePerStack(FluidStack stack) {
        if (stack.isEmpty()) {
            return 0.0f;
        }
        return (float)(stack.getAmount() * stack.getFluid().getFluid().getAttributes().getDensity()) * 1.0E-8f * 9.81f;
    }

    public static float getPressurePerH(Fluid fluid, int mb) {
        return (float)(mb * fluid.getFluid().getAttributes().getDensity()) * 1.0E-8f * 9.81f;
    }

    @Override
    public float getPressure(Direction side) {
        return this.pressure + PipeTileEntity.getPressurePerStack(this.tank.getFluid()) * 2.0f;
    }

    @Override
    public float getZeroPressure(Direction side) {
        return this.pressure;
    }

    @Override
    public void setPressure(float pressure, Direction side) {
        this.pressure = pressure;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.tank.readFromNBT(tag);
        this.pressure = tag.func_74764_b("Pressure") ? tag.func_74760_g("Pressure") : 1.0f;
        ListNBT flowListNBT = tag.func_150295_c("Flow", 5);
        for (int i = 0; i < 6; ++i) {
            this.flow[i] = flowListNBT.func_150308_e(i);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        tag.func_74776_a("Pressure", this.pressure);
        ListNBT flowListNBT = new ListNBT();
        for (float f : this.flow) {
            flowListNBT.add((Object)FloatNBT.func_229689_a_((float)f));
        }
        tag.func_218657_a("Flow", (INBT)flowListNBT);
        return tag;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tank.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    private void sendUpdatePacket() {
        for (PlayerEntity p : this.field_145850_b.func_217369_A()) {
            PacketHandler.send(p, new PipeUpdatePacket(this.func_189515_b(new CompoundNBT())));
        }
    }
}

