/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.skds.wpo.registry.Entities;
import net.skds.wpo.registry.FBlocks;
import net.skds.wpo.tileentity.BasicTankEntity;
import net.skds.wpo.tileentity.PipeTileEntity;
import net.skds.wpo.util.api.IConnectionSides;

public class PipePumpTileEntity
extends BasicTankEntity
implements IConnectionSides {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public Direction facing = Direction.UP;
    public boolean powered = false;
    public int anim = 0;
    public int animSpeed = 10;
    private static final float WJUH = 0.1f;
    private static final float MAX_PRESSURE = 3.0f;
    public float pressureIn = 1.0f;
    public float pressureOut = 1.0f;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public PipePumpTileEntity() {
        super((TileEntityType)Entities.PIPE_PUMP.get());
    }

    public PipePumpTileEntity(BlockState state) {
        super((TileEntityType)Entities.PIPE_PUMP.get());
        this.facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
    }

    public void func_73660_a() {
        if (this.pressureIn < 0.0f) {
            this.pressureIn = 0.0f;
        }
        if (this.pressureOut < 0.0f) {
            this.pressureOut = 0.0f;
        }
        if (this.pressureIn > this.pressureOut) {
            this.pressureOut = this.pressureIn;
        }
        this.func_145836_u();
        BlockState bs = this.func_195044_w();
        if (bs.func_177230_c() == FBlocks.PIPE_PUMP.get()) {
            this.powered = (Boolean)bs.func_177229_b((Property)POWERED);
            if (this.powered) {
                if (this.pressureOut < 3.0f && this.pressureIn > 0.0f) {
                    this.pressureOut += (3.0f - this.pressureOut) * 0.1f;
                    this.pressureIn -= this.pressureIn * 0.1f;
                }
                if (this.field_145850_b.field_72995_K) {
                    if (this.anim < 0) {
                        this.anim = 0;
                    }
                    ++this.anim;
                    if (this.anim > this.animSpeed) {
                        this.anim = 0;
                    }
                }
            } else {
                if (this.field_145850_b.field_72995_K) {
                    if (this.anim > this.animSpeed / 2) {
                        this.anim = this.animSpeed - this.anim;
                    }
                    if (this.anim > -1) {
                        --this.anim;
                    }
                }
                float dp = (this.pressureIn - this.pressureOut) / 2.0f;
                this.pressureOut += dp;
                this.pressureIn -= dp;
            }
        }
    }

    @Override
    public boolean canBeConnected(Direction dir) {
        return dir == this.facing || dir == this.facing.func_176734_d();
    }

    @Override
    public boolean canBeConnected(int dir) {
        Direction d = Direction.func_82600_a((int)dir);
        return this.canBeConnected(d);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tank.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public float getZeroPressure(Direction side) {
        if (side == this.facing) {
            return this.pressureOut;
        }
        return this.pressureIn;
    }

    @Override
    public float getPressure(Direction side) {
        return side == this.facing ? this.pressureOut + PipeTileEntity.getPressurePerStack(this.tank.getFluid()) * 2.0f : this.pressureIn;
    }

    @Override
    public void setPressure(float pressure, Direction side) {
        if (side == this.facing) {
            this.pressureOut = pressure;
        } else {
            this.pressureIn = pressure;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.tank.readFromNBT(tag);
        this.pressureIn = tag.func_74764_b("PressureIn") ? tag.func_74760_g("PressureIn") : 1.0f;
        this.pressureOut = tag.func_74764_b("PressureOut") ? tag.func_74760_g("PressureOut") : 1.0f;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        tag.func_74776_a("PressureIn", this.pressureIn);
        tag.func_74776_a("PressureOut", this.pressureOut);
        return tag;
    }
}

