/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.skds.wpo.fluidphysics.FFluidStatic;
import net.skds.wpo.registry.Entities;
import net.skds.wpo.registry.FBlocks;
import net.skds.wpo.tileentity.BasicTankEntity;
import net.skds.wpo.tileentity.PipeTileEntity;
import net.skds.wpo.util.api.IConnectionSides;

public class FluidGateTileEntity
extends BasicTankEntity
implements IConnectionSides {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public float pressure = 1.0f;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private boolean atm = true;
    private int timer = 0;

    public FluidGateTileEntity() {
        super((TileEntityType)Entities.GATE.get());
    }

    private Direction[] getDirections() {
        Direction[] dirs = new Direction[6];
        dirs = new Direction[6];
        dirs[0] = Direction.DOWN;
        dirs[5] = Direction.UP;
        for (int index = 0; index < 4; ++index) {
            Direction dir;
            dirs[index + 1] = dir = Direction.func_176731_b((int)index);
        }
        return dirs;
    }

    public void func_73660_a() {
        ++this.timer;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.pressure < 0.0f) {
            this.pressure = 0.0f;
        }
        if (this.atm) {
            this.pressure = 1.0f;
        }
        this.func_145836_u();
        BlockState bs = this.func_195044_w();
        if (bs.func_177230_c() == FBlocks.GATE.get() && !((Boolean)bs.func_177229_b((Property)POWERED)).booleanValue() && this.timer % 4 == 0) {
            this.tickGate(bs);
        }
    }

    private void tickGate(BlockState state) {
        if (this.pressure < 1.0f) {
            return;
        }
        FluidStack fst = this.tank.getFluid();
        int am = fst.getAmount();
        if (am < 125) {
            return;
        }
        for (Direction dir : this.getDirections()) {
            if (dir.func_176734_d() == state.func_177229_b((Property)BlockStateProperties.field_208155_H)) continue;
            BlockPos flowPos = this.field_174879_c.func_177972_a(dir);
            FluidState flowFs = this.field_145850_b.func_204610_c(flowPos);
            BlockState flowState = this.field_145850_b.func_180495_p(flowPos);
            Fluid flowF = flowFs.func_206886_c();
            Fluid tF = fst.getFluid();
            if (!flowFs.func_206888_e() && !tF.func_207187_a(flowF) || FFluidStatic.canOnlyFullCube(flowState)) {
                return;
            }
            if (!FFluidStatic.canReach(this.field_174879_c, flowPos, Blocks.field_150350_a.func_176223_P(), flowState, tF, (IBlockReader)this.field_145850_b)) continue;
            int dl = am / 125;
            int lvl = flowFs.func_206882_g();
            int n = dl = 8 - lvl >= dl ? dl : 8 - lvl;
            if (dl <= 0) continue;
            BlockState bs2 = FFluidStatic.getUpdatedState(flowState, lvl += dl, tF);
            FluidStack nfst = new FluidStack(tF, am - dl * 125);
            this.tank.setFluid(nfst);
            this.field_145850_b.func_175656_a(flowPos, bs2);
            this.atm = true;
            break;
        }
    }

    @Override
    public boolean canBeConnected(Direction dir) {
        return dir == this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
    }

    @Override
    public boolean canBeConnected(int dir) {
        Direction d = Direction.func_82600_a((int)dir);
        return d == this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tank.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public float getZeroPressure(Direction side) {
        return this.pressure;
    }

    @Override
    public float getPressure(Direction side) {
        return this.pressure + PipeTileEntity.getPressurePerStack(this.tank.getFluid()) * 2.0f;
    }

    @Override
    public void setPressure(float pressure, Direction side) {
        this.pressure = pressure;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.tank.readFromNBT(tag);
        this.pressure = tag.func_74764_b("Pressure") ? tag.func_74760_g("Pressure") : 1.0f;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.tank.writeToNBT(tag);
        tag.func_74776_a("Pressure", this.pressure);
        return tag;
    }
}

