/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.mixins.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.skds.wpo.fluidphysics.FFluidStatic;
import net.skds.wpo.registry.BlockStateProps;
import net.skds.wpo.util.interfaces.IBaseWL;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractBlock.AbstractBlockState.class})
public abstract class AbstractBlockStateMixin {
    @Inject(method={"getFluidState"}, at={@At(value="HEAD")}, cancellable=true)
    public void getFluidStateM(CallbackInfoReturnable<FluidState> ci) {
        BlockState bs = (BlockState)this;
        if (bs.func_177230_c() instanceof IBaseWL) {
            FluidState fs;
            int level = (Integer)bs.func_177229_b((Property)BlockStateProps.FFLUID_LEVEL);
            if (((Boolean)bs.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                int n = level = level == 0 ? 8 : level;
                fs = level >= 8 ? Fluids.field_204546_a.func_207204_a(false) : (level <= 0 ? Fluids.field_204541_a.func_207188_f() : Fluids.field_204546_a.func_207207_a(level, false));
            } else {
                fs = Fluids.field_204541_a.func_207188_f();
            }
            ci.setReturnValue((Object)fs);
        }
    }

    @Inject(method={"ticksRandomly"}, at={@At(value="HEAD")}, cancellable=true)
    public void ticksRandomlyM(CallbackInfoReturnable<Boolean> ci) {
    }

    @Inject(method={"neighborChanged"}, at={@At(value="HEAD")}, cancellable=false)
    public void neighborChangedM(World worldIn, BlockPos posIn, Block blockIn, BlockPos fromPosIn, boolean isMoving, CallbackInfo ci) {
        if (((BlockState)this).func_177230_c() instanceof IBaseWL) {
            BlockState s = (BlockState)this;
            this.fixFFLNoWL((IWorld)worldIn, s, posIn);
            if (((Boolean)s.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                worldIn.func_205219_F_().func_205360_a(posIn, (Object)s.func_204520_s().func_206886_c(), FFluidStatic.getTickRate((FlowingFluid)s.func_204520_s().func_206886_c(), (IWorldReader)worldIn));
            }
        }
    }

    @Inject(method={"updatePostPlacement"}, at={@At(value="HEAD")}, cancellable=false)
    public void updatePostPlacementM(Direction face, BlockState queried, IWorld worldIn, BlockPos currentPos, BlockPos offsetPos, CallbackInfoReturnable<BlockState> ci) {
        if (((BlockState)this).func_177230_c() instanceof IBaseWL) {
            BlockState s = (BlockState)this;
            this.fixFFLNoWL(worldIn, s, currentPos);
            if (((Boolean)s.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                worldIn.func_205219_F_().func_205360_a(currentPos, (Object)s.func_204520_s().func_206886_c(), FFluidStatic.getTickRate((FlowingFluid)s.func_204520_s().func_206886_c(), (IWorldReader)worldIn));
            }
        }
    }

    private void fixFFLNoWL(IWorld w, BlockState s, BlockPos p) {
        if (!((Boolean)s.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && (Integer)s.func_177229_b((Property)BlockStateProps.FFLUID_LEVEL) > 0) {
            w.func_180501_a(p, (BlockState)s.func_206870_a((Property)BlockStateProps.FFLUID_LEVEL, (Comparable)Integer.valueOf(0)), 3);
        }
    }
}

