/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.skds.wpo.client.models.ISTER;
import net.skds.wpo.util.ExtendedFHIS;

public class AdvancedBucket
extends BucketItem
implements ICapabilityProvider {
    private ExtendedFHIS fhis;

    public AdvancedBucket(Fluid fluid, Item.Properties builder) {
        super(() -> fluid, builder);
    }

    public static AdvancedBucket getBucketForReg(Fluid fluid) {
        Item.Properties prop = new Item.Properties().func_200917_a(fluid == Fluids.field_204541_a ? 16 : 1).func_200915_b(8).setNoRepair().setISTER(() -> ISTER.call());
        return new AdvancedBucket(fluid, prop);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ExtendedFHIS fh = new ExtendedFHIS(stack, 1000);
        FluidStack fst = fh.getFluid();
        Fluid f = fst.getFluid();
        TextFormatting form = TextFormatting.DARK_PURPLE;
        IFormattableTextComponent texComp = new TranslationTextComponent(f.getAttributes().getTranslationKey()).func_240699_a_(form);
        tooltip.add((ITextComponent)texComp);
        texComp = new StringTextComponent(fst.getAmount() + " mb");
        tooltip.add((ITextComponent)texComp);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        this.fhis = new ExtendedFHIS(stack, 1000);
        return this.fhis;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return this.fhis.getCapability(cap);
    }

    public static void updateDamage(ItemStack stack) {
        ExtendedFHIS fst = new ExtendedFHIS(stack, 1000);
        int sl = fst.getFluid().getAmount() / 125;
        stack.func_196085_b(8 - sl);
    }
}

