/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.fluidphysics;

import io.netty.util.internal.ConcurrentSet;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;
import net.skds.core.Events;
import net.skds.core.api.IWWS;
import net.skds.core.api.IWWSG;
import net.skds.core.api.multithreading.ITaskRunnable;
import net.skds.core.multithreading.MTHooks;
import net.skds.wpo.fluidphysics.FluidTask;
import net.skds.wpo.util.TaskBlocker;

public class WorldWorkSet
implements IWWS {
    public final IWWSG glob;
    public final ServerWorld world;
    public ConcurrentSet<Long> excludedTasks = new ConcurrentSet();
    private ConcurrentSet<Long> lockedEq = new ConcurrentSet();
    private ConcurrentHashMap<Long, Integer> ntt = new ConcurrentHashMap();
    private static final Comparator<FluidTask> comp = new Comparator<FluidTask>(){

        @Override
        public int compare(FluidTask k1, FluidTask k2) {
            if (k1.pos == k2.pos && k1.owner == k2.owner) {
                return 0;
            }
            double dcomp = k1.getPriority() - k2.getPriority();
            int comp = (int)dcomp;
            if (comp == 0) {
                comp = dcomp > 0.0 ? 1 : -1;
            }
            return comp;
        }
    };
    private static ConcurrentSkipListSet<FluidTask> TASKS = new ConcurrentSkipListSet<FluidTask>(comp);
    private static ConcurrentLinkedQueue<FluidTask> DELAYED_TASKS = new ConcurrentLinkedQueue();

    public WorldWorkSet(ServerWorld w, IWWSG owner) {
        this.world = w;
        this.glob = owner;
    }

    public void addNTTask(long l, int t) {
        this.ntt.put(l, t);
    }

    public void clearEqLock(long l) {
        this.lockedEq.remove((Object)l);
    }

    public void addEQTask(long l, FlowingFluid fluid) {
        FluidTask.EQTask task = new FluidTask.EQTask(this, l);
        TASKS.add(task);
    }

    public void addEqLock(long l) {
        this.lockedEq.add((Object)l);
    }

    public boolean isEqLocked(long l) {
        return this.lockedEq.contains((Object)l);
    }

    private void tickNTT(long pos, int t) {
        if (--t <= 0) {
            FluidTask.DefaultTask task = new FluidTask.DefaultTask(this, pos);
            TASKS.add(task);
            this.ntt.remove(pos);
            this.clearEqLock(pos);
        } else {
            this.ntt.put(pos, t);
        }
    }

    public static ITaskRunnable nextTask(int i) {
        if (i > 3) {
            return null;
        }
        if (MTHooks.COUNTS > 0 || Events.getRemainingTickTimeMilis() > MTHooks.TIME) {
            FluidTask task;
            --MTHooks.COUNTS;
            for (FluidTask t : DELAYED_TASKS) {
                if (!TaskBlocker.test(i, t)) continue;
                DELAYED_TASKS.remove(t);
                t.worker = i;
                return t;
            }
            boolean tested = false;
            while ((task = TASKS.pollFirst()) != null && !tested) {
                tested = TaskBlocker.test(i, task);
                if (tested) {
                    task.worker = i;
                    return task;
                }
                if (task == null) continue;
                DELAYED_TASKS.add(task);
            }
        }
        return null;
    }

    public static void pushTask(FluidTask task) {
        TASKS.add(task);
    }

    public void tickIn() {
        this.excludedTasks.clear();
        this.ntt.forEach(this::tickNTT);
    }

    public void tickOut() {
    }

    public void close() {
        this.lockedEq.clear();
        ServerTickList stl = this.world.func_205219_F_();
        this.ntt.forEach((lp, t) -> {
            BlockPos pos = BlockPos.func_218283_e((long)lp);
            stl.func_205360_a(pos, (Object)this.world.func_204610_c(pos).func_206886_c(), t + 2);
        });
        this.ntt.clear();
        TASKS.forEach(t -> t.revoke((World)this.world));
        TASKS.clear();
        DELAYED_TASKS.forEach(t -> t.revoke((World)this.world));
        DELAYED_TASKS.clear();
    }

    public IWWSG getG() {
        return this.glob;
    }
}

