/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.fluidphysics;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.block.SpongeBlock;
import net.minecraft.block.WetSpongeBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.skds.core.api.IBlockExtended;
import net.skds.core.api.IWWSG;
import net.skds.core.api.IWorldExtended;
import net.skds.core.util.blockupdate.WWSGlobal;
import net.skds.wpo.WPOConfig;
import net.skds.wpo.fluidphysics.FluidTasksManager;
import net.skds.wpo.registry.BlockStateProps;
import net.skds.wpo.util.ExtendedFHIS;
import net.skds.wpo.util.interfaces.IBaseWL;
import net.skds.wpo.util.pars.FluidPars;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class FFluidStatic {
    public static final int FCONST = 125;

    public static Direction[] getRandomizedDirections(Random r, boolean addVertical) {
        Direction[] dirs = new Direction[4];
        if (addVertical) {
            dirs = new Direction[6];
            dirs[4] = Direction.DOWN;
            dirs[5] = Direction.UP;
        }
        int i0 = r.nextInt(4);
        for (int index = 0; index < 4; ++index) {
            Direction dir;
            dirs[index] = dir = Direction.func_176731_b((int)((index + i0) % 4));
        }
        return dirs;
    }

    public static Direction[] getAllRandomizedDirections(Random r) {
        Direction[] dirs = new Direction[6];
        int i0 = r.nextInt(6);
        for (int index = 0; index < 6; ++index) {
            Direction dir;
            dirs[index] = dir = Direction.func_82600_a((int)((index + i0) % 6));
        }
        return dirs;
    }

    public static BlockState getUpdatedState(BlockState state0, int newlevel, Fluid fluid) {
        if (newlevel < 0 || newlevel > 8) {
            throw new RuntimeException("Incorrect fluid level!!!");
        }
        if (FFluidStatic.canOnlyFullCube(state0) && fluid instanceof WaterFluid) {
            if (newlevel >= 1) {
                return (BlockState)state0.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)state0.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
        }
        if (state0.func_177230_c() instanceof IBaseWL && fluid instanceof WaterFluid) {
            if (newlevel >= 1) {
                return (BlockState)((BlockState)state0.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)BlockStateProps.FFLUID_LEVEL, (Comparable)Integer.valueOf(newlevel));
            }
            return (BlockState)((BlockState)state0.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProps.FFLUID_LEVEL, (Comparable)Integer.valueOf(newlevel));
        }
        FluidState fs2 = newlevel >= 8 ? ((FlowingFluid)fluid).func_207204_a(false) : (newlevel <= 0 ? Fluids.field_204541_a.func_207188_f() : ((FlowingFluid)fluid).func_207207_a(newlevel, false));
        return fs2.func_206883_i();
    }

    public static float getHeight(int level) {
        float h = (float)level / 8.0f * 0.9375f;
        switch (level) {
            case 3: {
                return h * 0.9f;
            }
            case 2: {
                return h * 0.75f;
            }
            case 1: {
                return h * 0.4f;
            }
        }
        return h;
    }

    public static PushReaction getPushReaction(BlockState state) {
        return PushReaction.PUSH_ONLY;
    }

    public static boolean isSameFluid(Fluid f1, Fluid f2) {
        if (f1 == Fluids.field_204541_a) {
            return false;
        }
        if (f2 == Fluids.field_204541_a) {
            return false;
        }
        return f1.func_207187_a(f2);
    }

    public static int getTickRate(FlowingFluid fluid, IWorldReader w) {
        int rate = fluid.func_205569_a(w);
        return (rate /= 2) > 0 ? rate : 1;
    }

    public static Direction dirFromVec(BlockPos pos, BlockPos pos2) {
        return Direction.func_176737_a((float)(pos2.func_177958_n() - pos.func_177958_n()), (float)(pos2.func_177956_o() - pos.func_177956_o()), (float)(pos2.func_177952_p() - pos.func_177952_p()));
    }

    public static Vector3d getVel2(IBlockReader w, BlockPos posV, FluidState state) {
        Vector3d vel = new Vector3d(0.0, 0.0, 0.0);
        int level = state.func_206882_g();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int delta;
            BlockPos pos2 = posV.func_177972_a(dir);
            BlockState st = w.func_180495_p(pos2);
            FluidState fluidState = st.func_204520_s();
            if (fluidState.func_206888_e() || !FFluidStatic.canReach(w, posV, dir.func_176734_d())) continue;
            int lvl0 = fluidState.func_206882_g();
            FluidState f2 = w.func_204610_c(pos2.func_177984_a());
            if (FFluidStatic.isSameFluid(state.func_206886_c(), f2.func_206886_c())) {
                lvl0 += f2.func_206882_g();
            }
            if ((delta = level - lvl0) <= 1 && delta >= -1) continue;
            Vector3i v3i = dir.func_176730_m();
            vel = vel.func_72441_c((double)(v3i.func_177958_n() * delta), 0.0, (double)(v3i.func_177952_p() * delta));
        }
        return vel.func_72432_b();
    }

    public static Vector3d getVel(IBlockReader w, BlockPos pos, FluidState fs) {
        Vector3d vel = new Vector3d(0.0, 0.0, 0.0);
        int level = fs.func_206882_g();
        BlockState state = fs.func_206883_i();
        Fluid fluid = fs.func_206886_c();
        BlockPos posu = pos.func_177984_a();
        boolean flag = false;
        BlockState stateu = w.func_180495_p(posu);
        if (FFluidStatic.canReach(pos, posu, state, stateu, fluid, w) && !stateu.func_204520_s().func_206888_e()) {
            level += stateu.func_204520_s().func_206882_g();
            flag = true;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int delta;
            FluidState fs2u;
            BlockPos pos2 = pos.func_177972_a(dir);
            BlockState state2 = w.func_180495_p(pos2);
            FluidState fs2 = state2.func_204520_s();
            if (fs2.func_206888_e() || !FFluidStatic.canReach(pos, pos2, state, state2, fluid, w)) continue;
            int lvl2 = fs2.func_206882_g();
            if (flag && FFluidStatic.isSameFluid(fluid, (fs2u = w.func_204610_c(pos2.func_177984_a())).func_206886_c())) {
                lvl2 += fs2u.func_206882_g();
            }
            if ((delta = level - lvl2) <= 1 && delta >= -1) continue;
            Vector3i v3i = dir.func_176730_m();
            vel = vel.func_72441_c((double)(v3i.func_177958_n() * delta), 0.0, (double)(v3i.func_177952_p() * delta));
        }
        return vel.func_72432_b();
    }

    public static float[] getConH(IBlockReader w, BlockPos pos, Fluid fluid) {
        int[] count = new int[]{1, 1, 1, 1};
        boolean[] conner = new boolean[4];
        boolean[] setconner = new boolean[4];
        float[] setconnervl = new float[4];
        boolean downsuc = false;
        float offset = 0.0036f;
        float offset2 = 0.99999f;
        BlockPos posd = null;
        BlockState stated = null;
        BlockState state = w.func_180495_p(pos);
        float level = state.func_204520_s().func_223408_f();
        float[] sum = new float[]{level, level, level, level};
        BlockPos posu = pos.func_177984_a();
        BlockState statu = w.func_180495_p(posu);
        FluidState ufs = w.func_204610_c(posu);
        boolean posus = FFluidStatic.canReach(pos, posu, state, statu, fluid, w);
        if (fluid.func_207187_a(ufs.func_206886_c()) && posus) {
            return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        }
        posd = pos.func_177977_b();
        stated = w.func_180495_p(posd);
        downsuc = stated.func_204520_s().func_206886_c().func_207187_a(fluid);
        if (posus) {
            offset2 = 1.0f;
        }
        if (downsuc) {
            offset = 0.0f;
        }
        Direction dir = Direction.EAST;
        for (int n = 0; n < 4; ++n) {
            BlockPos pos2d;
            BlockState state2d;
            dir = dir.func_176735_f();
            int n2 = n > 0 ? n - 1 : 3;
            BlockPos pos2 = pos.func_177972_a(dir);
            BlockState state2 = w.func_180495_p(pos2);
            boolean reach2 = FFluidStatic.canReach(pos, pos2, state, state2, fluid, w);
            boolean same2 = state2.func_204520_s().func_206886_c().func_207187_a(fluid);
            if (same2 && reach2) {
                BlockPos pos2u = pos2.func_177984_a();
                BlockState state2u = w.func_180495_p(pos2u);
                if (state2u.func_204520_s().func_206886_c().func_207187_a(fluid) && FFluidStatic.canReach(pos2, pos2u, state2, state2u, fluid, w)) {
                    conner[n] = true;
                    conner[n2] = true;
                    setconner[n] = true;
                    setconner[n2] = true;
                    setconnervl[n] = offset2;
                    setconnervl[n2] = offset2;
                } else {
                    float level2 = state2.func_204520_s().func_223408_f();
                    int n3 = n;
                    sum[n3] = sum[n3] + level2;
                    int n4 = n2;
                    sum[n4] = sum[n4] + level2;
                    int n5 = n;
                    count[n5] = count[n5] + 1;
                    int n6 = n2;
                    count[n6] = count[n6] + 1;
                }
                Direction[] dirside = new Direction[]{dir.func_176746_e(), dir.func_176735_f()};
                for (int i = 0; i < 2; ++i) {
                    BlockPos pos2dird;
                    BlockState state2dird;
                    BlockState state2dir;
                    BlockPos pos2dir;
                    if (i == 0 && conner[n2] || i == 1 && conner[n] || !FFluidStatic.canReach(pos2, pos2dir = pos2.func_177972_a(dirside[i]), state2, state2dir = w.func_180495_p(pos2dir), fluid, w)) continue;
                    if (state2dir.func_204520_s().func_206886_c().func_207187_a(fluid)) {
                        BlockPos pos2diru = pos2dir.func_177984_a();
                        BlockState state2diru = w.func_180495_p(pos2diru);
                        if (state2diru.func_204520_s().func_206886_c().func_207187_a(fluid) && FFluidStatic.canReach(pos2dir, pos2diru, state2dir, state2diru, fluid, w)) {
                            if (i == 0) {
                                setconnervl[n2] = offset2;
                                setconner[n2] = true;
                                conner[n2] = true;
                                continue;
                            }
                            setconnervl[n] = offset2;
                            setconner[n] = true;
                            conner[n] = true;
                            continue;
                        }
                        float level2dir = state2dir.func_204520_s().func_223408_f();
                        if (i == 0) {
                            int n7 = n2;
                            sum[n7] = sum[n7] + level2dir;
                            int n8 = n2;
                            count[n8] = count[n8] + 1;
                            conner[n2] = true;
                            continue;
                        }
                        int n9 = n;
                        sum[n9] = sum[n9] + level2dir;
                        int n10 = n;
                        count[n10] = count[n10] + 1;
                        conner[n] = true;
                        continue;
                    }
                    if (!state2dir.func_204520_s().func_206888_e() || !(state2dird = w.func_180495_p(pos2dird = pos2dir.func_177977_b())).func_204520_s().func_206886_c().func_207187_a(fluid) || !FFluidStatic.canReach(pos2dir, pos2dird, state2dir, state2dird, fluid, w)) continue;
                    if (i == 0) {
                        if (!setconner[n2]) {
                            setconnervl[n2] = offset;
                        }
                        setconner[n2] = true;
                        conner[n2] = true;
                        continue;
                    }
                    if (!setconner[n2]) {
                        setconnervl[n] = offset;
                    }
                    setconner[n] = true;
                    conner[n] = true;
                }
                continue;
            }
            if (!reach2 || !(state2d = w.func_180495_p(pos2d = pos2.func_177977_b())).func_204520_s().func_206886_c().func_207187_a(fluid) || !FFluidStatic.canReach(pos2, pos2d, state2, state2d, fluid, w)) continue;
            if (!setconner[n]) {
                setconner[n] = true;
                setconnervl[n] = offset;
            }
            if (setconner[n2]) continue;
            setconner[n2] = true;
            setconnervl[n2] = offset;
        }
        float[] ch = new float[4];
        for (int i = 0; i < 4; ++i) {
            ch[i] = setconner[i] ? setconnervl[i] : sum[i] / (float)count[i];
        }
        return ch;
    }

    public static float getConH(IBlockReader w, BlockPos p, Fluid f, BlockPos dir) {
        BlockPos downp;
        FluidState downfs;
        BlockPos pu = p.func_177984_a();
        FluidState ufs = w.func_204610_c(pu);
        if (!ufs.func_206888_e() && FFluidStatic.isSameFluid(ufs.func_206886_c(), f)) {
            return 1.0f;
        }
        FluidState fsm = w.func_204610_c(p);
        float sl = fsm.func_223408_f();
        int i = 1;
        BlockPos dp = p.func_177982_a(dir.func_177958_n(), 0, 0);
        BlockPos dp2 = p.func_177982_a(0, 0, dir.func_177952_p());
        FluidState dfs = w.func_204610_c(dp);
        FluidState dfs2 = w.func_204610_c(dp2);
        boolean s = false;
        if (!dfs.func_206888_e() && FFluidStatic.isSameFluid(dfs.func_206886_c(), f)) {
            pu = dp.func_177984_a();
            ufs = w.func_204610_c(pu);
            if (!ufs.func_206888_e() && FFluidStatic.isSameFluid(ufs.func_206886_c(), f)) {
                return 1.0f;
            }
            sl += dfs.func_223408_f();
            ++i;
            s = true;
        } else if (dfs.func_206888_e() && FFluidStatic.canReach(w, p, Direction.func_176737_a((float)dir.func_177958_n(), (float)0.0f, (float)0.0f)) && !(downfs = w.func_204610_c(downp = dp.func_177977_b())).func_206888_e() && FFluidStatic.isSameFluid(downfs.func_206886_c(), f) && downfs.func_223408_f() == 1.0f) {
            return 0.0f;
        }
        if (!dfs2.func_206888_e() && FFluidStatic.isSameFluid(dfs2.func_206886_c(), f)) {
            pu = dp2.func_177984_a();
            ufs = w.func_204610_c(pu);
            if (!ufs.func_206888_e() && FFluidStatic.isSameFluid(ufs.func_206886_c(), f)) {
                return 1.0f;
            }
            sl += dfs2.func_223408_f();
            ++i;
            s = true;
        } else if (dfs2.func_206888_e() && FFluidStatic.canReach(w, p, Direction.func_176737_a((float)0.0f, (float)0.0f, (float)dir.func_177952_p())) && !(downfs = w.func_204610_c(downp = dp2.func_177977_b())).func_206888_e() && FFluidStatic.isSameFluid(downfs.func_206886_c(), f) && downfs.func_223408_f() == 1.0f) {
            return 0.0f;
        }
        if (s) {
            BlockPos downp2;
            FluidState downfs2;
            BlockPos dp3 = p.func_177971_a((Vector3i)dir);
            FluidState dfs3 = w.func_204610_c(dp3);
            if (!dfs3.func_206888_e() && FFluidStatic.isSameFluid(dfs3.func_206886_c(), f)) {
                pu = dp3.func_177984_a();
                ufs = w.func_204610_c(pu);
                if (!ufs.func_206888_e() && FFluidStatic.isSameFluid(ufs.func_206886_c(), f)) {
                    return 1.0f;
                }
                sl += dfs3.func_223408_f();
                ++i;
            } else if (dfs3.func_206888_e() && !(downfs2 = w.func_204610_c(downp2 = dp3.func_177977_b())).func_206888_e() && FFluidStatic.isSameFluid(downfs2.func_206886_c(), f) && downfs2.func_223408_f() == 1.0f && FFluidStatic.canReach(w, dp3, Direction.func_176737_a((float)0.0f, (float)1.0f, (float)0.0f))) {
                return 0.0f;
            }
        }
        return sl /= (float)i;
    }

    private static boolean canReach(IBlockReader world, BlockPos pos, Direction direction) {
        BlockState state1 = world.func_180495_p(pos);
        BlockState state2 = world.func_180495_p(pos.func_177972_a(direction));
        if (state2.func_200132_m() && !(state2.func_177230_c() instanceof IWaterLoggable)) {
            return false;
        }
        VoxelShape voxelShape2 = state2.func_196952_d(world, pos.func_177972_a(direction));
        VoxelShape voxelShape1 = state1.func_196952_d(world, pos);
        if (voxelShape1.func_197766_b() && voxelShape2.func_197766_b()) {
            return true;
        }
        return !VoxelShapes.func_204642_b((VoxelShape)voxelShape1, (VoxelShape)voxelShape2, (Direction)direction);
    }

    public static boolean canReach(BlockPos pos1, BlockPos pos2, BlockState state1, BlockState state2, Fluid fluid, IBlockReader w) {
        Fluid f2 = state2.func_204520_s().func_206886_c();
        if (f2.func_207187_a(fluid) && state1.func_177230_c() instanceof FlowingFluidBlock && state2.func_177230_c() instanceof FlowingFluidBlock) {
            return true;
        }
        FluidPars fp2 = (FluidPars)((IBlockExtended)state2.func_177230_c()).getCustomBlockPars().get(FluidPars.class);
        FluidPars fp1 = (FluidPars)((IBlockExtended)state1.func_177230_c()).getCustomBlockPars().get(FluidPars.class);
        boolean posos = false;
        if (fp1 != null && fp1.isPassable == 1) {
            posos = true;
        }
        Direction dir = FFluidStatic.dirFromVec(pos1, pos2);
        if (fp2 != null) {
            if (fp2.isPassable == 1) {
                return true;
            }
            if (fp2.isPassable == -1) {
                return false;
            }
            if ((state2.func_204520_s().func_206888_e() || state1.func_204520_s().func_215677_a(w, pos1, f2, dir)) && fp2.isDestroyableBy(fluid)) {
                return true;
            }
        }
        if (state2.func_200132_m() && !posos && !(state2.func_177230_c() instanceof IWaterLoggable)) {
            return false;
        }
        if (!(fluid instanceof WaterFluid) && (state1.func_177230_c() instanceof IWaterLoggable || state2.func_177230_c() instanceof IWaterLoggable)) {
            return false;
        }
        VoxelShape voxelShape2 = state2.func_196952_d(w, pos2);
        VoxelShape voxelShape1 = state1.func_196952_d(w, pos1);
        if ((voxelShape1.func_197766_b() || posos) && voxelShape2.func_197766_b()) {
            return true;
        }
        return !VoxelShapes.func_204642_b((VoxelShape)voxelShape1, (VoxelShape)voxelShape2, (Direction)dir);
    }

    public static boolean canOnlyFullCube(BlockState bs) {
        return FFluidStatic.canOnlyFullCube(bs.func_177230_c());
    }

    public static boolean canOnlyFullCube(Block b) {
        return b instanceof IWaterLoggable ? !(b instanceof IBaseWL) : false;
    }

    public static void onBucketEvent(FillBucketEvent e) {
        Optional op;
        Object bh;
        Fluid f;
        FishBucketItem fishItem = null;
        ItemStack bucket = e.getEmptyBucket();
        Item bu = bucket.func_77973_b();
        if (bu instanceof FishBucketItem) {
            fishItem = (FishBucketItem)bu;
        }
        if (!((f = (bh = (op = bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).resolve()).isPresent() ? (IFluidHandlerItem)op.get() : new ExtendedFHIS(bucket, 1000)).getFluidInTank(0).getFluid()) instanceof FlowingFluid) && f != Fluids.field_204541_a) {
            return;
        }
        PlayerEntity p = e.getPlayer();
        World w = e.getWorld();
        RayTraceResult targ0 = e.getTarget();
        BlockRayTraceResult targ = FFluidStatic.rayTrace(w, p, f == Fluids.field_204541_a ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE);
        targ0 = targ;
        if (targ.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult targB = targ;
        BlockPos pos = targB.func_216350_a();
        BlockState bs = w.func_180495_p(pos);
        FluidState fs = bs.func_204520_s();
        if (fs.func_206888_e() && f != Fluids.field_204541_a && !(bs.func_177230_c() instanceof IWaterLoggable)) {
            pos = pos.func_177972_a(targB.func_216354_b());
            bs = w.func_180495_p(pos);
            fs = bs.func_204520_s();
        }
        if (!w.field_72995_K && f != Fluids.field_204541_a && bs.func_177230_c() instanceof IWaterLoggable) {
            FluidTasksManager.addFluidTask((ServerWorld)w, pos, bs);
        }
        Fluid fluid = fs.func_206886_c();
        if (!f.func_207187_a((Fluid)Fluids.field_204546_a) && f != Fluids.field_204541_a && bs.func_177230_c() instanceof IWaterLoggable) {
            return;
        }
        if (!w.func_175660_a(p, pos) || !p.func_175151_a(pos, targB.func_216354_b(), bh.getContainer())) {
            return;
        }
        if (f == Fluids.field_204541_a) {
            BlockRayTraceResult targB0;
            FluidState fs0;
            if (!(fluid instanceof FlowingFluid)) {
                return;
            }
            if (targ0.func_216346_c() == RayTraceResult.Type.BLOCK && (fs0 = w.func_204610_c((targB0 = (BlockRayTraceResult)targ0).func_216350_a())).func_206889_d()) {
                return;
            }
            BucketFiller filler = new BucketFiller(w, fluid, (IFluidHandlerItem)bh, e);
            FFluidStatic.iterateFluidWay((Integer)WPOConfig.COMMON.maxBucketDist.get(), pos, filler);
        } else {
            if (!f.func_207187_a(fluid) && fluid != Fluids.field_204541_a) {
                e.setCanceled(true);
                return;
            }
            BucketFlusher flusher = new BucketFlusher(w, f, (IFluidHandlerItem)bh, e);
            if (FFluidStatic.iterateFluidWay((Integer)WPOConfig.COMMON.maxBucketDist.get(), pos, flusher) && fishItem != null) {
                fishItem.func_203792_a(w, bucket, pos);
            }
        }
    }

    public static BlockRayTraceResult rayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vector3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vector3d1 = vector3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    public static boolean iterateFluidWay(int maxRange, BlockPos pos, IFluidActionIteratable actioner) {
        boolean frst = true;
        boolean client = false;
        World w = actioner.getWorld();
        WWSGlobal wws = ((IWorldExtended)w).getWWS();
        HashSet<BlockPos> setBan = new HashSet<BlockPos>();
        HashSet<BlockPos> setAll = new HashSet<BlockPos>();
        boolean bl = client = wws == null;
        if (!client && setBan.add(pos) && !wws.banPos(pos.func_218275_a())) {
            setBan.forEach(arg_0 -> FFluidStatic.lambda$iterateFluidWay$0((IWWSG)wws, arg_0));
            return false;
        }
        setAll.add(pos);
        HashSet<BlockPos> setLocal = new HashSet<BlockPos>();
        actioner.addZero(setLocal, pos);
        int n = maxRange;
        while (n > 0 && !actioner.isComplete() && !setLocal.isEmpty()) {
            --n;
            HashSet<BlockPos> setLocal2 = new HashSet<BlockPos>();
            block1: for (BlockPos posn : setLocal) {
                if (frst) {
                    frst = false;
                    setAll.add(posn);
                    BlockState bs = w.func_180495_p(posn);
                    if (!client && setBan.add(posn) && !wws.banPos(posn.func_218275_a())) {
                        setBan.forEach(arg_0 -> FFluidStatic.lambda$iterateFluidWay$1((IWWSG)wws, arg_0));
                        return false;
                    }
                    actioner.run(posn, bs);
                }
                if (actioner.isComplete()) break;
                for (Direction dir : FFluidStatic.getRandomizedDirections(w.func_201674_k(), true)) {
                    BlockPos pos2 = posn.func_177972_a(dir);
                    if (setAll.contains(pos2)) continue;
                    BlockState bs2 = w.func_180495_p(pos2);
                    boolean cr = FFluidStatic.canReach((IBlockReader)w, posn, dir);
                    boolean eq = actioner.isValidState(bs2);
                    if (cr && eq) {
                        setLocal2.add(pos2);
                        if (actioner.isValidPos(pos2)) {
                            if (!client && setBan.add(pos2) && !wws.banPos(pos2.func_218275_a())) {
                                setBan.forEach(arg_0 -> FFluidStatic.lambda$iterateFluidWay$2((IWWSG)wws, arg_0));
                                return false;
                            }
                            actioner.run(pos2, bs2);
                        }
                    }
                    setAll.add(pos2);
                    if (actioner.isComplete()) continue block1;
                }
            }
            setLocal = setLocal2;
        }
        if (actioner.isComplete()) {
            actioner.finish();
            if (!client) {
                setBan.forEach(arg_0 -> FFluidStatic.lambda$iterateFluidWay$3((IWWSG)wws, arg_0));
            }
            return true;
        }
        actioner.fail();
        if (!client) {
            setBan.forEach(arg_0 -> FFluidStatic.lambda$iterateFluidWay$4((IWWSG)wws, arg_0));
        }
        return false;
    }

    public static void fillStates(Long2ObjectLinkedOpenHashMap<BlockState> states, World world) {
        if (!world.field_72995_K) {
            states.forEach((lpos, state) -> world.func_175656_a(BlockPos.func_218283_e((long)lpos), state));
        }
    }

    public static void onBottleUse(World w, PlayerEntity p, Hand hand, CallbackInfoReturnable<ActionResult<ItemStack>> ci, ItemStack stack) {
        BlockRayTraceResult rt = FFluidStatic.rayTrace(w, p, RayTraceContext.FluidMode.ANY);
        BlockPos pos = rt.func_216350_a();
        BottleFiller filler = new BottleFiller(w, (Fluid)Fluids.field_204546_a, ci, stack);
        FFluidStatic.iterateFluidWay((Integer)WPOConfig.COMMON.maxBucketDist.get(), pos, filler);
    }

    public static void onBlockPlace(BlockEvent.EntityPlaceEvent e) {
        World w = (World)e.getWorld();
        BlockPos pos = e.getPos();
        BlockState oldState = e.getBlockSnapshot().getReplacedBlock();
        FluidState fs = oldState.func_204520_s();
        Fluid f = fs.func_206886_c();
        BlockState newState = e.getPlacedBlock();
        Block nb = newState.func_177230_c();
        if (fs.func_206888_e() || nb instanceof SpongeBlock || nb instanceof WetSpongeBlock) {
            return;
        }
        if (nb instanceof ILiquidContainer && !(nb instanceof IWaterLoggable)) {
            return;
        }
        if (nb instanceof IWaterLoggable && ((Boolean)newState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            return;
        }
        if (!FFluidStatic.canOnlyFullCube(newState) && nb instanceof IBaseWL && f.func_207187_a((Fluid)Fluids.field_204546_a)) {
            newState = FFluidStatic.getUpdatedState(newState, fs.func_206882_g(), (Fluid)Fluids.field_204546_a);
            w.func_175656_a(pos, newState);
            return;
        }
        FluidDisplacer displacer = new FluidDisplacer(w, e);
        FFluidStatic.iterateFluidWay(10, e.getPos(), displacer);
    }

    public static void onPistonPre(PistonEvent.Pre e) {
        World w = (World)e.getWorld();
        if (w.field_72995_K || e.isCanceled()) {
            return;
        }
        PistonBlockStructureHelper ps = e.getStructureHelper();
        if (!ps.func_177253_a()) {
            return;
        }
        List poslist = ps.func_177252_d();
        for (BlockPos pos : poslist) {
            PistonDisplacer displacer;
            BlockState state = w.func_180495_p(pos);
            FluidState fs = state.func_204520_s();
            if (fs.func_206888_e() || FFluidStatic.iterateFluidWay(12, pos, displacer = new PistonDisplacer(w, e, state, ps))) continue;
            e.setCanceled(true);
        }
    }

    private static /* synthetic */ void lambda$iterateFluidWay$4(IWWSG wws, BlockPos p) {
        wws.unbanPos(p.func_218275_a());
    }

    private static /* synthetic */ void lambda$iterateFluidWay$3(IWWSG wws, BlockPos p) {
        wws.unbanPos(p.func_218275_a());
    }

    private static /* synthetic */ void lambda$iterateFluidWay$2(IWWSG wws, BlockPos p) {
        wws.unbanPos(p.func_218275_a());
    }

    private static /* synthetic */ void lambda$iterateFluidWay$1(IWWSG wws, BlockPos p) {
        wws.unbanPos(p.func_218275_a());
    }

    private static /* synthetic */ void lambda$iterateFluidWay$0(IWWSG wws, BlockPos p) {
        wws.banPos(p.func_218275_a());
    }

    public static interface IFluidActionIteratable {
        default public void addZero(Set<BlockPos> set, BlockPos p0) {
            set.add(p0);
        }

        public boolean isComplete();

        public void run(BlockPos var1, BlockState var2);

        public World getWorld();

        public boolean isValidState(BlockState var1);

        default public boolean isValidPos(BlockPos pos) {
            return true;
        }

        public void finish();

        default public void fail() {
        }
    }

    private static class PistonDisplacer
    implements IFluidActionIteratable {
        int mfl = 8;
        int sl;
        boolean complete = false;
        World world;
        Fluid fluid;
        Set<BlockPos> movepos = new HashSet<BlockPos>();
        PistonEvent.Pre event;
        Long2ObjectLinkedOpenHashMap<BlockState> states = new Long2ObjectLinkedOpenHashMap();
        BlockState obs;

        PistonDisplacer(World w, PistonEvent.Pre e, BlockState os, PistonBlockStructureHelper ps) {
            this.obs = os;
            FluidState ofs = this.obs.func_204520_s();
            this.fluid = ofs.func_206886_c();
            this.sl = ofs.func_206882_g();
            this.world = w;
            this.event = e;
            this.movepos.addAll(ps.func_177252_d());
            this.movepos.addAll(ps.func_177254_c());
            for (BlockPos p : ps.func_177254_c()) {
                this.movepos.add(p.func_177972_a(this.event.getDirection()));
            }
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void addZero(Set<BlockPos> set, BlockPos p0) {
            for (Direction d : FFluidStatic.getRandomizedDirections(this.world.func_201674_k(), true)) {
                BlockPos pos2 = p0.func_177972_a(d);
                BlockState state2 = this.world.func_180495_p(pos2);
                if (!this.isValidState(state2) || !FFluidStatic.canReach(p0, pos2, this.obs, state2, this.fluid, (IBlockReader)this.world)) continue;
                set.add(pos2);
            }
        }

        @Override
        public void run(BlockPos pos, BlockState state) {
            if (FFluidStatic.canOnlyFullCube(state) && state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                this.states.clear();
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, this.mfl, this.fluid));
                this.complete = true;
                return;
            }
            FluidState fs = state.func_204520_s();
            int el = this.mfl - fs.func_206882_g();
            int osl = this.sl;
            this.sl -= el;
            int nl = this.mfl;
            if (this.sl <= 0) {
                nl = this.mfl + this.sl;
                this.complete = true;
            }
            if (osl != this.sl) {
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, nl, this.fluid));
            }
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public boolean isValidState(BlockState state) {
            return this.fluid.func_207187_a(state.func_204520_s().func_206886_c()) || state.func_204520_s().func_206888_e();
        }

        @Override
        public boolean isValidPos(BlockPos pos) {
            return !this.movepos.contains(pos);
        }

        @Override
        public void finish() {
            FFluidStatic.fillStates(this.states, this.world);
            this.event.setResult(Event.Result.ALLOW);
        }

        @Override
        public void fail() {
            this.event.setCanceled(true);
        }
    }

    public static class FluidDisplacer2
    implements IFluidActionIteratable {
        int mfl = 8;
        int sl;
        boolean complete = false;
        World world;
        Fluid fluid;
        Long2ObjectLinkedOpenHashMap<BlockState> states = new Long2ObjectLinkedOpenHashMap();
        BlockState obs;

        FluidDisplacer2(World w, BlockState obs) {
            FluidState ofs = obs.func_204520_s();
            this.obs = obs;
            this.fluid = ofs.func_206886_c();
            this.sl = ofs.func_206882_g();
            this.world = w;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void addZero(Set<BlockPos> set, BlockPos p0) {
            for (Direction d : FFluidStatic.getRandomizedDirections(this.world.func_201674_k(), true)) {
                BlockPos pos2 = p0.func_177972_a(d);
                BlockState state2 = this.world.func_180495_p(pos2);
                if (!this.isValidState(state2) || !FFluidStatic.canReach(p0, pos2, this.obs, state2, this.fluid, (IBlockReader)this.world)) continue;
                set.add(pos2);
            }
        }

        @Override
        public void run(BlockPos pos, BlockState state) {
            if (FFluidStatic.canOnlyFullCube(state) && state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                this.states.clear();
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, this.mfl, this.fluid));
                this.complete = true;
                return;
            }
            FluidState fs = state.func_204520_s();
            int el = this.mfl - fs.func_206882_g();
            int osl = this.sl;
            this.sl -= el;
            int nl = this.mfl;
            if (this.sl <= 0) {
                nl = this.mfl + this.sl;
                this.complete = true;
            }
            if (osl != this.sl) {
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, nl, this.fluid));
            }
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public boolean isValidState(BlockState state) {
            return this.fluid.func_207187_a(state.func_204520_s().func_206886_c()) || state.func_204520_s().func_206888_e();
        }

        @Override
        public void finish() {
            FFluidStatic.fillStates(this.states, this.world);
        }

        @Override
        public void fail() {
        }
    }

    public static class FluidDisplacer
    implements IFluidActionIteratable {
        int mfl = 8;
        int sl;
        boolean complete = false;
        World world;
        Fluid fluid;
        BlockEvent.EntityPlaceEvent event;
        Long2ObjectLinkedOpenHashMap<BlockState> states = new Long2ObjectLinkedOpenHashMap();
        BlockState obs;

        FluidDisplacer(World w, BlockEvent.EntityPlaceEvent e) {
            this.obs = e.getBlockSnapshot().getReplacedBlock();
            FluidState ofs = this.obs.func_204520_s();
            this.fluid = ofs.func_206886_c();
            this.sl = ofs.func_206882_g();
            this.world = w;
            this.event = e;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void addZero(Set<BlockPos> set, BlockPos p0) {
            for (Direction d : FFluidStatic.getRandomizedDirections(this.world.func_201674_k(), true)) {
                BlockPos pos2 = p0.func_177972_a(d);
                BlockState state2 = this.world.func_180495_p(pos2);
                if (!this.isValidState(state2) || !FFluidStatic.canReach(p0, pos2, this.obs, state2, this.fluid, (IBlockReader)this.world)) continue;
                set.add(pos2);
            }
        }

        @Override
        public void run(BlockPos pos, BlockState state) {
            if (FFluidStatic.canOnlyFullCube(state) && state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                this.states.clear();
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, this.mfl, this.fluid));
                this.complete = true;
                return;
            }
            FluidState fs = state.func_204520_s();
            int el = this.mfl - fs.func_206882_g();
            int osl = this.sl;
            this.sl -= el;
            int nl = this.mfl;
            if (this.sl <= 0) {
                nl = this.mfl + this.sl;
                this.complete = true;
            }
            if (osl != this.sl) {
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, nl, this.fluid));
            }
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public boolean isValidState(BlockState state) {
            return this.fluid.func_207187_a(state.func_204520_s().func_206886_c()) || state.func_204520_s().func_206888_e();
        }

        @Override
        public void finish() {
            FFluidStatic.fillStates(this.states, this.world);
            this.event.setResult(Event.Result.ALLOW);
        }

        @Override
        public void fail() {
        }
    }

    private static class BucketFlusher
    implements IFluidActionIteratable {
        int mfl = 8;
        int bucketLevels;
        int sl = this.bucketLevels = 8;
        boolean complete = false;
        World world;
        Fluid fluid;
        FillBucketEvent event;
        IFluidHandlerItem bucket;
        Long2ObjectLinkedOpenHashMap<BlockState> states = new Long2ObjectLinkedOpenHashMap();

        BucketFlusher(World w, Fluid f, IFluidHandlerItem b, FillBucketEvent e) {
            this.world = w;
            this.fluid = f;
            this.bucket = b;
            this.event = e;
            this.sl = this.bucket.getFluidInTank(0).getAmount() / 125;
            this.fluid = this.bucket.getFluidInTank(0).getFluid();
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void run(BlockPos pos, BlockState state) {
            if (FFluidStatic.canOnlyFullCube(state) && state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                this.states.clear();
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, this.mfl, this.fluid));
                this.complete = true;
                return;
            }
            FluidState fs = state.func_204520_s();
            int el = this.mfl - fs.func_206882_g();
            int osl = this.sl;
            this.sl -= el;
            int nl = this.mfl;
            if (this.sl <= 0) {
                nl = this.mfl + this.sl;
                this.complete = true;
            }
            if (osl != this.sl) {
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, nl, this.fluid));
            }
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public boolean isValidState(BlockState state) {
            return this.fluid.func_207187_a(state.func_204520_s().func_206886_c()) || state.func_204520_s().func_206888_e();
        }

        @Override
        public void finish() {
            FFluidStatic.fillStates(this.states, this.world);
            this.event.setResult(Event.Result.ALLOW);
            PlayerEntity p = this.event.getPlayer();
            Item item = this.bucket.getContainer().func_77973_b();
            p.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item));
            SoundEvent soundevent = this.fluid.getAttributes().getEmptySound();
            if (soundevent == null) {
                soundevent = this.fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
            }
            p.func_184185_a(soundevent, 1.0f, 1.0f);
            if (!p.field_71075_bZ.field_75098_d) {
                this.event.setFilledBucket(new ItemStack((IItemProvider)Items.field_151133_ar));
            }
        }
    }

    private static class BottleFiller
    implements IFluidActionIteratable {
        int bucketLevels = 3;
        int sl = 0;
        boolean complete = false;
        World world;
        ItemStack bottle;
        Fluid fluid;
        CallbackInfoReturnable<ActionResult<ItemStack>> ci;
        Long2ObjectLinkedOpenHashMap<BlockState> states = new Long2ObjectLinkedOpenHashMap();

        BottleFiller(World w, Fluid f, CallbackInfoReturnable<ActionResult<ItemStack>> ci, ItemStack stack) {
            this.world = w;
            this.fluid = f;
            this.bottle = stack;
            this.ci = ci;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void run(BlockPos pos, BlockState state) {
            if (FFluidStatic.canOnlyFullCube(state) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                this.states.clear();
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, 0, this.fluid));
                this.complete = true;
                return;
            }
            FluidState fs = state.func_204520_s();
            int l = fs.func_206882_g();
            int osl = this.sl;
            this.sl += l;
            int nl = 0;
            if (this.sl >= this.bucketLevels) {
                nl = this.sl - this.bucketLevels;
                this.complete = true;
            }
            if (osl != this.sl) {
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, nl, this.fluid));
            }
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public boolean isValidState(BlockState state) {
            return this.fluid.func_207187_a(state.func_204520_s().func_206886_c());
        }

        @Override
        public void finish() {
            FFluidStatic.fillStates(this.states, this.world);
        }

        @Override
        public void fail() {
            this.ci.setReturnValue((Object)ActionResult.func_226251_d_((Object)this.bottle));
        }
    }

    private static class BucketFiller
    implements IFluidActionIteratable {
        int bucketLevels = 8;
        int sl = 0;
        boolean complete = false;
        World world;
        Fluid fluid;
        FillBucketEvent event;
        IFluidHandlerItem bucket;
        Long2ObjectLinkedOpenHashMap<BlockState> states = new Long2ObjectLinkedOpenHashMap();

        BucketFiller(World w, Fluid f, IFluidHandlerItem b, FillBucketEvent e) {
            this.world = w;
            this.fluid = f;
            this.bucket = b;
            this.event = e;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void run(BlockPos pos, BlockState state) {
            if (FFluidStatic.canOnlyFullCube(state) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                this.states.clear();
                this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, 0, this.fluid));
                this.complete = true;
                return;
            }
            FluidState fs = state.func_204520_s();
            int l = fs.func_206882_g();
            this.sl += l;
            int nl = 0;
            if (this.sl >= this.bucketLevels) {
                nl = this.sl - this.bucketLevels;
                this.complete = true;
            }
            this.states.put(pos.func_218275_a(), (Object)FFluidStatic.getUpdatedState(state, nl, this.fluid));
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public boolean isValidState(BlockState state) {
            return this.fluid.func_207187_a(state.func_204520_s().func_206886_c());
        }

        @Override
        public void fail() {
            FFluidStatic.fillStates(this.states, this.world);
            this.event.setResult(Event.Result.ALLOW);
            PlayerEntity p = this.event.getPlayer();
            Item item = this.bucket.getContainer().func_77973_b();
            p.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item));
            SoundEvent soundevent = this.fluid.getAttributes().getFillSound();
            if (soundevent == null) {
                soundevent = this.fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
            }
            p.func_184185_a(soundevent, 1.0f, 1.0f);
            if (!p.field_71075_bZ.field_75098_d) {
                ItemStack stack = new ItemStack((IItemProvider)net.skds.wpo.registry.Items.ADVANCED_BUCKET.get());
                ExtendedFHIS st2 = new ExtendedFHIS(stack, 1000);
                Fluid f2 = this.fluid instanceof FlowingFluid ? ((FlowingFluid)this.fluid).func_210198_f() : this.fluid;
                FluidStack fluidStack = new FluidStack(f2, this.sl * 125);
                st2.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                stack = st2.getContainer();
                this.event.setFilledBucket(stack);
            }
        }

        @Override
        public void finish() {
            FFluidStatic.fillStates(this.states, this.world);
            this.event.setResult(Event.Result.ALLOW);
            PlayerEntity p = this.event.getPlayer();
            Item item = this.bucket.getContainer().func_77973_b();
            p.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item));
            SoundEvent soundevent = this.fluid.getAttributes().getFillSound();
            if (soundevent == null) {
                soundevent = this.fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
            }
            p.func_184185_a(soundevent, 1.0f, 1.0f);
            if (!p.field_71075_bZ.field_75098_d) {
                this.event.setFilledBucket(new ItemStack((IItemProvider)this.fluid.func_204524_b()));
            }
        }
    }
}

