/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.fluidphysics;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.skds.core.api.IWWS;
import net.skds.core.api.IWWSG;
import net.skds.core.util.blockupdate.BasicExecutor;
import net.skds.core.util.blockupdate.UpdateTask;
import net.skds.wpo.fluidphysics.FFluidStatic;
import net.skds.wpo.fluidphysics.FluidTask;
import net.skds.wpo.fluidphysics.WorldWorkSet;
import net.skds.wpo.util.interfaces.IFlowingFluid;

public abstract class FFluidBasic
extends BasicExecutor {
    protected final int worker;
    protected final Mode mode;
    protected final int MFL = 8;
    protected final Fluid fluid;
    protected final ServerWorld w;
    protected final BlockPos pos;
    protected final long longpos;
    protected final WorldWorkSet castOwner;
    protected int level = 0;
    protected FluidState fs;
    protected BlockState state;

    protected FFluidBasic(ServerWorld w, BlockPos pos, Mode mode, WorldWorkSet owner, int worker) {
        super(w, FFluidBasic::updater, (IWWS)owner);
        this.castOwner = owner;
        this.worker = worker;
        this.w = w;
        this.mode = mode;
        this.state = this.getBlockState(pos);
        this.fs = this.state.func_204520_s();
        this.fluid = this.fs.func_206886_c();
        this.pos = pos;
        this.longpos = pos.func_218275_a();
        this.level = this.fs.func_206882_g();
    }

    public static void updater(UpdateTask task, ServerWorld world) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyAction(BlockPos pos, BlockState newState, BlockState oldState, ServerWorld world) {
        Fluid fluid;
        if (newState == oldState) {
            return;
        }
        IChunk ichunk = this.getChunk(pos);
        if (!(ichunk instanceof Chunk)) {
            return;
        }
        Chunk chunk = (Chunk)ichunk;
        Block block = newState.func_177230_c();
        BlockPos posu = pos.func_177984_a();
        if (this.getBlockState(posu).func_204520_s().func_206888_e()) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos posu2 = posu.func_177972_a(dir);
                if (this.getBlockState(posu2).func_204520_s().func_206888_e()) continue;
                WorldWorkSet.pushTask(new FluidTask.DefaultTask(this.castOwner, posu2.func_218275_a()));
            }
        }
        if ((fluid = newState.func_204520_s().func_206886_c()) != Fluids.field_204541_a) {
            this.castOwner.excludedTasks.add((Object)this.longpos);
        }
        ServerWorld serverWorld = world;
        synchronized (serverWorld) {
            if (!(fluid == Fluids.field_204541_a || oldState.func_196958_f() || fluid.func_207187_a(oldState.func_204520_s().func_206886_c()) || oldState.func_177230_c() instanceof IWaterLoggable)) {
                ((IFlowingFluid)fluid).beforeReplacingBlockCustom((IWorld)world, pos, oldState);
            }
            if (chunk.func_217321_u() != null && chunk.func_217321_u().func_219065_a(ChunkHolder.LocationType.TICKING)) {
                world.func_184138_a(pos, oldState, newState, 3);
            }
            world.func_195593_d(pos, block);
            if (this.state.func_185912_n()) {
                world.func_175666_e(pos, block);
            }
            newState.func_235734_a_((IWorld)world, pos, 0);
            newState.func_215705_a((World)world, pos, oldState, false);
        }
        if (newState.func_204520_s().func_206888_e() ^ oldState.func_204520_s().func_206888_e() && (newState.func_200016_a((IBlockReader)world, pos) != oldState.func_200016_a((IBlockReader)world, pos) || newState.getLightValue((IBlockReader)world, pos) != oldState.getLightValue((IBlockReader)world, pos) || newState.func_215691_g() || oldState.func_215691_g())) {
            world.func_72863_F().func_212863_j_().func_215568_a(pos);
        }
    }

    protected int getAbsoluteLevel(int y, int l) {
        return y * 8 + l;
    }

    public void run() {
        if (this.level > 0 && this.fluid instanceof FlowingFluid) {
            this.execute();
        }
        IWWSG wwsg = this.owner.getG();
        this.banPoses.forEach(p -> wwsg.unbanPos(p.func_218275_a()));
    }

    /*
     * Unable to fully structure code
     */
    protected boolean flow(BlockPos pos1, BlockPos pos2, int h) {
        block12: {
            block15: {
                block13: {
                    block14: {
                        if (!this.validate(pos1)) {
                            return false;
                        }
                        if (!this.validate(pos2)) {
                            return false;
                        }
                        ss = true;
                        state1 = this.getBlockState(pos1);
                        state2 = this.getBlockState(pos2);
                        if (this.canOnlyFillCube(state1) || this.canOnlyFillCube(state2)) {
                            this.unban(pos1);
                            this.unban(pos2);
                            return false;
                        }
                        if (this.trySwap(pos1, pos2, h, state1, state2)) break block12;
                        fs1 = state1.func_204520_s();
                        fs2 = state2.func_204520_s();
                        l1 = fs1.func_206882_g();
                        l2 = fs2.func_206882_g();
                        f1 = fs1.func_206886_c();
                        if (f1.func_207187_a(f2 = fs2.func_206886_c()) || fs1.func_206888_e() || fs2.func_206888_e()) break block13;
                        dir = FFluidBasic.dirFromVec((BlockPos)pos1, (BlockPos)pos2);
                        if (fs1.func_215677_a((IBlockReader)this.w, pos2, f2, dir)) break block14;
                        ss = false;
                        break block12;
                    }
                    state2 = Blocks.field_150350_a.func_176223_P();
                    fs2 = state2.func_204520_s();
                    l2 = 0;
                }
                if (h != 0) break block15;
                d2 = (l1 - l2) / 2;
                if (d2 != 0) ** GOTO lbl35
                if (l1 != 1 || l2 != 0) {
                    ss = false;
                } else {
                    d2 = 1;
lbl35:
                    // 2 sources

                    sn1 = this.getUpdatedState(state1, l1 -= d2);
                    sn2 = this.getUpdatedState(state2, l2 += d2);
                    this.setState(pos1, sn1);
                    this.setState(pos2, sn2);
                }
                break block12;
            }
            sum = l1 + l2;
            if (sum > 8) {
                if (h > 0) {
                    l1 = 8;
                    l2 = sum - 8;
                } else {
                    l2 = 8;
                    l1 = sum - 8;
                }
            } else if (h > 0) {
                l1 = sum;
                l2 = 0;
            } else {
                bl = l1 > 1;
                l2 = sum;
                l1 = 0;
                if (bl) {
                    --l2;
                    ++l1;
                }
            }
            sn1 = this.getUpdatedState(state1, l1);
            sn2 = this.getUpdatedState(state2, l2);
            this.setState(pos1, sn1);
            this.setState(pos2, sn2);
        }
        this.unban(pos1);
        this.unban(pos2);
        return ss;
    }

    protected boolean trySwap(BlockPos pos1, BlockPos pos2, int h, BlockState state1, BlockState state2) {
        return false;
    }

    protected abstract void execute();

    protected boolean canOnlyFillCube(BlockState bs) {
        return FFluidStatic.canOnlyFullCube(bs);
    }

    protected boolean canOnlyFillCube(Block b) {
        return FFluidStatic.canOnlyFullCube(b);
    }

    protected boolean validate(BlockPos p) {
        long l = p.func_218275_a();
        boolean ss = this.owner.getG().banPos(l);
        if (ss) {
            this.banPoses.add(p);
        }
        return ss;
    }

    protected void unban(BlockPos p) {
        long l = p.func_218275_a();
        this.owner.getG().unbanPos(l);
        this.banPoses.remove(p);
    }

    protected void addPassedEq(BlockPos addPos) {
        long l = addPos.func_218275_a();
        this.castOwner.addEqLock(l);
        this.castOwner.addNTTask(l, FFluidStatic.getTickRate((FlowingFluid)this.fluid, (IWorldReader)this.w));
    }

    protected boolean isPassedEq(BlockPos isPos) {
        long l = isPos.func_218275_a();
        return this.castOwner.isEqLocked(l);
    }

    protected boolean flowFullCubeV2(BlockPos pos1, BlockPos pos2) {
        if (!this.validate(pos1)) {
            return false;
        }
        if (!this.validate(pos2)) {
            return false;
        }
        boolean bb = false;
        BlockState state1 = this.getBlockState(pos1);
        BlockState state2 = this.getBlockState(pos2);
        int l1 = state1.func_204520_s().func_206882_g();
        int l2 = state2.func_204520_s().func_206882_g();
        if (l1 == 8 && l2 == 0 || l1 == 0 && l2 == 8) {
            BlockState sn1 = this.getUpdatedState(state1, l2);
            BlockState sn2 = this.getUpdatedState(state2, l1);
            this.setState(pos1, sn1);
            this.setState(pos2, sn2);
            bb = true;
        }
        this.unban(pos1);
        this.unban(pos2);
        return bb;
    }

    protected void flowFullCube(BlockPos pos2, BlockState state2) {
        if (state2 == null) {
            this.cancel = true;
            return;
        }
        FluidState fs2 = state2.func_204520_s();
        int level2 = fs2.func_206882_g();
        this.state = this.getUpdatedState(this.state, level2);
        state2 = this.getUpdatedState(state2, this.level);
        this.setState(this.pos, this.state);
        this.setState(pos2, state2);
    }

    protected BlockState getUpdatedState(BlockState state0, int newLevel) {
        return FFluidStatic.getUpdatedState(state0, newLevel, this.fluid);
    }

    protected boolean isThisFluid(Fluid f2) {
        if (this.fluid == Fluids.field_204541_a) {
            return false;
        }
        if (f2 == Fluids.field_204541_a) {
            return false;
        }
        return this.fluid.func_207187_a(f2);
    }

    protected boolean canReach(BlockPos pos1, BlockPos pos2, BlockState state1, BlockState state2) {
        if (state1 == this.nullreturnstate || state2 == this.nullreturnstate) {
            return false;
        }
        return FFluidStatic.canReach(pos1, pos2, state1, state2, this.fluid, (IBlockReader)this.w);
    }

    public static enum Mode {
        DEFAULT,
        EQUALIZER;

    }
}

