/*
 * Decompiled with CFR 0.152.
 */
package net.skds.wpo.client.models;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.skds.wpo.tileentity.PumpTileEntity;

@OnlyIn(value=Dist.CLIENT)
public class PumpRenderer
extends TileEntityRenderer<PumpTileEntity> {
    private final ModelRenderer zasos = new ModelRenderer(64, 64, 0, 0);
    private final ModelRenderer cube_r1;
    private final ModelRenderer terebilka;
    private static final ResourceLocation TEXTURE = new ResourceLocation("wpo", "textures/block/pump_te.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228638_b_((ResourceLocation)TEXTURE);

    public PumpRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.zasos.func_78793_a(8.0f, 8.0f, -8.0f);
        this.zasos.func_78784_a(1, 1).func_228303_a_(-13.0f, -13.0f, 1.0f, 10.0f, 10.0f, 15.0f, 0.0f, false);
        this.zasos.func_78784_a(0, 46).func_228303_a_(-1.0f, -11.0f, 2.0f, 1.0f, 6.0f, 12.0f, 0.0f, false);
        this.zasos.func_78784_a(0, 46).func_228303_a_(-16.0f, -11.0f, 2.0f, 1.0f, 6.0f, 12.0f, 0.0f, true);
        this.cube_r1 = new ModelRenderer(64, 64, 0, 0);
        this.cube_r1.func_78793_a(-8.0f, -8.0f, 8.0f);
        this.zasos.func_78792_a(this.cube_r1);
        this.setRotationAngle(this.cube_r1, 0.0f, 0.0f, 1.5708f);
        this.cube_r1.func_78784_a(0, 46).func_228303_a_(-8.0f, -3.0f, -6.0f, 1.0f, 6.0f, 12.0f, 0.0f, true);
        this.cube_r1.func_78784_a(0, 46).func_228303_a_(7.0f, -3.0f, -6.0f, 1.0f, 6.0f, 12.0f, 0.0f, false);
        this.terebilka = new ModelRenderer(64, 64, 0, 0);
        this.terebilka.func_78793_a(8.0f, 8.0f, -8.0f);
        this.terebilka.func_78784_a(0, 26).func_228303_a_(-15.0f, -15.0f, 12.0f, 14.0f, 14.0f, 2.0f, 0.0f, false);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void render(PumpTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RENDER_TYPE);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        Direction dir = tileEntityIn.facing;
        switch (dir) {
            case UP: {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case DOWN: {
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                break;
            }
            case EAST: {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case WEST: {
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
        }
        this.zasos.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        float partial = partialTicks;
        if (!tileEntityIn.powered) {
            partial = tileEntityIn.anim >= 0 ? 1.0f - partial : 0.0f;
        }
        float anim = (float)tileEntityIn.anim + partial;
        if (tileEntityIn.anim < 0) {
            anim += 1.0f;
        }
        float phase = (float)Math.PI * anim / (float)(tileEntityIn.animSpeed + 1);
        float offset = -((float)Math.abs(Math.cos(phase))) * 0.625f;
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)offset);
        this.terebilka.func_228308_a_(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.func_227865_b_();
    }
}

