/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.module.schematic.RepairDefinition;
import se.mickelus.tetra.module.schematic.SchematicDefinition;

public class RepairRegistry {
    private static final Logger logger = LogManager.getLogger();
    public static RepairRegistry instance;
    private Map<String, List<RepairDefinition>> repairMap;
    private List<RepairDefinition> injectedRepairs;

    public RepairRegistry() {
        instance = this;
        this.repairMap = new HashMap<String, List<RepairDefinition>>();
        this.injectedRepairs = new LinkedList<RepairDefinition>();
        DataManager.repairData.onReload(() -> this.setupDefinitions(DataManager.repairData.getData()));
    }

    public void injectFromSchematics(Collection<SchematicDefinition> schematicDefinitions) {
        this.injectedRepairs = schematicDefinitions.stream().filter(schematicDefinition -> schematicDefinition.repair).flatMap(schematicDefinition -> Arrays.stream(schematicDefinition.outcomes)).filter(RepairDefinition::validateOutcome).map(RepairDefinition::new).collect(Collectors.toList());
    }

    private void setupDefinitions(Map<ResourceLocation, RepairDefinition> data) {
        this.repairMap.clear();
        this.injectedRepairs.forEach(this::putDefinition);
        data.entrySet().stream().filter(entry -> this.validate((ResourceLocation)entry.getKey(), (RepairDefinition)entry.getValue())).forEach(entry -> this.putDefinition((RepairDefinition)entry.getValue()));
    }

    private void putDefinition(RepairDefinition definition) {
        if (definition.replace && this.repairMap.containsKey(definition.moduleVariant)) {
            this.repairMap.get(definition.moduleVariant).clear();
        }
        this.repairMap.computeIfAbsent(definition.moduleVariant, key -> new ArrayList()).add(definition);
    }

    private boolean validate(ResourceLocation identifier, RepairDefinition definition) {
        if (definition == null) {
            logger.warn("Failed to load repair definition '{}': Data is null (probably due to it failing to parse)", (Object)identifier);
            return false;
        }
        if (definition.material == null) {
            logger.warn("Failed to load repair definition '{}': material field is empty", (Object)identifier);
            return false;
        }
        if (definition.moduleKey == null) {
            logger.warn("Failed to load repair definition '{}': moduleKey field is empty", (Object)identifier);
            return false;
        }
        if (definition.moduleVariant == null) {
            logger.warn("Failed to load repair definition '{}': moduleVariant field is empty", (Object)identifier);
            return false;
        }
        return true;
    }

    public List<RepairDefinition> getDefinitions(String moduleVariant) {
        return this.repairMap.getOrDefault(moduleVariant, Collections.emptyList());
    }
}

