/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.mgui.gui.impl.GuiHorizontalLayoutGroup;
import se.mickelus.tetra.gui.stats.sorting.IStatSorter;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloDescription;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloFilterButton;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialTranslation;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloSortButton;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloVariantDetailGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloVariantListGui;
import se.mickelus.tetra.module.schematic.OutcomePreview;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class HoloSchematicGui
extends GuiElement {
    private final GuiElement listGroup;
    private final Consumer<OutcomePreview> onVariantOpen;
    private final HoloDescription description;
    private final HoloMaterialTranslation translation;
    private final HoloSortButton sortbutton;
    private final HoloFilterButton filterButton;
    private final HoloVariantListGui list;
    private HoloVariantDetailGui detail;
    private OutcomePreview openVariant;
    private OutcomePreview selectedVariant;
    private OutcomePreview hoveredVariant;
    String slot;
    private KeyframeAnimation showListAnimation;
    private KeyframeAnimation hideListAnimation;

    public HoloSchematicGui(int x, int y, int width, int height, Consumer<OutcomePreview> onVariantOpen) {
        super(x, y, width, height);
        this.onVariantOpen = onVariantOpen;
        this.listGroup = new GuiElement(0, 0, width, 64);
        this.addChild(this.listGroup);
        this.list = new HoloVariantListGui(0, 14, width, this::onVariantHover, this::onVariantBlur, this::onVariantSelect);
        this.listGroup.addChild((GuiElement)this.list);
        this.detail = new HoloVariantDetailGui(0, 68, width, onVariantOpen);
        this.addChild(this.detail);
        GuiHorizontalLayoutGroup buttons = new GuiHorizontalLayoutGroup(0, 0, 11, 6);
        this.listGroup.addChild((GuiElement)buttons);
        this.description = new HoloDescription(0, 0);
        buttons.addChild((GuiElement)this.description);
        this.translation = new HoloMaterialTranslation(0, 0);
        buttons.addChild((GuiElement)this.translation);
        this.sortbutton = new HoloSortButton(0, 0, this::onSortChange);
        buttons.addChild((GuiElement)this.sortbutton);
        this.filterButton = new HoloFilterButton(0, 0, this::onFilterChange);
        buttons.addChild((GuiElement)this.filterButton);
        this.showListAnimation = new KeyframeAnimation(60, this.listGroup).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY(0.0f)}).withDelay(100);
        this.hideListAnimation = new KeyframeAnimation(100, this.listGroup).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY(-50.0f)}).onStop(complete -> {
            if (complete.booleanValue()) {
                this.list.setVisible(false);
            }
        });
    }

    public void update(IModularItem item, String slot, UpgradeSchematic schematic) {
        OutcomePreview[] previews = schematic.getPreviews(new ItemStack((IItemProvider)item.getItem()), slot);
        this.list.update(previews);
        this.slot = slot;
        this.selectedVariant = null;
        this.hoveredVariant = null;
        this.detail.updateVariant(null, null, slot);
        this.filterButton.reset();
        this.sortbutton.update(previews);
        this.translation.update(schematic);
        this.description.update(previews);
    }

    public void openVariant(OutcomePreview variant) {
        this.openVariant = variant;
        if (variant != null) {
            this.showListAnimation.stop();
            this.hideListAnimation.start();
            this.detail.showImprovements();
        } else {
            this.hideListAnimation.stop();
            this.showListAnimation.start();
            this.list.setVisible(true);
            this.detail.hideImprovements();
        }
    }

    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        if (this.selectedVariant != null && this.openVariant == null && keyCode == 32) {
            this.onVariantOpen.accept(this.selectedVariant);
            return true;
        }
        return super.onKeyPress(keyCode, scanCode, modifiers);
    }

    private void onVariantHover(OutcomePreview outcome) {
        if (!this.sortbutton.isBlockingFocus() && this.openVariant == null) {
            this.hoveredVariant = outcome;
            this.detail.updateVariant(this.selectedVariant, this.hoveredVariant, this.slot);
        }
    }

    private void onVariantBlur(OutcomePreview outcome) {
        if (outcome.equals(this.hoveredVariant) && this.openVariant == null) {
            this.detail.updateVariant(this.selectedVariant, null, this.slot);
        }
    }

    private void onVariantSelect(OutcomePreview outcome) {
        this.selectedVariant = outcome;
        this.list.updateSelection(outcome);
        this.detail.updateVariant(this.selectedVariant, this.hoveredVariant, this.slot);
    }

    private void onFilterChange(String filter) {
        if (this.hoveredVariant != null) {
            this.detail.updateVariant(this.selectedVariant, null, this.slot);
        }
        this.list.updateFilter(filter);
    }

    private void onSortChange(IStatSorter sorter) {
        if (this.hoveredVariant != null) {
            this.detail.updateVariant(this.selectedVariant, null, this.slot);
        }
        this.list.changeSorting(sorter);
    }

    public void animateOpen() {
        this.list.onShow();
        if (this.selectedVariant != null) {
            this.detail.animateOpen();
        }
    }

    protected void onShow() {
        this.list.setVisible(true);
    }

    protected boolean onHide() {
        this.list.setVisible(false);
        this.detail.forceHide();
        this.listGroup.setY(0);
        this.listGroup.setOpacity(1.0f);
        return true;
    }
}

