/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.MaterialMultiplier;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class HoloMaterialTranslation
extends GuiElement {
    private final List<String> emptyTooltipImprovement = Collections.singletonList(I18n.func_135052_a((String)"tetra.holo.craft.empty_translation_improvement", (Object[])new Object[0]));
    private final List<String> emptyTooltip = Collections.singletonList(I18n.func_135052_a((String)"tetra.holo.craft.empty_translation_module", (Object[])new Object[0]));
    private List<String> tooltip;
    private GuiTexture icon = new GuiTexture(0, 0, 9, 9, 224, 0, GuiTextures.workbench);

    public HoloMaterialTranslation(int x, int y) {
        super(x, y, 9, 9);
        this.addChild((GuiElement)this.icon);
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return null;
    }

    public void update(UpgradeSchematic schematic) {
        MaterialMultiplier translation = schematic.getMaterialTranslation();
        if (translation != null) {
            LinkedList<String> primary = new LinkedList<String>();
            LinkedList<String> secondary = new LinkedList<String>();
            LinkedList<String> tertiary = new LinkedList<String>();
            this.extractAttributes(translation.primaryAttributes, primary);
            this.extractAttributes(translation.secondaryAttributes, secondary);
            this.extractAttributes(translation.tertiaryAttributes, tertiary);
            this.extractEffects(translation.primaryEffects, primary);
            this.extractEffects(translation.secondaryEffects, secondary);
            this.extractEffects(translation.tertiaryEffects, tertiary);
            ImmutableList.Builder result = new ImmutableList.Builder();
            if (schematic.getType() == SchematicType.improvement) {
                result.add((Object)I18n.func_135052_a((String)"tetra.holo.craft.translation_improvement", (Object[])new Object[0]));
            } else {
                result.add((Object)I18n.func_135052_a((String)"tetra.holo.craft.translation_module", (Object[])new Object[0]));
            }
            if (translation.durability != null || translation.integrity != null) {
                result.add((Object)" ");
            }
            if (translation.durability != null) {
                result.add((Object)this.getStatLine("tetra.stats.durability", translation.durability.intValue()));
            }
            if (translation.integrity != null) {
                result.add((Object)this.getStatLine("tetra.stats.integrity", translation.integrity.intValue()));
            }
            this.extractTools(translation.tools, (ImmutableList.Builder<String>)result);
            if (!primary.isEmpty()) {
                result.add((Object)" ");
                result.add((Object)(TextFormatting.WHITE + I18n.func_135052_a((String)"tetra.holo.craft.materials.stat.primary", (Object[])new Object[0]) + ":"));
                result.addAll(primary);
            }
            if (!secondary.isEmpty()) {
                result.add((Object)" ");
                result.add((Object)(TextFormatting.WHITE + I18n.func_135052_a((String)"tetra.holo.craft.materials.stat.secondary", (Object[])new Object[0]) + ":"));
                result.addAll(secondary);
            }
            if (!tertiary.isEmpty()) {
                result.add((Object)" ");
                result.add((Object)(TextFormatting.WHITE + I18n.func_135052_a((String)"tetra.holo.craft.materials.stat.tertiary", (Object[])new Object[0]) + ":"));
                result.addAll(tertiary);
            }
            this.tooltip = result.build();
        } else {
            this.tooltip = schematic.getType() == SchematicType.improvement ? this.emptyTooltipImprovement : this.emptyTooltip;
        }
    }

    private String getStatLine(String unlocalizedStat, int value) {
        return this.getStatLine(unlocalizedStat, value, null);
    }

    private String getStatLine(String unlocalizedStat, int value, String unlocalizedSuffix) {
        if (I18n.func_188566_a((String)unlocalizedStat)) {
            StringBuilder line = new StringBuilder(TextFormatting.GRAY.toString());
            line.append(I18n.func_135052_a((String)unlocalizedStat, (Object[])new Object[0]));
            if (unlocalizedSuffix != null) {
                line.append(" ");
                line.append(I18n.func_135052_a((String)unlocalizedSuffix, (Object[])new Object[0]));
            }
            if (value < 0) {
                line.append(TextFormatting.RED);
                line.append(" -");
            } else {
                line.append(TextFormatting.GREEN);
                line.append(" +");
            }
            line.append(I18n.func_135052_a((String)("enchantment.level." + Math.abs(value)), (Object[])new Object[0]));
            return line.toString();
        }
        return null;
    }

    private void extractAttributes(Multimap<Attribute, AttributeModifier> attributes, List<String> result) {
        if (attributes != null) {
            attributes.entries().stream().map(entry -> this.getStatLine(((Attribute)entry.getKey()).func_233754_c_(), (int)((AttributeModifier)entry.getValue()).func_111164_d(), ((AttributeModifier)entry.getValue()).func_220375_c() != AttributeModifier.Operation.ADDITION ? "tetra.attribute.multiplier" : null)).filter(Objects::nonNull).map(line -> "  " + line).forEach(result::add);
        }
    }

    private void extractEffects(EffectData effects, List<String> result) {
        if (effects != null) {
            effects.getValues().stream().map(effect -> this.extractEffectLevel((ItemEffect)effect, effects)).filter(Objects::nonNull).map(line -> "  " + line).forEach(result::add);
            effects.getValues().stream().map(effect -> this.extractEffectEfficiency((ItemEffect)effect, effects)).filter(Objects::nonNull).map(line -> "  " + line).forEach(result::add);
        }
    }

    private String extractEffectLevel(ItemEffect effect, EffectData effects) {
        int level = effects.getLevel(effect);
        if (level != 0) {
            String levelKey = "tetra.stats." + effect.getKey() + ".level";
            return this.getStatLine(I18n.func_188566_a((String)levelKey) ? levelKey : "tetra.stats." + effect.getKey(), level);
        }
        return null;
    }

    private String extractEffectEfficiency(ItemEffect effect, EffectData effects) {
        int efficiency = (int)effects.getEfficiency(effect);
        if (efficiency != 0) {
            return this.getStatLine("tetra.stats." + effect.getKey() + ".efficiency", efficiency);
        }
        return null;
    }

    private void extractTools(ToolData tools, ImmutableList.Builder<String> result) {
        if (tools != null) {
            result.add((Object)"");
            tools.getValues().stream().map(tool -> this.extractToolLevel((ToolType)tool, tools)).filter(Objects::nonNull).forEach(arg_0 -> result.add(arg_0));
            tools.getValues().stream().map(tool -> this.extractToolEfficiency((ToolType)tool, tools)).filter(Objects::nonNull).forEach(arg_0 -> result.add(arg_0));
        }
    }

    private String extractToolLevel(ToolType tool, ToolData toolData) {
        int level = toolData.getLevel(tool);
        if (level != 0) {
            return this.getStatLine("tetra.tool." + tool.getName(), level, "tetra.stats.tier_suffix");
        }
        return null;
    }

    private String extractToolEfficiency(ToolType tool, ToolData toolData) {
        int efficiency = (int)toolData.getEfficiency(tool);
        if (efficiency != 0) {
            return this.getStatLine("tetra.tool." + tool.getName(), efficiency, "tetra.stats.efficiency_suffix");
        }
        return null;
    }
}

