/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiItem;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringOutline;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.mgui.gui.impl.GuiHorizontalLayoutGroup;
import se.mickelus.tetra.blocks.workbench.gui.ToolRequirementGui;
import se.mickelus.tetra.gui.GuiItemRolling;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloCrossGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialEffectGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialImprovementGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialIntegrityStatGui;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloMaterialStatGui;
import se.mickelus.tetra.module.data.MaterialData;
import se.mickelus.tetra.module.data.TierData;

public class HoloMaterialDetailGui
extends GuiElement {
    private GuiElement content;
    private GuiString label;
    private GuiTexture labelHighlight;
    private GuiItemRolling icon;
    private GuiElement modifiers;
    private GuiElement requiredTools;
    private KeyframeAnimation openAnimation;
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation hideAnimation;
    private boolean hasSelected = false;

    public HoloMaterialDetailGui(int x, int y, int width) {
        super(x, y, width, 100);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addChild(new HoloCrossGui(74 + i * 40 + j % 2 * 20, j * 20 + 32, (int)(Math.random() * 800.0) + i * 1000, 0.3f - (float)i * 0.08f).setAttachment(GuiAttachment.topCenter));
                this.addChild(new HoloCrossGui(-(74 + i * 40 + j % 2 * 20), j * 20 + 32, (int)(Math.random() * 800.0) + i * 1000, 0.3f - (float)i * 0.08f).setAttachment(GuiAttachment.topCenter));
            }
        }
        this.content = new GuiElement(0, 0, width, 100);
        this.addChild(this.content);
        this.requiredTools = new GuiHorizontalLayoutGroup(0, 70, 20, 4);
        this.requiredTools.setAttachment(GuiAttachment.topCenter);
        this.content.addChild(this.requiredTools);
        this.content.addChild(new HoloMaterialStatGui(30, 20, "primary", LabelGetterBasic.singleDecimalLabel, data -> data.primary).setAttachment(GuiAttachment.topCenter));
        this.content.addChild(new HoloMaterialStatGui(50, 40, "secondary", LabelGetterBasic.singleDecimalLabel, data -> data.secondary).setAttachment(GuiAttachment.topCenter));
        this.content.addChild(new HoloMaterialStatGui(30, 60, "tertiary", LabelGetterBasic.singleDecimalLabel, data -> data.tertiary).setAttachment(GuiAttachment.topCenter));
        this.content.addChild(new HoloMaterialStatGui(70, 20, "tool_level", LabelGetterBasic.integerLabel, data -> Float.valueOf(data.toolLevel)).setAttachment(GuiAttachment.topCenter));
        this.content.addChild(new HoloMaterialStatGui(70, 60, "tool_efficiency", LabelGetterBasic.singleDecimalLabel, data -> Float.valueOf(data.toolEfficiency)).setAttachment(GuiAttachment.topCenter));
        this.content.addChild(new HoloMaterialStatGui(-30, 20, "durability", LabelGetterBasic.integerLabel, data -> Float.valueOf(data.durability)).setAttachment(GuiAttachment.topCenter));
        this.content.addChild(new HoloMaterialIntegrityStatGui(-50, 40).setAttachment(GuiAttachment.topCenter));
        this.content.addChild(new HoloMaterialStatGui(-30, 60, "magic_capacity", LabelGetterBasic.integerLabel, data -> Float.valueOf(data.magicCapacity)).setAttachment(GuiAttachment.topCenter));
        this.content.addChild(new GuiTexture(0, 40, 29, 29, 97, 0, GuiTextures.workbench).setColor(0x222222).setAttachment(GuiAttachment.topCenter));
        this.labelHighlight = new GuiTexture(0, 44, 3, 21, 110, 4, GuiTextures.workbench);
        this.labelHighlight.setOpacity(0.7f);
        this.labelHighlight.setAttachment(GuiAttachment.topCenter);
        this.content.addChild((GuiElement)this.labelHighlight);
        this.icon = new GuiItemRolling(0, 46).setCountVisibility(GuiItem.CountMode.never);
        this.icon.setAttachment(GuiAttachment.topCenter);
        this.content.addChild((GuiElement)this.icon);
        this.label = new GuiStringOutline(0, 50, "");
        this.label.setAttachment(GuiAttachment.topCenter);
        this.content.addChild((GuiElement)this.label);
        this.modifiers = new GuiElement(0, 0, 0, 0);
        this.modifiers.setAttachment(GuiAttachment.topCenter);
        this.content.addChild(this.modifiers);
        this.openAnimation = new KeyframeAnimation(80, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f), new Applier.TranslateY((float)(y - 4), (float)y)}).withDelay(120);
        this.showAnimation = new KeyframeAnimation(60, this.content).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY(0.0f)});
        this.hideAnimation = new KeyframeAnimation(60, this.content).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateY(-5.0f)}).onStop(complete -> {
            if (complete.booleanValue()) {
                this.isVisible = false;
            }
        });
    }

    public void update(MaterialData selected, MaterialData hovered) {
        MaterialData current = selected != null ? selected : hovered;
        MaterialData preview = hovered != null ? hovered : current;
        if (this.hasSelected == (selected == null)) {
            if (selected != null) {
                this.getChildren(HoloCrossGui.class).forEach(HoloCrossGui::animateOpen);
            } else {
                this.getChildren(HoloCrossGui.class).forEach(element -> {
                    element.stopAnimations();
                    element.setOpacity(0.0f);
                });
            }
        }
        boolean bl = this.hasSelected = selected != null;
        if (current != null) {
            String labelString = I18n.func_188566_a((String)("tetra.material." + preview.key)) ? I18n.func_135052_a((String)("tetra.material." + preview.key), (Object[])new Object[0]) : preview.key;
            this.label.setString(Minecraft.func_71410_x().field_71466_p.func_238412_a_(labelString, 70));
            this.labelHighlight.setColor(preview.tints.glyph);
            this.icon.setItems(preview.material.getApplicableItemStacks());
            this.requiredTools.clearChildren();
            Optional.ofNullable(preview.requiredTools).map(TierData::getLevelMap).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).map(entry -> new ToolRequirementGui(0, 0, (ToolType)entry.getKey(), "tetra.tool." + ((ToolType)entry.getKey()).getName() + ".material_requirement").setTooltipRequirementVisibility(false).updateRequirement((Integer)entry.getValue(), 0)).forEach(arg_0 -> ((GuiElement)this.requiredTools).addChild(arg_0));
            this.content.getChildren(HoloMaterialStatGui.class).forEach(stat -> stat.update(current, preview));
            this.modifiers.clearChildren();
            Set currentEffects = current.effects.getValues();
            Set previewEffects = preview.effects.getValues();
            Stream.concat(currentEffects.stream(), previewEffects.stream()).distinct().map(effect -> new HoloMaterialEffectGui(0, 0, effect.getKey(), currentEffects.contains(effect), previewEffects.contains(effect))).forEach(arg_0 -> ((GuiElement)this.modifiers).addChild(arg_0));
            Set<String> currentImprovements = current.improvements.keySet();
            Set<String> previewImprovements = preview.improvements.keySet();
            Stream.concat(currentImprovements.stream(), previewImprovements.stream()).distinct().map(improvement -> new HoloMaterialImprovementGui(0, 0, (String)improvement, currentImprovements.contains(improvement), previewImprovements.contains(improvement))).forEach(arg_0 -> ((GuiElement)this.modifiers).addChild(arg_0));
            for (int i = 0; i < this.modifiers.getNumChildren(); ++i) {
                GuiElement element2 = this.modifiers.getChild(i);
                int offset = i > 0 ? i + 3 : i + 1;
                int y = offset % 3;
                element2.setX(60 + y % 2 * 20 + offset / 3 * 40);
                element2.setY(20 + y * 20);
            }
            this.show();
        } else {
            this.hide();
        }
    }

    public void animateOpen() {
        this.openAnimation.start();
    }

    public void show() {
        this.hideAnimation.stop();
        this.setVisible(true);
        this.showAnimation.start();
    }

    public void hide() {
        this.showAnimation.stop();
        this.hideAnimation.start();
    }
}

