/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.bow;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.bow.ProjectileMotionPacket;
import se.mickelus.tetra.items.modular.impl.bow.RangedFOVTransformer;
import se.mickelus.tetra.items.modular.impl.bow.RangedProgressOverlay;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.network.PacketHandler;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.properties.TetraAttributes;
import se.mickelus.tetra.util.CastOptional;

public class ModularBowItem
extends ModularItem {
    public static final String staveKey = "bow/stave";
    public static final String stringKey = "bow/string";
    public static final String riserKey = "bow/riser";
    public static final String unlocalizedName = "modular_bow";
    protected ModuleModel arrowModel0 = new ModuleModel("draw_0", new ResourceLocation("tetra", "items/module/bow/arrow_0"));
    protected ModuleModel arrowModel1 = new ModuleModel("draw_1", new ResourceLocation("tetra", "items/module/bow/arrow_1"));
    protected ModuleModel arrowModel2 = new ModuleModel("draw_2", new ResourceLocation("tetra", "items/module/bow/arrow_2"));
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(1, 21, -11, -3);
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(-14, 23);
    public static final double velocityFactor = 0.125;
    protected ItemStack vanillaBow;
    @ObjectHolder(value="tetra:modular_bow")
    public static ModularBowItem instance;

    public ModularBowItem() {
        super(new Item.Properties().func_200917_a(1).func_234689_a_());
        this.setRegistryName(unlocalizedName);
        this.majorModuleKeys = new String[]{stringKey, staveKey};
        this.minorModuleKeys = new String[]{riserKey};
        this.requiredModules = new String[]{stringKey, staveKey};
        this.vanillaBow = new ItemStack((IItemProvider)Items.field_151031_f);
        this.updateConfig((Integer)ConfigHandler.honeBowBase.get(), (Integer)ConfigHandler.honeBowIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this));
        RemoveSchematic.registerRemoveSchematics(this);
    }

    @Override
    public void init(PacketHandler packetHandler) {
        DataManager.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("bow/");
        });
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public void clientInit() {
        super.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new RangedProgressOverlay(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new RangedFOVTransformer());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return AttributeHelper.emptyMap;
        }
        if (slot == EquipmentSlotType.MAINHAND) {
            return this.getAttributeModifiersCached(itemStack);
        }
        if (slot == EquipmentSlotType.OFFHAND) {
            return (Multimap)this.getAttributeModifiersCached(itemStack).entries().stream().filter(entry -> !((Attribute)entry.getKey()).equals(Attributes.field_233823_f_) && !((Attribute)entry.getKey()).equals(Attributes.field_233823_f_)).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, ArrayListMultimap::create));
        }
        return AttributeHelper.emptyMap;
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity entity, int timeLeft) {
        if (this.getEffectLevel(itemStack, ItemEffect.overbowed) > 0 && timeLeft <= 0) {
            entity.func_184602_cy();
            CastOptional.cast(entity, PlayerEntity.class).ifPresent(player -> player.func_184811_cZ().func_185145_a((Item)this, 10));
        } else {
            this.fireArrow(itemStack, world, entity, timeLeft);
        }
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity entity) {
        if (this.getEffectLevel(itemStack, ItemEffect.overbowed) > 0) {
            entity.func_184602_cy();
            CastOptional.cast(entity, PlayerEntity.class).ifPresent(player -> player.func_184811_cZ().func_185145_a((Item)this, 10));
        }
        return super.func_77654_b(itemStack, world, entity);
    }

    public void onUsingTick(ItemStack itemStack, LivingEntity player, int count) {
        if (this.getEffectLevel(itemStack, ItemEffect.releaseLatch) > 0 && this.getProgress(itemStack, player) >= 1.0f) {
            player.func_184597_cx();
        }
    }

    protected void fireArrow(ItemStack itemStack, World world, LivingEntity entity, int timeLeft) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack ammoStack = player.func_213356_f(this.vanillaBow);
            boolean playerInfinite = this.isInfinite(player, itemStack, ammoStack);
            int drawProgress = Math.round(this.getProgress(itemStack, entity) * 20.0f);
            if ((drawProgress = ForgeEventFactory.onArrowLoose((ItemStack)itemStack, (World)world, (PlayerEntity)player, (int)drawProgress, (!ammoStack.func_190926_b() || playerInfinite ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoStack.func_190926_b() || playerInfinite) {
                int suspendLevel;
                float velocityBonus;
                double strength;
                float projectileVelocity;
                if (ammoStack.func_190926_b()) {
                    ammoStack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                if ((projectileVelocity = ModularBowItem.getArrowVelocity(drawProgress, strength = this.getAttributeValue(itemStack, (Attribute)TetraAttributes.drawStrength.get()), velocityBonus = (float)this.getEffectLevel(itemStack, ItemEffect.velocity) / 100.0f, (suspendLevel = this.getEffectLevel(itemStack, ItemEffect.suspend)) > 0)) > 0.1f) {
                    ArrowItem ammoItem = CastOptional.cast(ammoStack.func_77973_b(), ArrowItem.class).orElse((ArrowItem)Items.field_151032_g);
                    boolean infiniteAmmo = player.field_71075_bZ.field_75098_d || ammoItem.isInfinite(ammoStack, itemStack, player);
                    int count = MathHelper.func_76125_a((int)this.getEffectLevel(itemStack, ItemEffect.multishot), (int)1, (int)(infiniteAmmo ? 64 : ammoStack.func_190916_E()));
                    if (!world.field_72995_K) {
                        double spread = this.getEffectEfficiency(itemStack, ItemEffect.multishot);
                        int powerLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)itemStack);
                        int punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)itemStack);
                        int flameLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)itemStack);
                        int piercingLevel = this.getEffectLevel(itemStack, ItemEffect.piercing);
                        for (int i = 0; i < count; ++i) {
                            double yaw = (double)player.field_70177_z - spread * (double)(count - 1) / 2.0 + spread * (double)i;
                            AbstractArrowEntity projectile = ammoItem.func_200887_a(world, ammoStack, (LivingEntity)player);
                            projectile.func_234612_a_((Entity)player, player.field_70125_A, (float)yaw, 0.0f, projectileVelocity * 3.0f, 1.0f);
                            if (drawProgress >= 20) {
                                projectile.func_70243_d(true);
                            }
                            projectile.func_70239_b(projectile.func_70242_d() - 2.0 + strength / 3.0);
                            if (powerLevel > 0) {
                                projectile.func_70239_b(projectile.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
                            }
                            if (projectileVelocity > 1.0f) {
                                projectile.func_70239_b(projectile.func_70242_d() / (double)projectileVelocity);
                            }
                            if (punchLevel > 0) {
                                projectile.func_70240_a(punchLevel);
                            }
                            if (flameLevel > 0) {
                                projectile.func_70015_d(100);
                            }
                            if (piercingLevel > 0) {
                                projectile.func_213872_b((byte)piercingLevel);
                            }
                            if (suspendLevel > 0 && drawProgress >= 20) {
                                projectile.func_189654_d(true);
                            }
                            if (infiniteAmmo || player.field_71075_bZ.field_75098_d && (ammoStack.func_77973_b() == Items.field_185166_h || ammoStack.func_77973_b() == Items.field_185167_i)) {
                                projectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                            }
                            if (suspendLevel > 0 && drawProgress >= 20) {
                                Vector3d projDir = projectile.func_213322_ci().func_72432_b();
                                Vector3d projPos = projectile.func_213303_ch();
                                for (int j = 0; j < 4; ++j) {
                                    Vector3d pos = projPos.func_178787_e(projDir.func_186678_a((double)(2 + j * 2)));
                                    ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197624_q, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), 1, 0.0, 0.0, 0.0, 0.01);
                                }
                            }
                            world.func_217376_c((Entity)projectile);
                            if (!(projectileVelocity * 3.0f > 4.0f)) continue;
                            TetraMod.packetHandler.sendToAllPlayersNear(new ProjectileMotionPacket((ProjectileEntity)projectile), projectile.func_233580_cy_(), 512.0, (RegistryKey<World>)world.func_234923_W_());
                        }
                        this.applyDamage(1, itemStack, (LivingEntity)player);
                        this.applyNegativeUsageEffects(entity, itemStack, 1.0);
                        if (drawProgress > 15) {
                            this.applyPositiveUsageEffects(entity, itemStack, 1.0);
                        }
                    }
                    float pitchBase = projectileVelocity;
                    if (velocityBonus > 0.0f) {
                        pitchBase -= pitchBase * velocityBonus;
                    } else if (suspendLevel > 0) {
                        pitchBase /= 2.0f;
                    }
                    world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.8f + projectileVelocity * 0.2f, 1.9f + field_77697_d.nextFloat() * 0.2f - pitchBase * 0.8f);
                    if (!infiniteAmmo && !player.field_71075_bZ.field_75098_d) {
                        ammoStack.func_190918_g(count);
                        if (ammoStack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(ammoStack);
                        }
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    private boolean isInfinite(PlayerEntity player, ItemStack bowStack, ItemStack ammoStack) {
        return player.field_71075_bZ.field_75098_d || ammoStack.func_190926_b() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bowStack) > 0 || CastOptional.cast(ammoStack.func_77973_b(), ArrowItem.class).map(item -> item.isInfinite(ammoStack, bowStack, player)).orElse(false) != false;
    }

    public static float getArrowVelocity(int charge, double strength, float velocityBonus, boolean suspend) {
        float velocity = (float)charge / 20.0f;
        if ((velocity = (velocity * velocity + velocity * 2.0f) / 3.0f) > 1.0f) {
            velocity = 1.0f;
        }
        velocity *= (float)Math.max(1.0, 1.0 + (strength - 6.0) * 0.125);
        velocity = suspend && charge >= 20 ? (velocity *= 2.0f) : (velocity += velocity * velocityBonus);
        return velocity;
    }

    public int getDrawDuration(ItemStack itemStack) {
        return Math.max((int)(20.0 * this.getAttributeValue(itemStack, (Attribute)TetraAttributes.drawSpeed.get())), 1);
    }

    public float getProgress(ItemStack itemStack, @Nullable LivingEntity entity) {
        return Optional.ofNullable(entity).filter(e -> e.func_184605_cv() > 0).filter(e -> itemStack.equals(e.func_184607_cu())).map(e -> Float.valueOf((float)(this.func_77626_a(itemStack) - e.func_184605_cv()) * 1.0f / (float)this.getDrawDuration(itemStack))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float getOverbowProgress(ItemStack itemStack, @Nullable LivingEntity entity) {
        int overbowedLevel = this.getEffectLevel(itemStack, ItemEffect.overbowed);
        if (overbowedLevel > 0) {
            return Optional.ofNullable(entity).filter(e -> itemStack.equals(e.func_184607_cu())).map(LivingEntity::func_184605_cv).map(useCount -> Float.valueOf(1.0f - (float)useCount.intValue() / ((float)overbowedLevel * 2.0f))).map(progress -> Float.valueOf(MathHelper.func_76131_a((float)progress.floatValue(), (float)0.0f, (float)1.0f))).orElse(Float.valueOf(0.0f)).floatValue();
        }
        return 0.0f;
    }

    public int func_77626_a(ItemStack itemStack) {
        int overbowedLevel = this.getEffectLevel(itemStack, ItemEffect.overbowed);
        if (overbowedLevel > 0) {
            return overbowedLevel * 2 + this.getDrawDuration(itemStack);
        }
        return 37000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public boolean func_77645_m() {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        boolean hasAmmo;
        ItemStack bowStack = player.func_184586_b(hand);
        boolean bl = hasAmmo = !player.func_213356_f(this.vanillaBow).func_190926_b();
        if (this.isBroken(bowStack)) {
            return ActionResult.func_226250_c_((Object)bowStack);
        }
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)bowStack, (World)world, (PlayerEntity)player, (Hand)hand, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (!hasAmmo && !player.field_71075_bZ.field_75098_d && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bowStack) <= 0) {
            return ActionResult.func_226251_d_((Object)bowStack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)bowStack);
    }

    private String getDrawVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        float progress = this.getProgress(itemStack, entity);
        if (progress == 0.0f) {
            return "item";
        }
        if ((double)progress < 0.65) {
            return "draw_0";
        }
        if ((double)progress < 0.9) {
            return "draw_1";
        }
        return "draw_2";
    }

    private ModuleModel getArrowModel(String drawVariant) {
        switch (drawVariant) {
            case "draw_0": {
                return this.arrowModel0;
            }
            case "draw_1": {
                return this.arrowModel1;
            }
            case "draw_2": {
                return this.arrowModel2;
            }
        }
        return this.arrowModel0;
    }

    @Override
    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        return super.getModelCacheKey(itemStack, entity) + ":" + this.getDrawVariant(itemStack, entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ImmutableList<ModuleModel> getModels(ItemStack itemStack, @Nullable LivingEntity entity) {
        String modelType = this.getDrawVariant(itemStack, entity);
        ImmutableList models = this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getRenderLayer)).flatMap(itemModule -> Arrays.stream(itemModule.getModels(itemStack))).filter(Objects::nonNull).filter(model -> model.type.equals(modelType) || model.type.equals("static")).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        if (!modelType.equals("item")) {
            return ImmutableList.builder().addAll((Iterable)models).add((Object)this.getArrowModel(modelType)).build();
        }
        return models;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }
}

