/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiRoot;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;

public class GuiBlockProgress
extends GuiRoot {
    private static final int width = 16;
    private GuiElement container = new GuiElement(-1, 20, 16, 2).setAttachment(GuiAttachment.middleCenter).setOpacity(0.0f);
    private GuiRect bar;
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;

    public GuiBlockProgress(Minecraft mc) {
        super(mc);
        this.addChild(this.container);
        this.container.addChild(new GuiRect(0, 0, 16, 2, 0xFFFFFF).setOpacity(0.2f));
        this.bar = new GuiRect(0, 0, 0, 2, 0xFFFFFF);
        this.bar.setOpacity(0.6f);
        this.container.addChild((GuiElement)this.bar);
        this.showAnimation = new KeyframeAnimation(60, this.container).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(0.0f)});
        this.hideAnimation = new KeyframeAnimation(100, this.container).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(-2.0f)}).withDelay(1000);
    }

    public void setProgress(float progress) {
        if (progress > 0.0f) {
            this.bar.setWidth(MathHelper.func_76125_a((int)((int)(progress * 16.0f)), (int)0, (int)16));
            if (!this.showAnimation.isActive() && this.container.getOpacity() < 1.0f) {
                this.showAnimation.start();
            }
            this.hideAnimation.stop();
        } else {
            if (!this.hideAnimation.isActive() && this.container.getOpacity() > 0.0f) {
                this.hideAnimation.start();
            }
            this.showAnimation.stop();
        }
    }

    public void draw(MatrixStack matrixStack) {
        if (this.isVisible()) {
            MainWindow window = this.mc.func_228018_at_();
            int width = window.func_198107_o();
            int height = window.func_198087_p();
            int mouseX = (int)(this.mc.field_71417_B.func_198024_e() * (double)window.func_198107_o() / (double)window.func_198105_m());
            int mouseY = (int)(this.mc.field_71417_B.func_198026_f() * (double)window.func_198087_p() / (double)window.func_198083_n());
            this.drawChildren(matrixStack, width / 2, height / 2, 0, 0, mouseX, mouseY, 1.0f);
        }
    }
}

