/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.generation.FeatureEntry;
import se.mickelus.tetra.generation.FeatureParameters;

public class TGenCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tgen").requires(source -> source.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"feature", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(TGenCommand::getFeatureSuggestions).executes(TGenCommand::generateAtPlayer)).then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).executes(TGenCommand::generateAtPos))));
    }

    private static CompletableFuture<Suggestions> getFeatureSuggestions(CommandContext context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197014_a(DataManager.featureData.getData().keySet(), (SuggestionsBuilder)builder);
    }

    private static int generateAtPlayer(CommandContext<CommandSource> context) {
        BlockPos pos = new BlockPos(((CommandSource)context.getSource()).func_197036_d());
        TGenCommand.generate(ResourceLocationArgument.func_197195_e(context, (String)"feature"), (ISeedReader)((CommandSource)context.getSource()).func_197023_e(), pos, ((CommandSource)context.getSource()).func_197023_e().func_72905_C());
        return 1;
    }

    private static int generateAtPos(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TGenCommand.generate(ResourceLocationArgument.func_197195_e(context, (String)"feature"), (ISeedReader)((CommandSource)context.getSource()).func_197023_e(), BlockPosArgument.func_197274_b(context, (String)"pos"), ((CommandSource)context.getSource()).func_197023_e().func_72905_C());
        return 1;
    }

    private static void generate(ResourceLocation featureLocation, ISeedReader world, BlockPos pos, long seed) throws CommandException {
        FeatureParameters feature = DataManager.featureData.getData(featureLocation);
        if (feature != null) {
            ChunkPos chunkPos = new ChunkPos(pos);
            Random random = new Random(seed);
            long xSeed = random.nextLong() >> 3;
            long zSeed = random.nextLong() >> 3;
            long chunkSeed = xSeed * (long)chunkPos.field_77276_a + zSeed * (long)chunkPos.field_77275_b ^ seed;
            random.setSeed(chunkSeed);
            FeatureEntry.instance.generateFeatureRoot(feature, world, pos, random);
        }
    }
}

