/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;

public class OverpowerEffect
extends ChargedAbilityEffect {
    private static Cache<Integer, DelayData> delayCache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static final OverpowerEffect instance = new OverpowerEffect();

    OverpowerEffect() {
        super(10, 1.0, 10, 1.0, ItemEffect.overpower, ChargedAbilityEffect.TargetRequirement.none, UseAction.SPEAR, "raised");
    }

    @Override
    public void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, @Nullable LivingEntity target, @Nullable BlockPos targetPos, @Nullable Vector3d hitVec, int chargedTicks) {
        super.perform(attacker, hand, item, itemStack, target, targetPos, hitVec, chargedTicks);
        boolean isDefensive = this.isDefensive(item, itemStack, hand);
        int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        boolean overextended = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend) > 0;
        double exhaustDuration = item.getEffectEfficiency(itemStack, ItemEffect.overpower);
        if (!attacker.field_70170_p.field_72995_K && !isDefensive) {
            double comboEfficiency;
            int currentAmp = Optional.ofNullable(attacker.func_70660_b((Effect)ExhaustedPotionEffect.instance)).map(EffectInstance::func_76458_c).orElse(-1);
            int newAmp = 1;
            if (overchargeBonus > 0) {
                newAmp += (int)((double)overchargeBonus * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge));
            }
            if ((comboEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityCombo)) > 0.0 && (double)attacker.func_130014_f_().func_201674_k().nextFloat() < comboEfficiency * (double)ComboPoints.get((Entity)attacker) / 100.0) {
                --newAmp;
                Random rand = attacker.func_130014_f_().func_201674_k();
                ((ServerWorld)attacker.func_130014_f_()).func_195598_a((IParticleData)ParticleTypes.field_197632_y, attacker.func_226277_ct_(), attacker.func_226278_cu_() + (double)(attacker.func_213302_cg() / 2.0f), attacker.func_226281_cx_(), 10, rand.nextGaussian() * 0.3, rand.nextGaussian() * (double)attacker.func_213302_cg() * 0.8, rand.nextGaussian() * 0.3, (double)0.1f);
            }
            if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
                --newAmp;
            }
            if (overextended && !attacker.func_71024_bL().func_75121_c()) {
                newAmp = -1;
            }
            if (newAmp > 0) {
                int echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
                if (echoLevel > 0) {
                    this.delayExhaustion(attacker, item, itemStack, (int)(exhaustDuration * 20.0), newAmp);
                } else {
                    attacker.func_195064_c(new EffectInstance((Effect)ExhaustedPotionEffect.instance, (int)(exhaustDuration * 20.0), newAmp + currentAmp, false, true));
                }
            }
        }
        attacker.func_71020_j(overextended ? 6.0f : 1.0f);
        attacker.func_226292_a_(hand, false);
        int cooldown = this.getCooldown(item, itemStack);
        if (isDefensive) {
            cooldown = (int)((double)cooldown * (1.0 + item.getEffectEfficiency(itemStack, ItemEffect.abilityDefensive) / 100.0));
        }
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
        if (revengeLevel > 0) {
            RevengeTracker.removeEnemy((Entity)attacker, (Entity)target);
        }
        attacker.func_184811_cZ().func_185145_a((Item)item, cooldown);
    }

    @Override
    public void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vector3d hitVec, int chargedTicks) {
        AbilityUseResult result;
        int comboLevel;
        boolean isDefensive = this.isDefensive(item, itemStack, hand);
        int overchargeBonus = this.canOvercharge(item, itemStack) ? this.getOverchargeBonus(item, itemStack, chargedTicks) : 0;
        int revengeLevel = item.getEffectLevel(itemStack, ItemEffect.abilityRevenge);
        double damageMultiplier = (float)item.getEffectLevel(itemStack, isDefensive ? ItemEffect.abilityDefensive : ItemEffect.overpower) / 100.0f;
        double efficiency = item.getEffectEfficiency(itemStack, ItemEffect.overpower);
        if (overchargeBonus > 0) {
            damageMultiplier += (double)(overchargeBonus * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0;
        }
        if ((comboLevel = item.getEffectLevel(itemStack, ItemEffect.abilityCombo)) > 0) {
            damageMultiplier += (double)(comboLevel * ComboPoints.get((Entity)attacker)) / 100.0;
        }
        if (revengeLevel > 0 && RevengeTracker.canRevenge((Entity)attacker, (Entity)target)) {
            damageMultiplier += (double)revengeLevel / 100.0;
        }
        if ((result = item.hitEntity(itemStack, attacker, target, damageMultiplier, 0.1f, 0.1f)) != AbilityUseResult.fail) {
            int exhilarationLevel;
            int momentumLevel;
            int currentAmplifier = Optional.ofNullable(target.func_70660_b((Effect)ExhaustedPotionEffect.instance)).map(EffectInstance::func_76458_c).orElse(-1);
            int amplifier = currentAmplifier + 2;
            if (isDefensive) {
                --amplifier;
            }
            if (overchargeBonus > 0) {
                amplifier += (int)((double)overchargeBonus * item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge));
            }
            if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0 && currentAmplifier > -1) {
                double momentumEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum);
                double velocity = (double)momentumLevel / 100.0;
                velocity += momentumEfficiency * (double)(currentAmplifier + 1);
                velocity += momentumEfficiency * (double)Optional.ofNullable(attacker.func_70660_b((Effect)ExhaustedPotionEffect.instance)).map(EffectInstance::func_76458_c).map(amp -> amp + 1).orElse(0).intValue();
                if ((velocity *= 1.0 - target.func_233637_b_(Attributes.field_233820_c_)) > 0.0) {
                    target.func_70024_g(0.0, velocity, 0.0);
                }
            }
            if ((exhilarationLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0 && !target.func_70089_S()) {
                ServerScheduler.schedule(0, () -> attacker.func_195063_d((Effect)ExhaustedPotionEffect.instance));
            }
            target.func_195064_c(new EffectInstance((Effect)ExhaustedPotionEffect.instance, (int)(efficiency * 20.0), amplifier, false, true));
            target.func_130014_f_().func_184133_a(attacker, target.func_233580_cy_(), SoundEvents.field_187718_dS, SoundCategory.PLAYERS, 1.0f, 0.8f);
        } else {
            target.func_130014_f_().func_184133_a(attacker, target.func_233580_cy_(), SoundEvents.field_187733_dX, SoundCategory.PLAYERS, 1.0f, 0.8f);
        }
        item.tickProgression((LivingEntity)attacker, itemStack, result == AbilityUseResult.fail ? 1 : 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private void delayExhaustion(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack, int duration, int amplifier) {
        int delay = this.getChargeTime(item, itemStack) + this.getCooldown(item, itemStack) + item.getEffectLevel(itemStack, ItemEffect.abilityEcho);
        try {
            DelayData data = (DelayData)delayCache.get((Object)attacker.func_145782_y(), DelayData::new);
            data.timestamp = attacker.field_70170_p.func_82737_E() + (long)delay;
            data.amplifier += amplifier;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        ServerScheduler.schedule(delay + 1, () -> {
            DelayData data = (DelayData)delayCache.getIfPresent((Object)attacker.func_145782_y());
            if (attacker.func_70089_S() && attacker.field_70170_p != null && data != null && attacker.field_70170_p.func_82737_E() > data.timestamp) {
                int currentAmp = Optional.ofNullable(attacker.func_70660_b((Effect)ExhaustedPotionEffect.instance)).map(EffectInstance::func_76458_c).orElse(-1);
                attacker.func_195064_c(new EffectInstance((Effect)ExhaustedPotionEffect.instance, duration, currentAmp + data.amplifier, false, true));
                delayCache.invalidate((Object)attacker.func_145782_y());
            }
        });
    }

    static class DelayData {
        int amplifier;
        long timestamp;

        DelayData() {
        }
    }
}

