/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.util.CastOptional;

public class CritEffect {
    private static final Cache<UUID, BlockPos> critBlockCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public static boolean critBlock(World world, PlayerEntity breakingPlayer, BlockPos pos, BlockState blockState, ItemStack itemStack, int critLevel) {
        BlockPos recentCritPos = (BlockPos)critBlockCache.getIfPresent((Object)breakingPlayer.func_110124_au());
        if (pos.equals((Object)recentCritPos)) {
            return true;
        }
        if ((double)breakingPlayer.func_70681_au().nextFloat() < (double)critLevel * 0.01 && recentCritPos == null && blockState.func_185887_b((IBlockReader)world, pos) > -1.0f && itemStack.func_77973_b().func_150893_a(itemStack, blockState) > 2.0f * blockState.func_185887_b((IBlockReader)world, pos)) {
            ToolType tool = blockState.getHarvestTool();
            int toolLevel = itemStack.func_77973_b().getHarvestLevel(itemStack, tool, breakingPlayer, blockState);
            if (toolLevel >= 0 && toolLevel >= blockState.func_177230_c().getHarvestLevel(blockState) || itemStack.func_150998_b(blockState)) {
                EffectHelper.breakBlock(world, breakingPlayer, itemStack, pos, blockState, true);
                itemStack.func_77973_b().func_179218_a(itemStack, world, blockState, pos, (LivingEntity)breakingPlayer);
                critBlockCache.put((Object)breakingPlayer.func_110124_au(), (Object)pos);
                CastOptional.cast(breakingPlayer, ServerPlayerEntity.class).ifPresent(serverPlayer -> EffectHelper.sendEventToPlayer(serverPlayer, 2001, pos, Block.func_196246_j((BlockState)blockState)));
                if (world instanceof ServerWorld) {
                    ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197622_o, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 12, (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 0.3, 0.3 + world.field_73012_v.nextDouble() * 0.3, (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 0.3, 0.3);
                }
                return true;
            }
        }
        return false;
    }

    public static void onBlockBreak(LivingEntity entity) {
        critBlockCache.invalidate((Object)entity.func_110124_au());
    }

    public static void critEntity(CriticalHitEvent event, ItemStack itemStack, int critLevel) {
        if ((double)event.getEntityLiving().func_70681_au().nextFloat() < (double)critLevel * 0.01) {
            event.setDamageModifier(Math.max((float)EffectHelper.getEffectEfficiency(itemStack, ItemEffect.criticalStrike), event.getDamageModifier()));
            event.setResult(Event.Result.ALLOW);
        }
    }

    public static double rollMultiplier(Random random, IModularItem item, ItemStack itemStack) {
        int critLevel = item.getEffectLevel(itemStack, ItemEffect.criticalStrike);
        if (critLevel > 0 && (double)random.nextFloat() < (double)critLevel * 0.01) {
            return item.getEffectEfficiency(itemStack, ItemEffect.criticalStrike);
        }
        return 1.0;
    }
}

