/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.network.AbstractPacket;

public class WorkbenchPacketUpdate
extends AbstractPacket {
    private BlockPos pos;
    private UpgradeSchematic schematic;
    private String selectedSlot;

    public WorkbenchPacketUpdate() {
    }

    public WorkbenchPacketUpdate(BlockPos pos, UpgradeSchematic schematic, String selectedSlot) {
        this.pos = pos;
        this.schematic = schematic;
        this.selectedSlot = selectedSlot;
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
        try {
            if (this.schematic != null) {
                WorkbenchPacketUpdate.writeString(this.schematic.getKey(), buffer);
            } else {
                WorkbenchPacketUpdate.writeString("", buffer);
            }
            if (this.selectedSlot != null) {
                WorkbenchPacketUpdate.writeString(this.selectedSlot, buffer);
            } else {
                WorkbenchPacketUpdate.writeString("", buffer);
            }
        }
        catch (IOException exception) {
            System.err.println("An error occurred when writing schematic name to packet buffer");
        }
    }

    @Override
    public void fromBytes(PacketBuffer buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.pos = new BlockPos(x, y, z);
        try {
            String schematicKey = WorkbenchPacketUpdate.readString(buffer);
            this.schematic = SchematicRegistry.getSchematic(schematicKey);
            this.selectedSlot = WorkbenchPacketUpdate.readString(buffer);
            if ("".equals(this.selectedSlot)) {
                this.selectedSlot = null;
            }
        }
        catch (IOException exception) {
            System.err.println("An error occurred when reading schematic name from packet buffer");
        }
    }

    @Override
    public void handle(PlayerEntity player) {
        WorkbenchTile workbench = (WorkbenchTile)player.field_70170_p.func_175625_s(this.pos);
        if (workbench != null) {
            workbench.update(this.schematic, this.selectedSlot, player);
        }
    }
}

